/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PropertyValueException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.event.def.EventCache;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class DefaultMergeEventListener
extends AbstractSaveEventListener
implements MergeEventListener {
    private static final Log log = LogFactory.getLog(DefaultMergeEventListener.class);

    protected Map getMergeMap(Object anything) {
        return ((EventCache)anything).invertMap();
    }

    public void onMerge(MergeEvent event) throws HibernateException {
        EventCache copyCache = new EventCache();
        this.onMerge(event, copyCache);
        EventCache transientCopyCache = this.getTransientCopyCache(event, copyCache);
        if (transientCopyCache.size() > 0) {
            this.retryMergeTransientEntities(event, transientCopyCache, copyCache);
            transientCopyCache = this.getTransientCopyCache(event, copyCache);
            if (transientCopyCache.size() > 0) {
                HashSet<String> transientEntityNames = new HashSet<String>();
                for (Object transientEntity : transientCopyCache.keySet()) {
                    String transientEntityName = event.getSession().guessEntityName(transientEntity);
                    transientEntityNames.add(transientEntityName);
                    log.trace((Object)("transient instance could not be processed by merge: " + transientEntityName + "[" + transientEntity + "]"));
                }
                throw new TransientObjectException("one or more objects is an unsaved transient instance - save transient instance(s) before merging: " + transientEntityNames);
            }
        }
        copyCache.clear();
        copyCache = null;
    }

    protected EventCache getTransientCopyCache(MergeEvent event, EventCache copyCache) {
        EventCache transientCopyCache = new EventCache();
        for (Map.Entry mapEntry : copyCache.entrySet()) {
            EntityEntry copyEntry;
            Object entity = mapEntry.getKey();
            Object copy = mapEntry.getValue();
            if (copy instanceof HibernateProxy) {
                copy = ((HibernateProxy)copy).getHibernateLazyInitializer().getImplementation();
            }
            if ((copyEntry = event.getSession().getPersistenceContext().getEntry(copy)) == null) {
                log.trace((Object)("transient instance could not be processed by merge: " + event.getSession().guessEntityName(copy) + "[" + entity + "]"));
                throw new TransientObjectException("object is an unsaved transient instance - save the transient instance before merging: " + event.getSession().guessEntityName(copy));
            }
            if (copyEntry.getStatus() == Status.SAVING) {
                transientCopyCache.put(entity, copy, copyCache.isOperatedOn(entity));
                continue;
            }
            if (copyEntry.getStatus() == Status.MANAGED || copyEntry.getStatus() == Status.READ_ONLY) continue;
            throw new AssertionFailure("Merged entity does not have status set to MANAGED or READ_ONLY; " + copy + " status=" + copyEntry.getStatus());
        }
        return transientCopyCache;
    }

    protected void retryMergeTransientEntities(MergeEvent event, Map transientCopyCache, EventCache copyCache) {
        for (Map.Entry mapEntry : transientCopyCache.entrySet()) {
            Object entity = mapEntry.getKey();
            Object copy = transientCopyCache.get(entity);
            EntityEntry copyEntry = event.getSession().getPersistenceContext().getEntry(copy);
            if (entity == event.getEntity()) {
                this.mergeTransientEntity(entity, copyEntry.getEntityName(), event.getRequestedId(), event.getSession(), copyCache);
                continue;
            }
            this.mergeTransientEntity(entity, copyEntry.getEntityName(), copyEntry.getId(), event.getSession(), copyCache);
        }
    }

    public void onMerge(MergeEvent event, Map copiedAlready) throws HibernateException {
        EventCache copyCache = (EventCache)copiedAlready;
        EventSource source = event.getSession();
        Object original = event.getOriginal();
        if (original != null) {
            Object entity;
            if (original instanceof HibernateProxy) {
                LazyInitializer li = ((HibernateProxy)original).getHibernateLazyInitializer();
                if (li.isUninitialized()) {
                    log.trace((Object)"ignoring uninitialized proxy");
                    event.setResult(source.load(li.getEntityName(), li.getIdentifier()));
                    return;
                }
                entity = li.getImplementation();
            } else {
                entity = original;
            }
            if (copyCache.containsKey(entity) && copyCache.isOperatedOn(entity)) {
                log.trace((Object)"already in merge process");
                event.setResult(entity);
            } else {
                EntityPersister persister;
                Serializable id;
                if (copyCache.containsKey(entity)) {
                    log.trace((Object)"already in copyCache; setting in merge process");
                    copyCache.setOperatedOn(entity, true);
                }
                event.setEntity(entity);
                int entityState = -1;
                EntityEntry entry = source.getPersistenceContext().getEntry(entity);
                if (entry == null && (id = (persister = source.getEntityPersister(event.getEntityName(), entity)).getIdentifier(entity, source.getEntityMode())) != null) {
                    EntityKey key = new EntityKey(id, persister, source.getEntityMode());
                    Object managedEntity = source.getPersistenceContext().getEntity(key);
                    entry = source.getPersistenceContext().getEntry(managedEntity);
                    if (entry != null) {
                        entityState = 2;
                    }
                }
                if (entityState == -1) {
                    entityState = this.getEntityState(entity, event.getEntityName(), entry, source);
                }
                switch (entityState) {
                    case 2: {
                        this.entityIsDetached(event, copyCache);
                        break;
                    }
                    case 1: {
                        this.entityIsTransient(event, copyCache);
                        break;
                    }
                    case 0: {
                        this.entityIsPersistent(event, copyCache);
                        break;
                    }
                    default: {
                        throw new ObjectDeletedException("deleted instance passed to merge", null, this.getLoggableName(event.getEntityName(), entity));
                    }
                }
            }
        }
    }

    protected void entityIsPersistent(MergeEvent event, Map copyCache) {
        log.trace((Object)"ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        ((EventCache)copyCache).put(entity, entity, true);
        this.cascadeOnMerge(source, persister, entity, copyCache);
        this.copyValues(persister, entity, entity, source, copyCache);
        event.setResult(entity);
    }

    protected void entityIsTransient(MergeEvent event, Map copyCache) {
        log.trace((Object)"merging transient instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        event.setResult(this.mergeTransientEntity(entity, entityName, event.getRequestedId(), source, copyCache));
    }

    protected Object mergeTransientEntity(Object entity, String entityName, Serializable requestedId, EventSource source, Map copyCache) {
        Serializable id;
        log.trace((Object)"merging transient instance");
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        Serializable serializable = id = persister.hasIdentifierProperty() ? persister.getIdentifier(entity, source.getEntityMode()) : null;
        if (copyCache.containsKey(entity)) {
            persister.setIdentifier(copyCache.get(entity), id, source.getEntityMode());
        } else {
            ((EventCache)copyCache).put(entity, persister.instantiate(id, source.getEntityMode()), true);
        }
        Object copy = copyCache.get(entity);
        super.cascadeBeforeSave(source, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, source, copyCache, ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT);
        try {
            if (requestedId == null) {
                this.saveWithGeneratedId(copy, entityName, copyCache, source, false);
            } else {
                this.saveWithRequestedId(copy, requestedId, entityName, copyCache, source);
            }
        }
        catch (PropertyValueException ex) {
            String propertyName = ex.getPropertyName();
            Object propertyFromCopy = persister.getPropertyValue(copy, propertyName, source.getEntityMode());
            Object propertyFromEntity = persister.getPropertyValue(entity, propertyName, source.getEntityMode());
            Type propertyType = persister.getPropertyType(propertyName);
            EntityEntry copyEntry = source.getPersistenceContext().getEntry(copy);
            if (propertyFromCopy == null || !propertyType.isEntityType()) {
                log.trace((Object)("property '" + copyEntry.getEntityName() + "." + propertyName + "' is null or not an entity; " + propertyName + " =[" + propertyFromCopy + "]"));
                throw ex;
            }
            if (!copyCache.containsKey(propertyFromEntity)) {
                log.trace((Object)("property '" + copyEntry.getEntityName() + "." + propertyName + "' from original entity is not in copyCache; " + propertyName + " =[" + propertyFromEntity + "]"));
                throw ex;
            }
            if (((EventCache)copyCache).isOperatedOn(propertyFromEntity)) {
                log.trace((Object)("property '" + copyEntry.getEntityName() + "." + propertyName + "' from original entity is in copyCache and is in the process of being merged; " + propertyName + " =[" + propertyFromEntity + "]"));
            }
            log.trace((Object)("property '" + copyEntry.getEntityName() + "." + propertyName + "' from original entity is in copyCache and is not in the process of being merged; " + propertyName + " =[" + propertyFromEntity + "]"));
        }
        super.cascadeAfterSave(source, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, source, copyCache, ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        return copy;
    }

    protected void entityIsDetached(MergeEvent event, Map copyCache) {
        log.trace((Object)"merging detached instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        Serializable id = event.getRequestedId();
        if (id == null) {
            id = persister.getIdentifier(entity, source.getEntityMode());
        } else {
            Serializable entityId = persister.getIdentifier(entity, source.getEntityMode());
            if (!persister.getIdentifierType().isEqual(id, entityId, source.getEntityMode(), source.getFactory())) {
                throw new HibernateException("merge requested with id not matching id of passed entity");
            }
        }
        String previousFetchProfile = source.getFetchProfile();
        source.setFetchProfile("merge");
        Serializable clonedIdentifier = (Serializable)persister.getIdentifierType().deepCopy(id, source.getEntityMode(), source.getFactory());
        Object result = source.get(entityName, clonedIdentifier);
        source.setFetchProfile(previousFetchProfile);
        if (result == null) {
            this.entityIsTransient(event, copyCache);
        } else {
            ((EventCache)copyCache).put(entity, result, true);
            Object target = source.getPersistenceContext().unproxy(result);
            if (target == entity) {
                throw new AssertionFailure("entity was not detached");
            }
            if (!source.getEntityName(target).equals(entityName)) {
                throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
            }
            if (this.isVersionChanged(entity, source, persister, target)) {
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().optimisticFailure(entityName);
                }
                throw new StaleObjectStateException(entityName, id);
            }
            this.cascadeOnMerge(source, persister, entity, copyCache);
            this.copyValues(persister, entity, target, source, copyCache);
            this.markInterceptorDirty(entity, target);
            event.setResult(result);
        }
    }

    private void markInterceptorDirty(Object entity, Object target) {
        FieldInterceptor interceptor;
        if (FieldInterceptionHelper.isInstrumented(entity) && (interceptor = FieldInterceptionHelper.extractFieldInterceptor(target)) != null) {
            interceptor.dirty();
        }
    }

    private boolean isVersionChanged(Object entity, EventSource source, EntityPersister persister, Object target) {
        if (!persister.isVersioned()) {
            return false;
        }
        boolean changed = !persister.getVersionType().isSame(persister.getVersion(target, source.getEntityMode()), persister.getVersion(entity, source.getEntityMode()), source.getEntityMode());
        return changed && this.existsInDatabase(target, source, persister);
    }

    private boolean existsInDatabase(Object entity, EventSource source, EntityPersister persister) {
        Serializable id;
        EntityEntry entry = source.getPersistenceContext().getEntry(entity);
        if (entry == null && (id = persister.getIdentifier(entity, source.getEntityMode())) != null) {
            EntityKey key = new EntityKey(id, persister, source.getEntityMode());
            Object managedEntity = source.getPersistenceContext().getEntity(key);
            entry = source.getPersistenceContext().getEntry(managedEntity);
        }
        if (entry == null) {
            return false;
        }
        return entry.isExistsInDatabase();
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache) {
        Object[] copiedValues = TypeFactory.replace(persister.getPropertyValues(entity, source.getEntityMode()), persister.getPropertyValues(target, source.getEntityMode()), persister.getPropertyTypes(), source, target, copyCache);
        persister.setPropertyValues(target, copiedValues, source.getEntityMode());
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copiedValues = foreignKeyDirection == ForeignKeyDirection.FOREIGN_KEY_TO_PARENT ? TypeFactory.replaceAssociations(persister.getPropertyValues(entity, source.getEntityMode()), persister.getPropertyValues(target, source.getEntityMode()), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection) : TypeFactory.replace(persister.getPropertyValues(entity, source.getEntityMode()), persister.getPropertyValues(target, source.getEntityMode()), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection);
        persister.setPropertyValues(target, copiedValues, source.getEntityMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource source, EntityPersister persister, Object entity, Map copyCache) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 0, source).cascade(persister, entity, copyCache);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.MERGE;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.FALSE;
    }

    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
    }

    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
    }
}

