/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashSet;
import java.util.Set;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.impl.message.MessageFactory;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;

class MessageRequest
extends ClusterRequest {
    private String routingConditionText;
    private Message message;
    private Set queueNames;

    MessageRequest() {
    }

    MessageRequest(String routingConditionText, Message message, Set queueNames) {
        this.routingConditionText = routingConditionText;
        this.message = message;
        this.queueNames = queueNames;
    }

    Object execute(RequestTarget office) throws Exception {
        office.routeFromCluster(this.message, this.routingConditionText, this.queueNames);
        return null;
    }

    byte getType() {
        return 5;
    }

    public void read(DataInputStream in) throws Exception {
        this.routingConditionText = in.readUTF();
        byte type = in.readByte();
        this.message = MessageFactory.createMessage(type);
        this.message.read(in);
        byte b = in.readByte();
        if (b != 0) {
            int size = in.readInt();
            this.queueNames = new HashSet(size);
            for (int i = 0; i < size; ++i) {
                String queueName = in.readUTF();
                this.queueNames.add(queueName);
            }
        }
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeUTF(this.routingConditionText);
        out.writeByte(this.message.getType());
        this.message.write(out);
        if (this.queueNames == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(this.queueNames.size());
            for (String queueName : this.queueNames) {
                out.writeUTF(queueName);
            }
        }
    }
}

