/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

public class RotatingID {
    private short count;
    private long lastTime = System.currentTimeMillis();
    private final long nodeID;
    private final long id1;

    public RotatingID(int nodeID) {
        if (nodeID < 0 || nodeID > 1023) {
            throw new IllegalArgumentException("node id must be between 0 to 1023 inclusive, wrong id: " + nodeID);
        }
        this.nodeID = nodeID;
        this.id1 = this.nodeID << 54;
    }

    public synchronized long getID() {
        long id2 = System.currentTimeMillis() << 12 & 0x3FFFFFFFFF8000L;
        long id = this.id1 | id2 | (long)this.count;
        if (this.count == Short.MAX_VALUE) {
            this.count = 0;
            long now = System.currentTimeMillis();
            while (now <= this.lastTime + 8L) {
                try {
                    Thread.sleep(8L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            this.lastTime = now;
        } else {
            this.count = (short)(this.count + 1);
        }
        return id;
    }
}

