/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.util.HashMap;
import javax.jms.JMSException;
import org.jboss.jms.message.JBossMessage;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.impl.OrderingGroup;

public class OrderingGroupMonitor {
    private HashMap<String, OrderingGroup> orderingGroups = new HashMap();
    private static final Logger log = Logger.getLogger(OrderingGroupMonitor.class);
    public static final int OK = 0;
    public static final int NOT_OK_NOT_FIRST = 1;
    public static final int NOT_OK_BEING_SENT = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessage(MessageReference ref) {
        String grpName = OrderingGroupMonitor.extractGroupName(ref);
        if (grpName == null) {
            return;
        }
        HashMap<String, OrderingGroup> hashMap = this.orderingGroups;
        synchronized (hashMap) {
            OrderingGroup group = this.orderingGroups.get(grpName);
            if (group == null) {
                group = new OrderingGroup(grpName);
                this.orderingGroups.put(grpName, group);
            }
            group.register(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isAvailable(MessageReference ref) {
        int result = 0;
        String grpName = OrderingGroupMonitor.extractGroupName(ref);
        if (grpName != null) {
            HashMap<String, OrderingGroup> hashMap = this.orderingGroups;
            synchronized (hashMap) {
                OrderingGroup group = this.orderingGroups.get(grpName);
                if (group != null) {
                    result = group.isAvailable(ref);
                }
            }
        } else {
            log.debug((Object)"message doesn't have group prop, fine by me");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean messageCompleted(MessageReference ref) {
        String grpName = OrderingGroupMonitor.extractGroupName(ref);
        if (grpName == null) {
            return false;
        }
        HashMap<String, OrderingGroup> hashMap = this.orderingGroups;
        synchronized (hashMap) {
            OrderingGroup group = this.orderingGroups.get(grpName);
            if (group != null) {
                group.unregister(ref);
            }
            return this.hasMessageInQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessageInQueue() {
        boolean result = false;
        HashMap<String, OrderingGroup> hashMap = this.orderingGroups;
        synchronized (hashMap) {
            for (OrderingGroup group : this.orderingGroups.values()) {
                if (!group.hasPendingMessage()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmarkSending(MessageReference ref) {
        String grpName = OrderingGroupMonitor.extractGroupName(ref);
        if (grpName == null) {
            return;
        }
        HashMap<String, OrderingGroup> hashMap = this.orderingGroups;
        synchronized (hashMap) {
            OrderingGroup group = this.orderingGroups.get(grpName);
            if (group != null) {
                group.unregister(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSending(MessageReference ref) {
        String grpName = OrderingGroupMonitor.extractGroupName(ref);
        if (grpName != null) {
            HashMap<String, OrderingGroup> hashMap = this.orderingGroups;
            synchronized (hashMap) {
                OrderingGroup group = this.orderingGroups.get(grpName);
                if (group != null) {
                    group.markSending(ref);
                }
            }
        }
    }

    private static String extractGroupName(MessageReference ref) {
        String name = null;
        try {
            JBossMessage msg;
            Message obj = ref.getMessage();
            if (obj instanceof JBossMessage && (msg = (JBossMessage)ref.getMessage()) != null) {
                name = msg.getStringProperty("JBM_ORDERING_GROUP_ID");
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return name;
    }

    public static boolean isOrderingGroupMessage(MessageReference ref) {
        return OrderingGroupMonitor.extractGroupName(ref) != null;
    }
}

