/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.bridge;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.jms.client.JBossSession;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.server.bridge.ConnectionFactoryFactory;
import org.jboss.jms.server.bridge.DestinationFactory;
import org.jboss.jms.server.bridge.JNDIConnectionFactoryFactory;
import org.jboss.jms.server.bridge.JNDIDestinationFactory;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.tm.TransactionManagerLocator;

public class Bridge
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(Bridge.class);
    private static boolean trace = log.isTraceEnabled();
    public static final int QOS_AT_MOST_ONCE = 0;
    public static final int QOS_DUPLICATES_OK = 1;
    public static final int QOS_ONCE_AND_ONLY_ONCE = 2;
    private String name;
    private String sourceUsername;
    private String sourcePassword;
    private String targetUsername;
    private String targetPassword;
    private TransactionManager tm;
    private String selector;
    private long failureRetryInterval;
    private int maxRetries;
    private int qualityOfServiceMode;
    private int maxBatchSize;
    private long maxBatchTime;
    private String subName;
    private String clientID;
    private volatile boolean addMessageIDInHeader;
    private boolean started;
    private LinkedList<Message> messages = new LinkedList();
    private Object lock = new Object();
    private String sourceCffName;
    private String targetCffName;
    private Properties sourceProviderProperties;
    private Properties targetProviderProperties;
    private String sourceDestName;
    private String targetDestName;
    private boolean isSameSourceAndTarget;
    private String sourceQueueCffName;
    private String sourceTopicCffName;
    private String targetQueueCffName;
    private String targetTopicCffName;
    private ConnectionFactoryFactory sourceCff;
    private ConnectionFactoryFactory targetCff;
    private DestinationFactory sourceDestinationFactory;
    private DestinationFactory targetDestinationFactory;
    private Connection sourceConn;
    private Connection targetConn;
    private Destination sourceDestination;
    private Destination targetDestination;
    private Session sourceSession;
    private Session targetSession;
    private MessageConsumer consumer;
    private MessageProducer producer;
    private BatchTimeChecker timeChecker;
    private Thread checkerThread;
    private long batchExpiryTime;
    private boolean paused;
    private Transaction tx;
    private boolean failed;
    private int forwardMode;
    private static final int FORWARD_MODE_XA = 0;
    private static final int FORWARD_MODE_LOCALTX = 1;
    private static final int FORWARD_MODE_NONTX = 2;

    public Bridge() {
    }

    public Bridge(boolean sameSourceNTarget, Properties srcProps, Properties tarProps, String srcDestName, String tarDestName, String qCffName, String tCffName, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, int qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID, boolean addMessageIDInHeader) {
        this();
        this.isSameSourceAndTarget = sameSourceNTarget;
        this.sourceProviderProperties = srcProps;
        this.targetProviderProperties = tarProps;
        this.sourceDestName = srcDestName;
        this.targetDestName = tarDestName;
        this.sourceQueueCffName = qCffName;
        this.sourceTopicCffName = qCffName;
        this.targetQueueCffName = tCffName;
        this.targetTopicCffName = tCffName;
        this.sourceUsername = sourceUsername;
        this.sourcePassword = sourcePassword;
        this.targetUsername = targetUsername;
        this.targetPassword = targetPassword;
        this.selector = selector;
        this.failureRetryInterval = failureRetryInterval;
        this.maxRetries = maxRetries;
        this.qualityOfServiceMode = qosMode;
        this.maxBatchSize = maxBatchSize;
        this.maxBatchTime = maxBatchTime;
        this.subName = subName;
        this.clientID = clientID;
        this.addMessageIDInHeader = addMessageIDInHeader;
        this.name = "Bridge-" + System.identityHashCode(this);
        if (trace) {
            log.trace((Object)("Created " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void start() throws Exception {
        boolean ok;
        block5: {
            if (this.started) {
                log.warn((Object)(this.name + " Attempt to start, but is already started"));
                return;
            }
            if (trace) {
                log.trace((Object)("Starting " + this));
            }
            this.checkParams();
            TransactionManager tm = this.getTm();
            Transaction toResume = null;
            try {
                toResume = tm.suspend();
                ok = this.setupJMSObjects();
                Object var5_4 = null;
                if (toResume == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (toResume == null) throw throwable;
                tm.resume(toResume);
                throw throwable;
            }
            tm.resume(toResume);
        }
        if (ok) {
            this.startSourceConnectionAndChecker();
            return;
        }
        log.warn((Object)(this.name + " Failed to start bridge"));
        this.handleFailureOnStartup();
    }

    private synchronized void startSourceConnectionAndChecker() throws Exception {
        this.sourceConn.start();
        this.started = true;
        if (this.maxBatchTime != -1L) {
            if (this.checkerThread != null && this.checkerThread.isAlive()) {
                log.warn((Object)"The time checker thread is running!");
            } else {
                if (trace) {
                    log.trace((Object)"Starting time checker thread");
                }
                this.timeChecker = new BatchTimeChecker();
                this.checkerThread = new Thread(this.timeChecker);
                this.batchExpiryTime = System.currentTimeMillis() + this.maxBatchTime;
                this.checkerThread.start();
                if (trace) {
                    log.trace((Object)"Started time checker thread");
                }
            }
        }
        if (trace) {
            log.trace((Object)("Started " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        block22: {
            block21: {
                if (!this.started) {
                    log.warn((Object)(this.name + " Attempt to stop, but is already stopped"));
                    return;
                }
                if (trace) {
                    log.trace((Object)("Stopping " + this));
                }
                Object object = this.lock;
                synchronized (object) {
                    this.started = false;
                    if (this.checkerThread != null) {
                        this.checkerThread.interrupt();
                    }
                }
                if (this.checkerThread != null) {
                    if (trace) {
                        log.trace((Object)"Waiting for checker thread to finish");
                    }
                    this.checkerThread.join();
                    if (trace) {
                        log.trace((Object)"Checker thread has finished");
                    }
                }
                if (this.tx != null) {
                    block20: {
                        if (trace) {
                            log.trace((Object)"Rolling back remaining tx");
                        }
                        try {
                            this.tx.rollback();
                        }
                        catch (Exception ignore) {
                            if (!trace) break block20;
                            log.trace((Object)"Failed to rollback", (Throwable)ignore);
                        }
                    }
                    if (trace) {
                        log.trace((Object)"Rolled back remaining tx");
                    }
                }
                try {
                    this.sourceConn.close();
                }
                catch (Exception ignore) {
                    if (!trace) break block21;
                    log.trace((Object)"Failed to close source conn", (Throwable)ignore);
                }
            }
            if (this.targetConn != null) {
                try {
                    this.targetConn.close();
                }
                catch (Exception ignore) {
                    if (!trace) break block22;
                    log.trace((Object)"Failed to close target conn", (Throwable)ignore);
                }
            }
        }
        if (trace) {
            log.trace((Object)("Stopped " + this));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause() throws Exception {
        if (trace) {
            log.trace((Object)("Pausing " + this));
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            this.sourceConn.stop();
        }
        if (trace) {
            log.trace((Object)("Paused " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() throws Exception {
        if (trace) {
            log.trace((Object)("Resuming " + this));
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.sourceConn.start();
        }
        if (trace) {
            log.trace((Object)("Resumed " + this));
        }
    }

    public DestinationFactory getSourceDestinationFactory() {
        return this.sourceDestinationFactory;
    }

    public void setSourceDestinationFactory(DestinationFactory dest) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set SourceDestinationFactory while bridge is started"));
            return;
        }
        this.sourceDestinationFactory = dest;
    }

    public DestinationFactory getTargetDestinationFactory() {
        return this.targetDestinationFactory;
    }

    public void setTargetDestinationFactory(DestinationFactory dest) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set TargetDestinationFactory while bridge is started"));
            return;
        }
        this.targetDestinationFactory = dest;
    }

    public String getSourceUsername() {
        return this.sourceUsername;
    }

    public synchronized void setSourceUsername(String name) {
        if (this.started) {
            log.warn((Object)(name + " Cannot set SourceUsername while bridge is started"));
            return;
        }
        this.sourceUsername = name;
    }

    public synchronized String getSourcePassword() {
        return this.sourcePassword;
    }

    public synchronized void setSourcePassword(String pwd) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set SourcePassword while bridge is started"));
            return;
        }
        this.sourcePassword = pwd;
    }

    public synchronized String getDestUsername() {
        return this.targetUsername;
    }

    public synchronized void setDestUserName(String name) {
        if (this.started) {
            log.warn((Object)(name + " Cannot set DestUserName while bridge is started"));
            return;
        }
        this.targetUsername = name;
    }

    public synchronized String getDestPassword() {
        return this.targetPassword;
    }

    public synchronized void setDestPassword(String pwd) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set DestPassword while bridge is started"));
            return;
        }
        this.targetPassword = pwd;
    }

    public synchronized String getSelector() {
        return this.selector;
    }

    public synchronized void setSelector(String selector) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set Selector while bridge is started"));
            return;
        }
        this.selector = selector;
    }

    public synchronized long getFailureRetryInterval() {
        return this.failureRetryInterval;
    }

    public synchronized void setFailureRetryInterval(long interval) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set FailureRetryInterval while bridge is started"));
            return;
        }
        this.failureRetryInterval = interval;
    }

    public synchronized int getMaxRetries() {
        return this.maxRetries;
    }

    public synchronized void setMaxRetries(int retries) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set MaxRetries while bridge is started"));
            return;
        }
        this.maxRetries = retries;
    }

    public synchronized int getQualityOfServiceMode() {
        return this.qualityOfServiceMode;
    }

    public synchronized void setQualityOfServiceMode(int mode) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set QualityOfServiceMode while bridge is started"));
            return;
        }
        this.qualityOfServiceMode = mode;
    }

    public synchronized int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public synchronized void setMaxBatchSize(int size) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set MaxBatchSize while bridge is started"));
            return;
        }
        this.maxBatchSize = size;
    }

    public synchronized long getMaxBatchTime() {
        return this.maxBatchTime;
    }

    public synchronized void setMaxBatchTime(long time) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set MaxBatchTime while bridge is started"));
            return;
        }
        this.maxBatchTime = time;
    }

    public synchronized String getSubName() {
        return this.subName;
    }

    public synchronized void setSubName(String subname) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set SubName while bridge is started"));
            return;
        }
        this.subName = subname;
    }

    public synchronized String getClientID() {
        return this.clientID;
    }

    public synchronized void setClientID(String clientID) {
        if (this.started) {
            log.warn((Object)(this.name + " Cannot set ClientID while bridge is started"));
            return;
        }
        this.clientID = clientID;
    }

    public boolean isAddMessageIDInHeader() {
        return this.addMessageIDInHeader;
    }

    public void setAddMessageIDInHeader(boolean value) {
        this.addMessageIDInHeader = value;
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    public synchronized boolean isFailed() {
        return this.failed;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public void setSourceCFFName(String name) {
        this.sourceCffName = name;
    }

    public void setTargetCFFName(String name) {
        this.targetCffName = name;
    }

    public void setSourceProps(Properties sourceProps) {
        this.sourceProviderProperties = sourceProps;
    }

    public void setTargetProps(Properties targetProps) {
        this.targetProviderProperties = targetProps;
    }

    public void setSourceDestinationName(String sourceDestinationLookup) {
        this.sourceDestName = sourceDestinationLookup;
    }

    public void setTargetDestinationName(String targetDestinationLookup) {
        this.targetDestName = targetDestinationLookup;
    }

    public void setIsSameSourceAndTarget(boolean sameSourceAndTarget) {
        this.isSameSourceAndTarget = sameSourceAndTarget;
    }

    public void setSourceQueueCffName(String name) {
        this.sourceQueueCffName = name;
    }

    public void setSourceTopicCffName(String name) {
        this.sourceTopicCffName = name;
    }

    public void setTargetQueueCffName(String name) {
        this.targetQueueCffName = name;
    }

    public void setTargetTopicCffName(String name) {
        this.targetTopicCffName = name;
    }

    private void checkParams() {
        if (this.failureRetryInterval < 0L && this.failureRetryInterval != -1L) {
            throw new IllegalArgumentException("failureRetryInterval must be > 0 or -1 to represent no retry");
        }
        if (this.maxRetries < 0 && this.maxRetries != -1) {
            throw new IllegalArgumentException("maxRetries must be >= 0 or -1 to represent infinite retries");
        }
        if (this.failureRetryInterval == -1L && this.maxRetries > 0) {
            throw new IllegalArgumentException("If failureRetryInterval == -1 maxRetries must be 0");
        }
        if (this.maxBatchSize < 1) {
            throw new IllegalArgumentException("maxBatchSize must be >= 1");
        }
        if (this.maxBatchTime != -1L && this.maxBatchTime < 1L) {
            throw new IllegalArgumentException("maxBatchTime must be >= 1 or -1 to represent unlimited batch time");
        }
        if (this.qualityOfServiceMode != 0 && this.qualityOfServiceMode != 1 && this.qualityOfServiceMode != 2) {
            throw new IllegalArgumentException("Invalid quality of service mode " + this.qualityOfServiceMode);
        }
    }

    private void enlistResources(Transaction tx) throws Exception {
        if (trace) {
            log.trace((Object)"Enlisting resources in tx");
        }
        XAResource resSource = ((XASession)this.sourceSession).getXAResource();
        tx.enlistResource(resSource);
        XAResource resDest = ((XASession)this.targetSession).getXAResource();
        tx.enlistResource(resDest);
        if (trace) {
            log.trace((Object)"Enlisted resources in tx");
        }
    }

    private void delistResources(Transaction tx) throws Exception {
        if (trace) {
            log.trace((Object)"Delisting resources from tx");
        }
        XAResource resSource = ((XASession)this.sourceSession).getXAResource();
        tx.delistResource(resSource, 0x4000000);
        XAResource resDest = ((XASession)this.targetSession).getXAResource();
        tx.delistResource(resDest, 0x4000000);
        if (trace) {
            log.trace((Object)"Delisted resources from tx");
        }
    }

    private Transaction startTx() throws Exception {
        if (trace) {
            log.trace((Object)"Starting JTA transaction");
        }
        TransactionManager tm = this.getTm();
        tm.setTransactionTimeout(315360000);
        tm.begin();
        Transaction tx = tm.getTransaction();
        tm.suspend();
        if (trace) {
            log.trace((Object)"Started JTA transaction");
        }
        return tx;
    }

    private TransactionManager getTm() {
        if (this.tm == null) {
            this.tm = TransactionManagerLocator.getInstance().locate();
            if (this.tm == null) {
                throw new IllegalStateException("Cannot locate a transaction manager");
            }
        }
        return this.tm;
    }

    private Connection createConnection(String username, String password, ConnectionFactoryFactory cff) throws Exception {
        Connection conn;
        ConnectionFactory cf = cff.createConnectionFactory();
        if (this.qualityOfServiceMode == 2 && !(cf instanceof XAConnectionFactory)) {
            throw new IllegalArgumentException("Connection factory must be XAConnectionFactory");
        }
        if (username == null) {
            if (this.qualityOfServiceMode == 2) {
                if (trace) {
                    log.trace((Object)"Creating an XA connection");
                }
                conn = ((XAConnectionFactory)cf).createXAConnection();
            } else {
                if (trace) {
                    log.trace((Object)"Creating a non XA connection");
                }
                conn = cf.createConnection();
            }
        } else if (this.qualityOfServiceMode == 2) {
            if (trace) {
                log.trace((Object)"Creating an XA connection");
            }
            conn = ((XAConnectionFactory)cf).createXAConnection(username, password);
        } else {
            if (trace) {
                log.trace((Object)"Creating a non XA connection");
            }
            conn = cf.createConnection(username, password);
        }
        return conn;
    }

    private boolean setupJMSObjects() {
        try {
            Session sess;
            this.sourceDestinationFactory = new JNDIDestinationFactory(this.sourceProviderProperties, this.sourceDestName);
            this.sourceDestination = this.sourceDestinationFactory.createDestination();
            this.targetDestinationFactory = new JNDIDestinationFactory(this.targetProviderProperties, this.targetDestName);
            this.targetDestination = this.targetDestinationFactory.createDestination();
            this.sourceCffName = this.sourceDestination instanceof Topic ? this.sourceTopicCffName : this.sourceQueueCffName;
            this.sourceCff = new JNDIConnectionFactoryFactory(this.sourceProviderProperties, this.sourceCffName);
            if (this.isSameSourceAndTarget) {
                this.targetCff = this.sourceCff;
            } else {
                this.targetCffName = this.targetDestination instanceof Topic ? this.targetTopicCffName : this.targetQueueCffName;
                this.targetCff = new JNDIConnectionFactoryFactory(this.targetProviderProperties, this.targetCffName);
            }
            this.forwardMode = this.sourceCff == this.targetCff ? 1 : (this.qualityOfServiceMode == 2 ? 0 : 2);
            this.sourceConn = this.createConnection(this.sourceUsername, this.sourcePassword, this.sourceCff);
            if (this.forwardMode != 1) {
                this.targetConn = this.createConnection(this.targetUsername, this.targetPassword, this.targetCff);
                this.targetConn.setExceptionListener((ExceptionListener)new BridgeExceptionListener());
            }
            if (this.clientID != null) {
                this.sourceConn.setClientID(this.clientID);
            }
            this.sourceConn.setExceptionListener((ExceptionListener)new BridgeExceptionListener());
            if (this.forwardMode == 1) {
                sess = this.sourceSession = this.sourceConn.createSession(true, 0);
            } else if (this.forwardMode == 0) {
                if (trace) {
                    log.trace((Object)"Creating XA source session");
                }
                this.sourceSession = ((XAConnection)this.sourceConn).createXASession();
                sess = ((XASession)this.sourceSession).getSession();
            } else {
                if (trace) {
                    log.trace((Object)"Creating non XA source session");
                }
                sess = this.sourceSession = this.sourceConn.createSession(false, 2);
            }
            if (this.forwardMode == 0 && this.sourceSession instanceof JBossSession) {
                JBossSession jsession = (JBossSession)this.sourceSession;
                SessionState sstate = (SessionState)((DelegateSupport)((Object)jsession.getDelegate())).getState();
                sstate.setTreatAsNonTransactedWhenNotEnlisted(false);
            }
            this.consumer = this.subName == null ? (this.selector == null ? sess.createConsumer(this.sourceDestination) : sess.createConsumer(this.sourceDestination, this.selector, false)) : (this.selector == null ? sess.createDurableSubscriber((Topic)this.sourceDestination, this.subName) : sess.createDurableSubscriber((Topic)this.sourceDestination, this.subName, this.selector, false));
            if (this.forwardMode != 1) {
                if (this.forwardMode == 0) {
                    if (trace) {
                        log.trace((Object)"Creating XA dest session");
                    }
                    this.targetSession = ((XAConnection)this.targetConn).createXASession();
                    sess = ((XASession)this.targetSession).getSession();
                } else {
                    if (trace) {
                        log.trace((Object)"Creating non XA dest session");
                    }
                    boolean transacted = this.maxBatchSize > 1;
                    sess = this.targetSession = this.targetConn.createSession(transacted, transacted ? 0 : 1);
                }
            }
            if (this.forwardMode == 0) {
                if (trace) {
                    log.trace((Object)"Starting JTA transaction");
                }
                this.tx = this.startTx();
                this.enlistResources(this.tx);
            }
            this.producer = sess.createProducer(null);
            this.consumer.setMessageListener((MessageListener)new SourceListener());
            return true;
        }
        catch (Exception e) {
            log.warn((Object)(this.name + " Failed to set up connections"), (Throwable)e);
            this.cleanup();
            return false;
        }
    }

    private void cleanup() {
        block13: {
            block11: {
                block10: {
                    try {
                        this.sourceConn.close();
                    }
                    catch (Throwable ignore) {
                        if (!trace) break block10;
                        log.trace((Object)"Failed to close source connection", ignore);
                    }
                }
                try {
                    if (this.targetConn != null) {
                        this.targetConn.close();
                    }
                }
                catch (Throwable ignore) {
                    if (!trace) break block11;
                    log.trace((Object)"Failed to close target connection", ignore);
                }
            }
            if (this.tx != null) {
                block12: {
                    try {
                        this.delistResources(this.tx);
                    }
                    catch (Throwable ignore) {
                        if (!trace) break block12;
                        log.trace((Object)"Failed to delist resources", ignore);
                    }
                }
                try {
                    this.tx.rollback();
                }
                catch (Throwable ignore) {
                    if (!trace) break block13;
                    log.trace((Object)"Failed to rollback", ignore);
                }
            }
        }
    }

    private void pause(long interval) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.failureRetryInterval) {
            try {
                Thread.sleep(this.failureRetryInterval);
            }
            catch (InterruptedException ex) {}
        }
    }

    private boolean setupJMSObjectsWithRetry() {
        if (trace) {
            log.trace((Object)"Setting up connections");
        }
        int count = 0;
        while (true) {
            boolean ok;
            if (ok = this.setupJMSObjects()) {
                return true;
            }
            if (this.maxRetries != -1 && ++count == this.maxRetries) break;
            log.warn((Object)(this.name + " Failed to set up connections, will retry after a pause of " + this.failureRetryInterval + " ms"));
            this.pause(this.failureRetryInterval);
        }
        return false;
    }

    private void sendBatchNonTransacted() {
        try {
            if (this.qualityOfServiceMode == 0) {
                if (trace) {
                    log.trace((Object)"Client acking source session");
                }
                this.messages.getLast().acknowledge();
                if (trace) {
                    log.trace((Object)"Client acked source session");
                }
            }
            this.sendMessages();
            if (this.maxBatchSize > 1) {
                if (trace) {
                    log.trace((Object)"Committing target session");
                }
                this.targetSession.commit();
                if (trace) {
                    log.trace((Object)"Committed source session");
                }
            }
            if (this.qualityOfServiceMode == 1) {
                if (trace) {
                    log.trace((Object)"Client acking source session");
                }
                this.messages.getLast().acknowledge();
                if (trace) {
                    log.trace((Object)"Client acked source session");
                }
            }
            this.messages.clear();
        }
        catch (Exception e) {
            log.warn((Object)(this.name + " Failed to send + acknowledge batch, closing JMS objects"), (Throwable)e);
            this.handleFailureOnSend();
        }
    }

    private void sendBatchXA() {
        try {
            this.sendMessages();
            this.delistResources(this.tx);
            if (trace) {
                log.trace((Object)"Committing JTA transaction");
            }
            this.tx.commit();
            if (trace) {
                log.trace((Object)"Committed JTA transaction");
            }
            this.tx = this.startTx();
            this.enlistResources(this.tx);
            this.messages.clear();
        }
        catch (Exception e) {
            log.warn((Object)(this.name + " Failed to send + acknowledge batch, closing JMS objects"), (Throwable)e);
            this.handleFailureOnSend();
        }
    }

    private void sendBatchLocalTx() {
        try {
            this.sendMessages();
            if (trace) {
                log.trace((Object)"Committing source session");
            }
            this.sourceSession.commit();
            if (trace) {
                log.trace((Object)"Committed source session");
            }
            this.messages.clear();
        }
        catch (Exception e) {
            log.warn((Object)(this.name + " Failed to send + acknowledge batch, closing JMS objects"), (Throwable)e);
            this.handleFailureOnSend();
        }
    }

    private void sendBatch() {
        if (trace) {
            log.trace((Object)("Sending batch of " + this.messages.size() + " messages"));
        }
        if (this.paused) {
            if (trace) {
                log.trace((Object)"Paused, so not sending now");
            }
            return;
        }
        if (this.forwardMode == 1) {
            this.sendBatchLocalTx();
        } else if (this.forwardMode == 0) {
            this.sendBatchXA();
        } else {
            this.sendBatchNonTransacted();
        }
    }

    private void sendMessages() throws Exception {
        Iterator iter = this.messages.iterator();
        Message msg = null;
        while (iter.hasNext()) {
            long timeToLive;
            msg = (Message)iter.next();
            if (this.addMessageIDInHeader) {
                this.addMessageIDInHeader(msg);
            }
            if (trace) {
                log.trace((Object)("Sending message " + msg));
            }
            if ((timeToLive = msg.getJMSExpiration()) != 0L && (timeToLive -= System.currentTimeMillis()) <= 0L) {
                timeToLive = 1L;
            }
            this.producer.send(this.targetDestination, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), timeToLive);
            if (!trace) continue;
            log.trace((Object)("Sent message " + msg));
        }
    }

    private void handleFailureOnSend() {
        this.handleFailure(new FailureHandler());
    }

    private void handleFailureOnStartup() {
        this.handleFailure(new StartupFailureHandler());
    }

    private void handleFailure(Runnable failureHandler) {
        this.failed = true;
        Thread t = new Thread(failureHandler);
        t.start();
    }

    private void addMessageIDInHeader(Message msg) throws Exception {
        if (trace) {
            log.trace((Object)"Adding old message id in Message header");
        }
        Enumeration en = msg.getPropertyNames();
        HashMap<String, Object> oldProps = null;
        while (en.hasMoreElements()) {
            String propName = (String)en.nextElement();
            if (oldProps == null) {
                oldProps = new HashMap<String, Object>();
            }
            oldProps.put(propName, msg.getObjectProperty(propName));
        }
        msg.clearProperties();
        if (oldProps != null) {
            for (Map.Entry entry : oldProps.entrySet()) {
                String propName = (String)entry.getKey();
                msg.setObjectProperty(propName, entry.getValue());
            }
        }
        String val = null;
        val = msg.getStringProperty("JBM_BRIDGE_MSG_ID_LIST");
        if (val == null) {
            val = msg.getJMSMessageID();
        } else {
            StringBuffer sb = new StringBuffer(val);
            sb.append(",").append(msg.getJMSMessageID());
            val = sb.toString();
        }
        msg.setStringProperty("JBM_BRIDGE_MSG_ID_LIST", val);
    }

    private class BridgeExceptionListener
    implements ExceptionListener {
        private BridgeExceptionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException e) {
            log.warn((Object)(Bridge.this.name + " Detected failure on connection"), (Throwable)e);
            Object object = Bridge.this.lock;
            synchronized (object) {
                if (Bridge.this.failed) {
                    if (trace) {
                        log.trace((Object)"Failure recovery already in progress");
                    }
                } else {
                    Bridge.this.handleFailure(new FailureHandler());
                }
            }
        }
    }

    private class SourceListener
    implements MessageListener {
        private SourceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message msg) {
            Object object = Bridge.this.lock;
            synchronized (object) {
                if (Bridge.this.failed) {
                    if (trace) {
                        log.trace((Object)"Bridge has failed so ignoring message");
                    }
                    return;
                }
                if (trace) {
                    log.trace((Object)(this + " received message " + msg));
                }
                Bridge.this.messages.add(msg);
                Bridge.this.batchExpiryTime = System.currentTimeMillis() + Bridge.this.maxBatchTime;
                if (trace) {
                    log.trace((Object)(this + " rescheduled batchExpiryTime to " + Bridge.this.batchExpiryTime));
                }
                if (Bridge.this.maxBatchSize != -1 && Bridge.this.messages.size() >= Bridge.this.maxBatchSize) {
                    if (trace) {
                        log.trace((Object)(this + " maxBatchSize has been reached so sending batch"));
                    }
                    Bridge.this.sendBatch();
                    if (trace) {
                        log.trace((Object)(this + " sent batch"));
                    }
                }
            }
        }
    }

    private class BatchTimeChecker
    implements Runnable {
        private BatchTimeChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (trace) {
                log.trace((Object)(this + " running"));
            }
            Object object = Bridge.this.lock;
            synchronized (object) {
                while (Bridge.this.started) {
                    long toWait = Bridge.this.batchExpiryTime - System.currentTimeMillis();
                    if (toWait <= 0L) {
                        if (trace) {
                            log.trace((Object)(this + " waited enough"));
                        }
                        Object object2 = Bridge.this.lock;
                        synchronized (object2) {
                            if (!Bridge.this.failed && !Bridge.this.messages.isEmpty()) {
                                if (trace) {
                                    log.trace((Object)(this + " got some messages so sending batch"));
                                }
                                Bridge.this.sendBatch();
                                if (trace) {
                                    log.trace((Object)(this + " sent batch"));
                                }
                            }
                        }
                        Bridge.this.batchExpiryTime = System.currentTimeMillis() + Bridge.this.maxBatchTime;
                        continue;
                    }
                    try {
                        if (trace) {
                            log.trace((Object)(this + " waiting for " + toWait));
                        }
                        Bridge.this.lock.wait(toWait);
                        if (!trace) continue;
                        log.trace((Object)(this + " woke up"));
                    }
                    catch (InterruptedException e) {
                        if (!trace) continue;
                        log.trace((Object)(this + " thread was interrupted"));
                    }
                }
                return;
            }
        }
    }

    private class StartupFailureHandler
    extends FailureHandler {
        private StartupFailureHandler() {
        }

        protected void failed() {
            log.warn((Object)(Bridge.this.name + " Unable to set up connections, bridge will not be started"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void succeeded() {
            log.info((Object)(Bridge.this.name + " Succeeded in connecting to servers"));
            Object object = Bridge.this.lock;
            synchronized (object) {
                Bridge.this.failed = false;
                Bridge.this.started = true;
                try {
                    Bridge.this.startSourceConnectionAndChecker();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to start source connection", (Throwable)e);
                }
            }
        }
    }

    private class FailureHandler
    implements Runnable {
        private FailureHandler() {
        }

        protected void startSourceConnection() {
            try {
                Bridge.this.sourceConn.start();
            }
            catch (JMSException e) {
                log.error((Object)"Failed to start source connection", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void succeeded() {
            log.info((Object)(Bridge.this.name + " Succeeded in reconnecting to servers"));
            Object object = Bridge.this.lock;
            synchronized (object) {
                Bridge.this.failed = false;
                this.startSourceConnection();
            }
        }

        protected void failed() {
            log.warn((Object)(Bridge.this.name + " Unable to set up connections, bridge will be stopped"));
            try {
                Bridge.this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            if (trace) {
                log.trace((Object)"Failure handler running");
            }
            Bridge.this.messages.clear();
            Bridge.this.cleanup();
            boolean ok = false;
            if (Bridge.this.maxRetries > 0 || Bridge.this.maxRetries == -1) {
                log.warn((Object)(Bridge.this.name + " Will retry after a pause of " + Bridge.this.failureRetryInterval + " ms"));
                Bridge.this.pause(Bridge.this.failureRetryInterval);
                ok = Bridge.this.setupJMSObjectsWithRetry();
            }
            if (!ok) {
                this.failed();
            } else {
                this.succeeded();
            }
        }
    }
}

