/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.control;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.jcs.engine.CompositeCacheAttributes;
import org.apache.jcs.engine.ElementAttributes;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheConfigurator;

public class CompositeCacheManager
implements IRemoteCacheConstants,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$control$CompositeCacheManager == null ? (class$org$apache$jcs$engine$control$CompositeCacheManager = CompositeCacheManager.class$("org.apache.jcs.engine.control.CompositeCacheManager")) : class$org$apache$jcs$engine$control$CompositeCacheManager));
    protected Hashtable caches = new Hashtable();
    protected Hashtable systemCaches = new Hashtable();
    private int clients;
    protected ICompositeCacheAttributes defaultCacheAttr = new CompositeCacheAttributes();
    protected IElementAttributes defaultElementAttr = new ElementAttributes();
    protected Hashtable auxFacs = new Hashtable(11);
    protected Hashtable auxAttrs = new Hashtable(11);
    protected Properties props;
    protected String defaultAuxValues;
    protected static CompositeCacheManager instance;
    static /* synthetic */ Class class$org$apache$jcs$engine$control$CompositeCacheManager;

    public static synchronized CompositeCacheManager getInstance() {
        if (instance == null) {
            log.debug((Object)"Instance is null, creating with default config");
            instance = CompositeCacheManager.createInstance();
            instance.configure();
        }
        instance.incrementClients();
        return instance;
    }

    public static synchronized CompositeCacheManager getInstance(String propsFilename) {
        if (instance == null) {
            log.debug((Object)"Instance is null, creating with default config");
            instance = CompositeCacheManager.createInstance();
            instance.configure(propsFilename);
        }
        instance.incrementClients();
        return instance;
    }

    public static synchronized CompositeCacheManager getUnconfiguredInstance() {
        if (instance == null) {
            log.debug((Object)"Instance is null, creating with provided config");
            instance = CompositeCacheManager.createInstance();
        }
        instance.incrementClients();
        return instance;
    }

    protected static CompositeCacheManager createInstance() {
        return new CompositeCacheManager();
    }

    public void configure() {
        this.configure("/cache.ccf");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(String propFile) {
        log.debug((Object)("Creating cache manager from config file: " + propFile));
        Properties props = new Properties();
        InputStream is = this.getClass().getResourceAsStream(propFile);
        try {
            try {
                props.load(is);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("File contained " + props.size() + " properties"));
                }
            }
            catch (IOException ex) {
                log.error((Object)"Failed to load properties", (Throwable)ex);
                throw new IllegalStateException(ex.getMessage());
            }
            Object var6_4 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        is.close();
        this.configure(props);
    }

    public void configure(Properties props) {
        CompositeCacheConfigurator configurator = new CompositeCacheConfigurator(this);
        configurator.doConfigure(props);
    }

    public ICompositeCacheAttributes getDefaultCacheAttributes() {
        return this.defaultCacheAttr.copy();
    }

    public void setDefaultCacheAttributes(ICompositeCacheAttributes icca) {
        this.defaultCacheAttr = icca;
    }

    public void setDefaultElementAttributes(IElementAttributes iea) {
        this.defaultElementAttr = iea;
    }

    public IElementAttributes getDefaultElementAttributes() {
        return this.defaultElementAttr.copy();
    }

    public CompositeCache getCache(String cacheName) {
        return this.getCache(cacheName, this.defaultCacheAttr.copy());
    }

    public CompositeCache getCache(String cacheName, ICompositeCacheAttributes cattr) {
        cattr.setCacheName(cacheName);
        return this.getCache(cattr, this.defaultElementAttr);
    }

    public CompositeCache getCache(String cacheName, ICompositeCacheAttributes cattr, IElementAttributes attr) {
        cattr.setCacheName(cacheName);
        return this.getCache(cattr, this.defaultElementAttr);
    }

    public CompositeCache getCache(ICompositeCacheAttributes cattr) {
        return this.getCache(cattr, this.defaultElementAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeCache getCache(ICompositeCacheAttributes cattr, IElementAttributes attr) {
        CompositeCache cache;
        Hashtable hashtable = this.caches;
        synchronized (hashtable) {
            cache = (CompositeCache)this.caches.get(cattr.getCacheName());
            if (cache == null) {
                cattr.setCacheName(cattr.getCacheName());
                CompositeCacheConfigurator configurator = new CompositeCacheConfigurator(this);
                cache = configurator.parseRegion(this.props, cattr.getCacheName(), this.defaultAuxValues, cattr);
                this.caches.put(cattr.getCacheName(), cache);
            }
        }
        return cache;
    }

    public void freeCache(String name) {
        this.freeCache(name, false);
    }

    public void freeCache(String name, boolean fromRemote) {
        CompositeCache cache = (CompositeCache)this.caches.get(name);
        if (cache != null) {
            cache.dispose(fromRemote);
        }
    }

    protected void incrementClients() {
        ++this.clients;
    }

    public void release() {
        this.release(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean fromRemote) {
        Class clazz = class$org$apache$jcs$engine$control$CompositeCacheManager == null ? (class$org$apache$jcs$engine$control$CompositeCacheManager = CompositeCacheManager.class$("org.apache.jcs.engine.control.CompositeCacheManager")) : class$org$apache$jcs$engine$control$CompositeCacheManager;
        synchronized (clazz) {
            if (--this.clients > 0 && log.isDebugEnabled()) {
                log.debug((Object)("Release called, but " + this.clients + " remain"));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Last client called release. There are " + this.caches.size() + " caches which will be disposed"));
            }
            Enumeration allCaches = this.caches.elements();
            while (allCaches.hasMoreElements()) {
                CompositeCache cache = (CompositeCache)allCaches.nextElement();
                if (cache == null) continue;
                cache.dispose(fromRemote);
            }
        }
    }

    public String[] getCacheNames() {
        String[] list = new String[this.caches.size()];
        int i = 0;
        Iterator itr = this.caches.keySet().iterator();
        while (itr.hasNext()) {
            list[i++] = (String)itr.next();
        }
        return list;
    }

    public int getCacheType() {
        return 1;
    }

    public ICompositeCacheAttributes getDefaultCattr() {
        return this.defaultCacheAttr;
    }

    void registryFacPut(AuxiliaryCacheFactory auxFac) {
        this.auxFacs.put(auxFac.getName(), auxFac);
    }

    AuxiliaryCacheFactory registryFacGet(String name) {
        return (AuxiliaryCacheFactory)this.auxFacs.get(name);
    }

    void registryAttrPut(AuxiliaryCacheAttributes auxAttr) {
        this.auxAttrs.put(auxAttr.getName(), auxAttr);
    }

    AuxiliaryCacheAttributes registryAttrGet(String name) {
        return (AuxiliaryCacheAttributes)this.auxAttrs.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

