/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.rmi.Naming;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheClusterManager;
import org.apache.jcs.engine.behavior.ICacheRestore;

public class RemoteCacheClusterRestore
implements ICacheRestore {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$server$RemoteCacheClusterRestore == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheClusterRestore = RemoteCacheClusterRestore.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheClusterRestore")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheClusterRestore));
    private final RemoteCacheClusterManager rcm;
    private boolean canFix = true;
    private Object remoteObj;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$server$RemoteCacheClusterRestore;

    public RemoteCacheClusterRestore(RemoteCacheClusterManager rcm) {
        this.rcm = rcm;
    }

    public boolean canFix() {
        if (!this.canFix) {
            return this.canFix;
        }
        String registry = "//" + this.rcm.host + ":" + this.rcm.port + "/" + this.rcm.service;
        log.info((Object)("looking up server " + registry));
        try {
            this.remoteObj = Naming.lookup(registry);
            log.info((Object)("looking up server " + registry));
        }
        catch (Exception ex) {
            log.error((Object)("host=" + this.rcm.host + "; port" + this.rcm.port + "; service=" + this.rcm.service), (Throwable)ex);
            this.canFix = false;
        }
        return this.canFix;
    }

    public void fix() {
        if (!this.canFix) {
            return;
        }
        this.rcm.fixCaches((IRemoteCacheService)this.remoteObj, (IRemoteCacheObserver)this.remoteObj);
        String msg = "Remote connection to //" + this.rcm.host + ":" + this.rcm.port + "/" + this.rcm.service + " resumed.";
        log.info((Object)msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

