/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task.module;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.Property;
import org.jboss.tools.buildmagic.task.AbstractBuildListener;
import org.jboss.tools.buildmagic.task.Ant;
import org.jboss.tools.buildmagic.task.ResolveProperties;
import org.jboss.tools.buildmagic.task.util.TaskLogger;
import org.jboss.util.Strings;

public class ExecuteModules
extends Task {
    protected final TaskLogger log = new TaskLogger(this);
    protected String target;
    protected String antfile;
    protected List modules;
    protected String root;
    protected List properties = new LinkedList();
    protected Project _project;
    protected String moduleProperty = "module";
    protected String targetProperty = "target";
    protected boolean skipMissing = false;
    protected boolean inheritAll = false;
    protected List headers = new LinkedList();
    protected List footers = new LinkedList();
    protected List beforeHooks = new LinkedList();
    protected List afterHooks = new LinkedList();
    protected ModuleBuildListener listener = new ModuleBuildListener();
    protected List exportProperties = new LinkedList();
    protected String module;
    protected boolean threading = false;

    public void setThreading(boolean flag) {
        this.threading = flag;
    }

    public void setExportproperties(String list) {
        StringTokenizer stok = new StringTokenizer(list, ",");
        while (stok.hasMoreTokens()) {
            this.exportProperties.add(stok.nextToken().trim());
        }
    }

    public void setModuleproperty(String property) {
        this.moduleProperty = property;
    }

    public void setTargetproperty(String property) {
        this.targetProperty = property;
    }

    public void setInheritAll(boolean flag) {
        this.inheritAll = flag;
    }

    public void init() {
        this._project = new Project();
        this._project.setJavaVersionProperty();
        Hashtable tasks = this.project.getTaskDefinitions();
        this._project.addTaskDefinition("property", (Class)tasks.get("property"));
        this._project.addTaskDefinition("echo", (Class)tasks.get("echo"));
    }

    protected void reinit() {
        this.init();
        int i = 0;
        while (i < this.properties.size()) {
            Property a = (Property)this.properties.get(i);
            Property b = (Property)this._project.createTask("property");
            this.copy(a, b);
            this.properties.set(i, b);
            ++i;
        }
    }

    protected void copy(Property a, Property b) {
        b.setName(a.getName());
        if (a.getValue() != null) {
            b.setValue(a.getValue());
        }
        if (a.getFile() != null) {
            b.setFile(a.getFile());
        }
        if (a.getResource() != null) {
            b.setResource(a.getResource());
        }
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setAntfile(String antfile) {
        this.antfile = antfile;
    }

    public void setModules(String names) {
        names = ResolveProperties.subst(names, this.project, true);
        StringTokenizer stok = new StringTokenizer(names, ",");
        this.modules = new LinkedList();
        while (stok.hasMoreTokens()) {
            this.modules.add(stok.nextToken().trim());
        }
    }

    public void setSkipmissing(boolean flag) {
        this.skipMissing = flag;
    }

    public void setRoot(String dir) throws BuildException {
        this.root = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            if (this.modules == null || this.modules.size() == 0) {
                throw new BuildException("No module names were specified", this.location);
            }
            if (this.root == null) {
                throw new BuildException("Root directory not specified", this.location);
            }
            Iterator iter = this.modules.iterator();
            while (iter.hasNext()) {
                String module = (String)iter.next();
                this.executeModule(module);
            }
            Object var4_3 = null;
            this._project = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._project = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeModule(final String module) throws BuildException {
        this.module = module;
        final Ant ant = (Ant)this.project.createTask("Ant");
        ant.setInheritAll(this.inheritAll);
        ant.init();
        Property p = this.createProperty(null);
        p.setName(this.moduleProperty);
        p.setValue(module);
        this._project.setProperty(this.moduleProperty, module);
        this.copy(p, ant.createProperty());
        p.execute();
        String temp = this.target == null ? "<default>" : this.target;
        this.resolve(temp);
        p = this.createProperty(null);
        p.setName(this.targetProperty);
        p.setValue(temp);
        this.copy(p, ant.createProperty());
        p.execute();
        ant.setLocation(this.location);
        temp = ResolveProperties.subst(this.root, this.project);
        temp = Strings.subst("@MODULE@", module, temp);
        temp = Strings.subst("@TARGET@", this.target, temp);
        File moduleRoot = new File(temp);
        this.log.verbose("module root: " + moduleRoot);
        ant.setDir(moduleRoot);
        ant.setAntfile(this.antfile);
        if (this.target != null) {
            this.log.verbose("using target: " + this.target);
            ant.setTarget(this.target);
        }
        Hashtable props = this.project.getProperties();
        try {
            if (ant.getBuildFile() == null) {
                // empty if block
            }
        }
        catch (BuildException e) {
            this.log.verbose("exception: " + (Object)((Object)e));
            if (this.skipMissing) {
                this.listener.skipped(module);
                this.log.warning("Missing build file; skipping module: " + module);
                props.remove(this.moduleProperty);
                props.remove(this.targetProperty);
                return;
            }
            this.log.error("Missing build file: " + module);
            throw e;
        }
        this.runHooks(this.beforeHooks);
        ant.addBuildListener(this.listener);
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            Property a = (Property)iter.next();
            Property b = ant.createProperty();
            this.copy(a, b);
            a.execute();
        }
        iter = this.exportProperties.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String value = (String)props.get(name);
            p = ant.createProperty();
            p.setName(name);
            p.setValue(value);
            this.log.verbose("Exported property " + name + "=" + value);
        }
        final String targetName = temp;
        Runnable runner = new Runnable(){

            public void run() {
                ExecuteModules.this.printHeading(ExecuteModules.this.headers);
                ExecuteModules.this.log.verbose("Executing " + targetName + " in module '" + module + "'...");
                ant.execute();
                ExecuteModules.this.log.verbose("Finished with " + targetName + " in module '" + module + "'...");
                ExecuteModules.this.printHeading(ExecuteModules.this.footers);
                ExecuteModules.this.runHooks(ExecuteModules.this.afterHooks);
            }
        };
        if (this.threading) {
            new Thread(runner, "Module Runner (" + module + ":" + targetName + ")").start();
            return;
        }
        runner.run();
    }

    protected void printHeading(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            MyEcho echo = (MyEcho)((Object)iter.next());
            echo.execute();
        }
    }

    public Property createProperty() {
        Property prop = this.createProperty(this.properties);
        return prop;
    }

    public Property createProperty(List list) {
        if (this._project == null) {
            this.reinit();
        }
        Property temp = (Property)this._project.createTask("property");
        temp.setUserProperty(true);
        if (list != null) {
            list.add(0, temp);
        }
        return temp;
    }

    public Echo createHeader() {
        if (this._project == null) {
            this.reinit();
        }
        MyEcho header = new MyEcho(this.project);
        this.headers.add(header);
        return header;
    }

    public Echo createFooter() {
        if (this._project == null) {
            this.reinit();
        }
        MyEcho footer = new MyEcho(this.project);
        this.footers.add(footer);
        return footer;
    }

    public String resolve(String property) {
        Hashtable props = this.project.getUserProperties();
        property = ResolveProperties.subst(property, props, false);
        props = this._project.getUserProperties();
        property = ResolveProperties.subst(property, props, false);
        props = this._project.getProperties();
        property = ResolveProperties.subst(property, props, false);
        return property;
    }

    public Hook createBefore() {
        Hook hook = new Hook(this);
        this.beforeHooks.add(hook);
        return hook;
    }

    public Hook createAfter() {
        Hook hook = new Hook(this);
        this.afterHooks.add(hook);
        return hook;
    }

    protected void runHooks(List list) throws BuildException {
        this.log.verbose("executing hooks");
        this.log.debug("list: " + list);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Hook hook = (Hook)iter.next();
            this.log.debug("executing hook: " + hook);
            hook.execute();
        }
    }

    protected class ModuleBuildListener
    extends AbstractBuildListener {
        protected ModuleBuildListener() {
        }

        public void skipped(String module) {
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            Throwable t = event.getException();
            int pri = event.getPriority();
            String message = event.getMessage();
            if (t != null) {
                // empty if block
            }
            switch (pri) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    protected class Hook {
        public ExecuteModules task;
        public String target;

        public Hook(ExecuteModules task) {
            this.task = task;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public void execute() throws BuildException {
            Project project = this.task.getProject();
            String t = this.task.resolve(this.target);
            t = Strings.subst("@MODULE@", ExecuteModules.this.module, t);
            t = Strings.subst("@TARGET@", ExecuteModules.this.target, t);
            if (project.getTargets().containsKey(t)) {
                project.executeTarget(t);
            } else {
                ExecuteModules.this.log.verbose("skipping missing hook: " + t);
            }
        }
    }

    protected class MyEcho
    extends Echo {
        Project project;

        public MyEcho(Project project) {
            this.project = project;
        }

        public void addText(String msg) {
            this.message = this.message + msg;
        }

        public void execute() throws BuildException {
            String temp = ExecuteModules.this.resolve(this.message);
            temp = Strings.subst("@MODULE@", ExecuteModules.this.module, temp);
            temp = Strings.subst("@TARGET@", ExecuteModules.this.target, temp);
            this.project.log(temp, this.logLevel);
        }
    }
}

