/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.jboss.tools.buildmagic.task.ResolveProperties;

public class Ant
extends org.apache.tools.ant.taskdefs.Ant {
    protected File dir = null;
    protected String antFile = null;
    protected String target = null;
    protected String output = null;
    protected Vector properties = new Vector();
    protected boolean inheritAll = true;
    protected Project p1;

    public void init() {
        this.p1 = new Project();
        this.p1.setJavaVersionProperty();
        this.p1.addTaskDefinition("property", (Class)this.project.getTaskDefinitions().get("property"));
    }

    protected void reinit() {
        this.init();
        int i = 0;
        while (i < this.properties.size()) {
            Property p = (Property)this.properties.elementAt(i);
            Property newP = (Property)this.p1.createTask("property");
            newP.setName(p.getName());
            if (p.getValue() != null) {
                newP.setValue(p.getValue());
            }
            if (p.getFile() != null) {
                newP.setFile(p.getFile());
            }
            if (p.getResource() != null) {
                newP.setResource(p.getResource());
            }
            this.properties.setElementAt(newP, i);
            ++i;
        }
    }

    protected void initializeProject() {
        Hashtable prop1;
        Vector listeners = this.project.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            this.p1.addBuildListener((BuildListener)listeners.elementAt(i));
            ++i;
        }
        if (this.output != null) {
            try {
                PrintStream out = new PrintStream(new FileOutputStream(this.output));
                DefaultLogger logger = new DefaultLogger();
                logger.setMessageOutputLevel(2);
                logger.setOutputPrintStream(out);
                logger.setErrorPrintStream(out);
                this.p1.addBuildListener((BuildListener)logger);
            }
            catch (IOException ex) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        Hashtable taskdefs = this.project.getTaskDefinitions();
        Enumeration et = taskdefs.keys();
        while (et.hasMoreElements()) {
            String taskName = (String)et.nextElement();
            Class taskClass = (Class)taskdefs.get(taskName);
            this.p1.addTaskDefinition(taskName, taskClass);
        }
        Hashtable typedefs = this.project.getDataTypeDefinitions();
        Enumeration e = typedefs.keys();
        while (e.hasMoreElements()) {
            String typeName = (String)e.nextElement();
            Class typeClass = (Class)typedefs.get(typeName);
            this.p1.addDataTypeDefinition(typeName, typeClass);
        }
        if (this.inheritAll) {
            prop1 = this.project.getProperties();
        } else {
            prop1 = this.project.getUserProperties();
            this.p1.setSystemProperties();
        }
        e = prop1.keys();
        while (e.hasMoreElements()) {
            String arg = (String)e.nextElement();
            String value = (String)prop1.get(arg);
            if (this.inheritAll) {
                this.p1.setProperty(arg, value);
                continue;
            }
            this.p1.setUserProperty(arg, value);
        }
    }

    public void setInheritAll(boolean inherit) {
        this.inheritAll = inherit;
    }

    public File getBuildFile() throws BuildException {
        String filename = this.antFile;
        filename = filename == null ? "build.xml" : ResolveProperties.subst(filename, this.project);
        File file = new File("build.xml");
        if (!file.isAbsolute() && !(file = new File(filename = new File(this.dir, filename).getAbsolutePath())).isFile()) {
            throw new BuildException("Build file " + file + " not found.");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            if (this.p1 == null) {
                this.reinit();
            }
            if (this.dir == null) {
                this.dir = this.project.getBaseDir();
            }
            this.initializeProject();
            this.p1.setBaseDir(this.dir);
            this.p1.setUserProperty("basedir", this.dir.getAbsolutePath());
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                Property p = (Property)e.nextElement();
                p.execute();
            }
            this.antFile = this.antFile == null ? "build.xml" : ResolveProperties.subst(this.antFile, this.project);
            File file = new File(this.antFile);
            if (!file.isAbsolute()) {
                this.antFile = new File(this.dir, this.antFile).getAbsolutePath();
                file = new File(this.antFile);
                if (!file.isFile()) {
                    throw new BuildException("Build file " + file + " not found.");
                }
            }
            this.p1.setUserProperty("ant.file", this.antFile);
            ProjectHelper.configureProject((Project)this.p1, (File)new File(this.antFile));
            if (this.target == null) {
                this.target = this.p1.getDefaultTarget();
            }
            if (this.p1.getBaseDir().equals(this.project.getBaseDir()) && this.p1.getProperty("ant.file").equals(this.project.getProperty("ant.file")) && this.getOwningTarget() != null && this.target.equals(this.getOwningTarget().getName())) {
                throw new BuildException("ant task calling its own parent target");
            }
            this.p1.executeTarget(this.target);
            Object var4_3 = null;
            this.p1 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.p1 = null;
            throw throwable;
        }
    }

    public Project getTargetProject() {
        return this.p1;
    }

    public void addBuildListener(BuildListener l) {
        this.p1.addBuildListener(l);
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setAntfile(String s) {
        this.antFile = s;
    }

    public void setTarget(String s) {
        this.target = s;
    }

    public void setOutput(String s) {
        this.output = s;
    }

    public Property createProperty() {
        if (this.p1 == null) {
            this.reinit();
        }
        Property p = (Property)this.p1.createTask("property");
        p.setUserProperty(true);
        this.properties.addElement(p);
        return p;
    }
}

