/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.docproc.revdiff;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.hibernate.docproc.revdiff.ModuleElement;
import org.hibernate.docproc.revdiff.ModuleElementState;
import org.hibernate.docproc.revdiff.ModuleReport;

public class ModuleReportHTML
implements ModuleReport {
    public static final String DESTINATION_FILE = "DESTINATION_FILE";

    public void runReport(Set set, Properties properties) {
        if (set == null) {
            throw new NullPointerException("Can't run a report on a null set of module elements.");
        }
        if (!properties.containsKey(DESTINATION_FILE)) {
            throw new IllegalArgumentException("Property not set: DESTINATION_FILE");
        }
        File file = new File(properties.getProperty(DESTINATION_FILE));
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.pageHead());
            if (set.size() == 0) {
                fileWriter.write("<div align=center>No IDs found in either version.</div>");
                fileWriter.close();
                return;
            }
            fileWriter.write("<table cellpadding=4>");
            fileWriter.write(this.generateNewInOriginal(set));
            fileWriter.write("<tr><td>&nbsp;</td></tr>");
            fileWriter.write(this.generateDiffRevision(set));
            fileWriter.write("<tr><td>&nbsp;</td></tr>");
            fileWriter.write(this.generateNewInCopy(set));
            fileWriter.write("</table>");
            fileWriter.write(this.pageFoot());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String pageHead() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<html><head><title>Rowan Report:</title></head><body><div align=\"center\">");
        stringBuffer.append("<h3>Revision Diff Report</h3>");
        return stringBuffer.toString();
    }

    private String pageFoot() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("</div></body></html>");
        return stringBuffer.toString();
    }

    private String generateNewInOriginal(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = set.iterator();
        while (object.hasNext()) {
            ModuleElement moduleElement = (ModuleElement)object.next();
            if (moduleElement.getOrgState() == null || moduleElement.getCopyState() != null) continue;
            stringBuffer.append("<tr><td bgcolor=#eeeeee>ID: " + moduleElement.getIdentifier() + "</td></tr>");
            stringBuffer.append("<tr><td>");
            stringBuffer.append("<b>" + moduleElement.getOrgState().getFileURL() + " (" + moduleElement.getOrgState().getRow() + ", " + moduleElement.getOrgState().getElementName() + ")</b>");
            stringBuffer.append("</td></tr>");
        }
        object = "";
        if (stringBuffer.length() > 0) {
            object = "<tr bgcolor=#cccccc><td><b>New in original:</b></td></tr>";
        }
        return (String)object + stringBuffer.toString();
    }

    private String generateDiffRevision(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = set.iterator();
        while (object.hasNext()) {
            ModuleElement moduleElement = (ModuleElement)object.next();
            if (moduleElement.getOrgState() == null || moduleElement.getCopyState() == null || moduleElement.getOrgState().getRevision() == moduleElement.getCopyState().getRevision() && moduleElement.getOrgState().getElementName().equals(moduleElement.getCopyState().getElementName()) || moduleElement.getCopyState().getRevision() == ModuleElementState.REVISION_IGNORE) continue;
            stringBuffer.append("<tr><td bgcolor=#eeeeee>ID: " + moduleElement.getIdentifier() + "</td></tr>");
            if (!moduleElement.getOrgState().getElementName().equals(moduleElement.getCopyState().getElementName())) {
                stringBuffer.append("<tr><td bgcolor=#ee6666>");
                stringBuffer.append("Element names differ: " + moduleElement.getOrgState().getElementName() + "/" + moduleElement.getCopyState().getElementName());
                stringBuffer.append("</td></tr>");
            }
            stringBuffer.append("<tr><td>");
            stringBuffer.append("Original: <b>" + moduleElement.getOrgState().getFileURL() + " (" + moduleElement.getOrgState().getRow() + ", " + moduleElement.getOrgState().getElementName() + ")</b>");
            stringBuffer.append("</td></tr>");
            stringBuffer.append("<tr><td>");
            stringBuffer.append("Copy: <b>" + moduleElement.getCopyState().getFileURL() + " (" + moduleElement.getCopyState().getRow() + ", " + moduleElement.getCopyState().getElementName() + ")</b>");
            stringBuffer.append("</td></tr>");
            stringBuffer.append("<tr><td>");
            stringBuffer.append("Original Revision: " + moduleElement.getOrgState().getRevision());
            stringBuffer.append("</td></tr>");
            stringBuffer.append("<tr><td>");
            stringBuffer.append("Copy Revision: " + moduleElement.getCopyState().getRevision());
            stringBuffer.append("</td></tr>");
        }
        object = "";
        if (stringBuffer.length() > 0) {
            object = "<tr bgcolor=#cccccc><td><b>Copy needs update:</b></td></tr>";
        }
        return (String)object + stringBuffer.toString();
    }

    private String generateNewInCopy(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = set.iterator();
        while (object.hasNext()) {
            ModuleElement moduleElement = (ModuleElement)object.next();
            if (moduleElement.getCopyState() == null || moduleElement.getOrgState() != null || moduleElement.getCopyState().getRevision() == ModuleElementState.REVISION_IGNORE) continue;
            stringBuffer.append("<tr><td bgcolor=#eeeeee>ID: " + moduleElement.getIdentifier() + "</td></tr>");
            stringBuffer.append("<tr><td>");
            stringBuffer.append("<b>" + moduleElement.getCopyState().getFileURL() + " (" + moduleElement.getCopyState().getRow() + ", " + moduleElement.getCopyState().getElementName() + ")</b>");
            stringBuffer.append("</td></tr>");
        }
        object = "";
        if (stringBuffer.length() > 0) {
            object = "<tr bgcolor=#cccccc><td><b>Only present in copy:</b></td></tr>";
        }
        return (String)object + stringBuffer.toString();
    }
}

