/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.codeunit;

import java.io.File;
import java.io.StringWriter;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import xjavadoc.Dimensioned;
import xjavadoc.Named;
import xjavadoc.NodePrinter;
import xjavadoc.SimpleNode;
import xjavadoc.SourceClass;
import xjavadoc.Typed;
import xjavadoc.XClass;
import xjavadoc.XConstructor;
import xjavadoc.XExecutableMember;
import xjavadoc.XField;
import xjavadoc.XMethod;
import xjavadoc.XParameter;
import xjavadoc.XProgramElement;

public abstract class CodeTestCase
extends TestCase {
    public CodeTestCase(String name) {
        super(name);
    }

    public static void assertAstEquals(File expected, File actual) {
        SourceClass expectedClass = new SourceClass(expected, true);
        SourceClass actualClass = new SourceClass(actual, true);
        CodeTestCase.assertAstEquals(expectedClass.getCompilationUnit(), actualClass.getCompilationUnit());
    }

    public static void assertApiEquals(File expected, File actual) {
        SourceClass expectedClass = new SourceClass(expected, false);
        SourceClass actualClass = new SourceClass(actual, false);
        CodeTestCase.assertApiEquals(expectedClass, actualClass);
    }

    private static void assertAstEquals(SimpleNode expected, SimpleNode actual) {
        boolean sameNumberOfChildren;
        boolean sameNodeType = expected.getType().equals(actual.getType());
        boolean bl = sameNumberOfChildren = expected.jjtGetNumChildren() == actual.jjtGetNumChildren();
        if (!sameNodeType || !sameNumberOfChildren) {
            StringWriter expectedWriter = new StringWriter();
            NodePrinter.print(expected, expectedWriter);
            StringWriter actualWriter = new StringWriter();
            NodePrinter.print(actual, actualWriter);
            Assert.assertEquals((String)expectedWriter.toString(), (Object)expectedWriter.toString(), (Object)actualWriter.toString());
        }
        int i = 0;
        while (i < expected.jjtGetNumChildren()) {
            SimpleNode expectedChild = (SimpleNode)expected.jjtGetChild(i);
            SimpleNode actualChild = (SimpleNode)actual.jjtGetChild(i);
            CodeTestCase.assertAstEquals(expectedChild, actualChild);
            ++i;
        }
    }

    private static void assertApiEquals(SourceClass expected, SourceClass actual) {
        CodeTestCase.assertModifiersEqual("Class modifiers are equal", expected, actual);
        CodeTestCase.assertNameEquals("Class modifiers are equal", expected, actual);
        CodeTestCase.assertSuperclassEquals(expected, actual);
        CodeTestCase.assertInterfacesEqual(expected, actual);
        CodeTestCase.assertFieldsEqual(expected, actual);
        CodeTestCase.assertConstructorsEqual(expected, actual);
        CodeTestCase.assertMethodsEqual(expected, actual);
    }

    private static void assertFieldsEqual(XClass expected, XClass actual) {
        Assert.assertEquals((String)"Number of fields are equal", (int)expected.getFields().size(), (int)actual.getFields().size());
        Iterator expectedFields = expected.getFields().iterator();
        Iterator actualFields = actual.getFields().iterator();
        while (expectedFields.hasNext()) {
            XField expectedField = (XField)expectedFields.next();
            XField actualField = (XField)actualFields.next();
            CodeTestCase.assertFieldEquals(expectedField, actualField);
        }
    }

    private static void assertConstructorsEqual(XClass expected, XClass actual) {
        Assert.assertEquals((String)"Number of constructors are equal", (int)expected.getConstructors().size(), (int)actual.getConstructors().size());
        Iterator expectedConstructors = expected.getConstructors().iterator();
        Iterator actualConstructors = actual.getConstructors().iterator();
        while (expectedConstructors.hasNext()) {
            XConstructor expectedConstructor = (XConstructor)expectedConstructors.next();
            XConstructor actualConstructor = (XConstructor)actualConstructors.next();
            CodeTestCase.assertConstructorEquals(expectedConstructor, actualConstructor);
        }
    }

    private static void assertMethodsEqual(XClass expected, XClass actual) {
        Assert.assertEquals((String)"Number of methods are equal", (int)expected.getMethods().size(), (int)actual.getMethods().size());
        Iterator expectedMethods = expected.getMethods().iterator();
        Iterator actualMethods = actual.getMethods().iterator();
        while (expectedMethods.hasNext()) {
            XMethod expectedMethod = (XMethod)expectedMethods.next();
            XMethod actualMethod = (XMethod)actualMethods.next();
            CodeTestCase.assertMethodEquals(expectedMethod, actualMethod);
        }
    }

    private static void assertFieldEquals(XField expected, XField actual) {
        CodeTestCase.assertTypeEquals("Field types are equal", expected, actual);
        CodeTestCase.assertDimensionEquals("Field dimensions are equal", expected, actual);
        CodeTestCase.assertNameEquals("Field names are equal", expected, actual);
        CodeTestCase.assertModifiersEqual("Field modifiers are equal", expected, actual);
    }

    private static void assertConstructorEquals(XConstructor expected, XConstructor actual) {
        CodeTestCase.assertNameEquals("Constructor names are equal", expected, actual);
        CodeTestCase.assertModifiersEqual("Constructor modifiers are equal", expected, actual);
        CodeTestCase.assertNameWithSignatureEquals("Constructor signatures are equal", expected, actual);
        CodeTestCase.assertParametersEqual("Constructor parameters are equal", expected, actual);
        CodeTestCase.assertThrownExceptionsEqual("Constructor exceptions are equal", expected, actual);
    }

    private static void assertMethodEquals(XMethod expected, XMethod actual) {
        CodeTestCase.assertTypeEquals("Method types are equal", expected, actual);
        CodeTestCase.assertDimensionEquals("Method dimensions are equal", expected, actual);
        CodeTestCase.assertNameEquals("Method names are equal", expected, actual);
        CodeTestCase.assertModifiersEqual("Method modifiers are equal", expected, actual);
        CodeTestCase.assertNameWithSignatureEquals("Method signatures are equal", expected, actual);
        CodeTestCase.assertParametersEqual("Method parameters are equal", expected, actual);
        CodeTestCase.assertThrownExceptionsEqual("Method exceptions are equal", expected, actual);
    }

    private static void assertParameterEquals(XParameter expected, XParameter actual) {
        CodeTestCase.assertTypeEquals("Parameter types are equal", expected, actual);
        CodeTestCase.assertDimensionEquals("Parameter dimensions are equal", expected, actual);
        CodeTestCase.assertNameEquals("Parameter names are equal", expected, actual);
    }

    private static void assertTypeEquals(String msg, Typed expected, Typed actual) {
        Assert.assertEquals((String)msg, (Object)expected.getType().getQualifiedName(), (Object)actual.getType().getQualifiedName());
    }

    private static void assertDimensionEquals(String msg, Dimensioned expected, Dimensioned actual) {
        Assert.assertEquals((String)msg, (Object)expected.getDimensionAsString(), (Object)actual.getDimensionAsString());
    }

    private static void assertNameEquals(String msg, Named expected, Named actual) {
        Assert.assertEquals((String)msg, (Object)expected.getName(), (Object)actual.getName());
    }

    private static void assertSuperclassEquals(SourceClass expected, SourceClass actual) {
        Assert.assertEquals((Object)expected.getSuperclass().getQualifiedName(), (Object)actual.getSuperclass().getQualifiedName());
    }

    private static void assertInterfacesEqual(SourceClass expected, SourceClass actual) {
        Assert.assertEquals((String)"Implemented interfaces are equal", (int)expected.getDeclaredInterfaces().size(), (int)actual.getDeclaredInterfaces().size());
        Iterator declaredInterfaces = expected.getDeclaredInterfaces().iterator();
        while (declaredInterfaces.hasNext()) {
            XClass declaredInterface = (XClass)declaredInterfaces.next();
            Assert.assertTrue((String)("Implements " + declaredInterface.getQualifiedName()), (boolean)actual.isA(declaredInterface.getQualifiedName()));
        }
    }

    private static void assertModifiersEqual(String msg, XProgramElement expected, XProgramElement actual) {
        Assert.assertEquals((String)msg, (Object)expected.getModifiers(), (Object)actual.getModifiers());
    }

    private static void assertNameWithSignatureEquals(String msg, XExecutableMember expected, XExecutableMember actual) {
        Assert.assertEquals((String)msg, (Object)expected.getNameWithSignature(), (Object)actual.getNameWithSignature());
    }

    private static void assertParametersEqual(String msg, XExecutableMember expected, XExecutableMember actual) {
        Assert.assertEquals((String)msg, (int)expected.getParameters().size(), (int)actual.getParameters().size());
        Iterator expectedParameters = expected.getParameters().iterator();
        Iterator actualParameters = actual.getParameters().iterator();
        while (expectedParameters.hasNext()) {
            XParameter expectedParameter = (XParameter)expectedParameters.next();
            XParameter actualParameter = (XParameter)actualParameters.next();
            CodeTestCase.assertParameterEquals(expectedParameter, actualParameter);
        }
    }

    private static void assertThrownExceptionsEqual(String msg, XExecutableMember expected, XExecutableMember actual) {
        Assert.assertEquals((String)msg, (int)expected.getThrownExceptions().size(), (int)actual.getThrownExceptions().size());
        Iterator expectedThrownExceptions = expected.getThrownExceptions().iterator();
        while (expectedThrownExceptions.hasNext()) {
            XClass expectedThrownException = (XClass)expectedThrownExceptions.next();
            Assert.assertTrue((String)("Throws " + expectedThrownException.getQualifiedName()), (boolean)actual.throwsException(expectedThrownException.getQualifiedName()));
        }
    }
}

