/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.common.BetaNodeBinder;
import org.drools.common.DefaultFactHandle;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ObjectMatches;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.TupleMatch;
import org.drools.reteoo.TupleSink;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;
import org.drools.util.LinkedListObjectWrapper;

abstract class TupleSource
extends BaseNode
implements Serializable {
    protected List tupleSinks = new ArrayList(1);

    TupleSource(int n) {
        super(n);
    }

    protected void addTupleSink(TupleSink tupleSink) {
        if (!this.tupleSinks.contains(tupleSink)) {
            this.tupleSinks.add(tupleSink);
        }
    }

    protected void removeTupleSink(TupleSink tupleSink) {
        this.tupleSinks.remove(tupleSink);
    }

    protected TupleMatch attemptJoin(ReteTuple reteTuple, DefaultFactHandle defaultFactHandle, ObjectMatches objectMatches, BetaNodeBinder betaNodeBinder, ReteooWorkingMemory reteooWorkingMemory) {
        if (betaNodeBinder.isAllowed(defaultFactHandle, reteTuple, reteooWorkingMemory)) {
            TupleMatch tupleMatch = objectMatches.add(reteTuple);
            reteTuple.addTupleMatch(defaultFactHandle, tupleMatch);
            return tupleMatch;
        }
        return null;
    }

    protected void propagateAssertTuple(ReteTuple reteTuple, TupleMatch tupleMatch, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        if (!this.getTupleSinks().isEmpty()) {
            ((TupleSink)this.getTupleSinks().get(0)).assertTuple(reteTuple, propagationContext, reteooWorkingMemory);
            tupleMatch.addJoinedTuple(reteTuple);
            int n = this.getTupleSinks().size();
            for (int i = 1; i < n; ++i) {
                ReteTuple reteTuple2 = new ReteTuple(reteTuple);
                tupleMatch.addJoinedTuple(reteTuple2);
                ((TupleSink)this.getTupleSinks().get(i)).assertTuple(reteTuple2, propagationContext, reteooWorkingMemory);
            }
        }
    }

    protected void propagateAssertTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        int n = this.getTupleSinks().size();
        for (int i = 0; i < n; ++i) {
            ReteTuple reteTuple2 = new ReteTuple(reteTuple);
            reteTuple.addLinkedTuple(new LinkedListObjectWrapper(reteTuple2));
            ((TupleSink)this.getTupleSinks().get(i)).assertTuple(reteTuple2, propagationContext, reteooWorkingMemory);
        }
    }

    protected void propagateAssertTuple(ReteTuple reteTuple, DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        int n = this.getTupleSinks().size();
        for (int i = 0; i < n; ++i) {
            ReteTuple reteTuple2 = new ReteTuple(reteTuple, defaultFactHandle);
            reteTuple.addLinkedTuple(new LinkedListObjectWrapper(reteTuple2));
            ((TupleSink)this.getTupleSinks().get(i)).assertTuple(reteTuple2, propagationContext, reteooWorkingMemory);
        }
    }

    protected void propagateRetractTuple(TupleMatch tupleMatch, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        List list = tupleMatch.getJoinedTuples();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((TupleSink)this.getTupleSinks().get(i)).retractTuple((ReteTuple)list.get(i), propagationContext, reteooWorkingMemory);
        }
    }

    protected void propagateRetractTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        LinkedList linkedList = reteTuple.getLinkedTuples();
        if (linkedList != null && !linkedList.isEmpty()) {
            int n = 0;
            LinkedListNode linkedListNode = linkedList.removeFirst();
            while (linkedListNode != null) {
                ((TupleSink)this.getTupleSinks().get(n++)).retractTuple((ReteTuple)((LinkedListObjectWrapper)linkedListNode).getObject(), propagationContext, reteooWorkingMemory);
                linkedListNode = linkedList.removeFirst();
            }
        }
    }

    protected void propagateModifyTuple(TupleMatch tupleMatch, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        List list = tupleMatch.getJoinedTuples();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ((TupleSink)this.getTupleSinks().get(i)).modifyTuple((ReteTuple)list.get(i), propagationContext, reteooWorkingMemory);
        }
    }

    protected void propagateModifyTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        LinkedList linkedList = reteTuple.getLinkedTuples();
        if (linkedList != null && !linkedList.isEmpty()) {
            int n = 0;
            for (LinkedListNode linkedListNode = linkedList.getFirst(); linkedListNode != null; linkedListNode = linkedListNode.getNext()) {
                ((TupleSink)this.getTupleSinks().get(n++)).modifyTuple((ReteTuple)((LinkedListObjectWrapper)linkedListNode).getObject(), propagationContext, reteooWorkingMemory);
            }
        }
    }

    public List getTupleSinks() {
        return this.tupleSinks;
    }

    public abstract List getPropagatedTuples(ReteooWorkingMemory var1, TupleSink var2);
}

