/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderedSynchronizationHandler
implements Synchronization {
    Transaction tx = null;
    LinkedList handlers = new LinkedList();
    static Map instances = new ConcurrentHashMap();
    static Log log = LogFactory.getLog((Class)OrderedSynchronizationHandler.class);

    private OrderedSynchronizationHandler(Transaction tx) {
        this.tx = tx;
    }

    public static OrderedSynchronizationHandler getInstance(Transaction tx) throws SystemException, RollbackException {
        OrderedSynchronizationHandler retval = (OrderedSynchronizationHandler)instances.get(tx);
        if (retval != null) {
            return retval;
        }
        retval = new OrderedSynchronizationHandler(tx);
        tx.registerSynchronization((Synchronization)retval);
        instances.put(tx, retval);
        return retval;
    }

    public void registerAtHead(Synchronization handler) {
        this.register(handler, true);
    }

    public void registerAtTail(Synchronization handler) {
        this.register(handler, false);
    }

    void register(Synchronization handler, boolean head) {
        if (handler != null && !this.handlers.contains(handler)) {
            if (head) {
                this.handlers.addFirst(handler);
            } else {
                this.handlers.addLast(handler);
            }
        }
    }

    public void beforeCompletion() {
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            Synchronization sync = (Synchronization)it.next();
            sync.beforeCompletion();
        }
    }

    public void afterCompletion(int status) {
        RuntimeException exceptionInAfterCompletion = null;
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            Synchronization sync = (Synchronization)it.next();
            try {
                sync.afterCompletion(status);
            }
            catch (Throwable t) {
                log.error((Object)("failed calling afterCompletion() on " + sync), t);
                exceptionInAfterCompletion = (RuntimeException)t;
            }
        }
        instances.remove(this.tx);
        if (exceptionInAfterCompletion != null) {
            throw exceptionInAfterCompletion;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("tx=" + this.getTxAsString() + ", handlers=" + this.handlers);
        return sb.toString();
    }

    private String getTxAsString() {
        if (this.tx == null) {
            return null;
        }
        return this.tx.getClass().getName() + "@" + System.identityHashCode(this.tx);
    }
}

