/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.Base64;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.servletunit.ServletInputStreamImpl;
import com.meterware.servletunit.ServletRequest;
import com.meterware.servletunit.ServletUnitContext;
import com.meterware.servletunit.ServletUnitHttpSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

class ServletUnitHttpRequest
implements HttpServletRequest {
    private ServletInputStreamImpl _inputStream;
    private String _contentType;
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private static final String[] NO_ROLES;
    private WebRequest _request;
    private ServletRequest _servletRequest;
    private WebClient.HeaderDictionary _headers;
    private ServletUnitContext _context;
    private ServletUnitHttpSession _session;
    private Hashtable _attributes = new Hashtable();
    private Hashtable _parameters = new Hashtable();
    private Vector _cookies = new Vector();
    private String _sessionID;
    private byte[] _messageBody;
    private String _userName;
    private String[] _roles;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_HAVE_NAME = 1;
    private static final int STATE_HAVE_EQUALS = 2;
    private static final int STATE_HAVE_VALUE = 3;

    ServletUnitHttpRequest(ServletRequest servletRequest, WebRequest request, ServletUnitContext context, Dictionary clientHeaders, byte[] messageBody) throws MalformedURLException {
        this._servletRequest = servletRequest;
        this._request = request;
        this._context = context;
        this._headers = new WebClient.HeaderDictionary();
        this._headers.addEntries(clientHeaders);
        this._headers.addEntries(request.getHeaders());
        this._messageBody = messageBody;
        this._contentType = (String)this._headers.get("Content-Type");
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        String file = request.getURL().getFile();
        if (file.indexOf(63) >= 0) {
            this.loadParameters(file.substring(file.indexOf(63) + 1));
        } else if (this._contentType == null || this._contentType.indexOf("x-www-form-urlencoded") >= 0) {
            this.loadParameters(request.getQueryString());
            this.loadParameters(new String(this._messageBody));
        }
    }

    public String getAuthType() {
        return null;
    }

    public String getQueryString() {
        return this._request.getQueryString();
    }

    public Cookie[] getCookies() {
        if (this._cookies.size() == 0) {
            return null;
        }
        Object[] result = new Cookie[this._cookies.size()];
        this._cookies.copyInto(result);
        return result;
    }

    public int getIntHeader(String name) {
        return -1;
    }

    public long getDateHeader(String name) {
        return -1L;
    }

    public String getHeader(String name) {
        return (String)this._headers.get(name);
    }

    public Enumeration getHeaderNames() {
        return null;
    }

    public String getServletPath() {
        return this._servletRequest.getServletPath();
    }

    public String getMethod() {
        return this._request.getMethod();
    }

    public String getPathInfo() {
        return this._servletRequest.getPathInfo();
    }

    public String getPathTranslated() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._sessionID != null;
    }

    public String getRemoteUser() {
        return this._userName;
    }

    public String getRequestedSessionId() {
        return this._sessionID;
    }

    public String getRequestURI() {
        try {
            return this._request.getURL().getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public HttpSession getSession(boolean create) {
        if (this._session == null && this.getRequestedSessionId() != null) {
            this._session = this._context.getSession(this.getRequestedSessionId());
        }
        if (this._session == null && create) {
            this._session = this._context.newSession();
        }
        return this._session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public int getContentLength() {
        return -1;
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.keys();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputStream == null) {
            this._inputStream = new ServletInputStreamImpl(this._messageBody);
        }
        return this._inputStream;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public Enumeration getParameterNames() {
        return this._parameters.keys();
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getParameter(String name) {
        String[] parameters = this.getParameterValues(name);
        return parameters == null ? null : parameters[0];
    }

    public String[] getParameterValues(String name) {
        return (String[])this._parameters.get(name);
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getScheme() {
        return "http";
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 0;
    }

    public String getRealPath(String path) {
        this.throwNotImplementedYet();
        return "";
    }

    public BufferedReader getReader() throws IOException {
        this.throwNotImplementedYet();
        return null;
    }

    public String getRemoteAddr() {
        return LOOPBACK_ADDRESS;
    }

    public void setAttribute(String key, Object o) {
        if (this._attributes.get(key) != null) {
            throw new IllegalStateException("Attribute '" + key + "' already has a value");
        }
        this._attributes.put(key, o);
    }

    public boolean isSecure() {
        throw new RuntimeException("isSecure not implemented");
    }

    public Locale getLocale() {
        throw new RuntimeException("getLocale not implemented");
    }

    public Enumeration getLocales() {
        throw new RuntimeException("getLocales not implemented");
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new RuntimeException("getRequestDispatcher not implemented");
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isUserInRole(String role) {
        if (this._roles == null) {
            return false;
        }
        int i = 0;
        while (i < this._roles.length) {
            if (role.equals(this._roles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Enumeration getHeaders(String name) {
        throw new RuntimeException("getHeaders not implemented");
    }

    public String getContextPath() {
        return this._context.getContextPath();
    }

    public Map getParameterMap() {
        return null;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    void addCookie(Cookie cookie) {
        this._cookies.addElement(cookie);
        if (cookie.getName().equalsIgnoreCase("JSESSION")) {
            this._sessionID = cookie.getValue();
        }
    }

    void writeFormAuthentication(String userName, String password) {
        this.getServletSession().setUserInformation(userName, this.toArray(password));
    }

    private ServletUnitHttpSession getServletSession() {
        return (ServletUnitHttpSession)this.getSession();
    }

    void readFormAuthentication() {
        if (this.getSession(false) != null) {
            this.recordAuthenticationInfo(this.getServletSession().getUserName(), this.getServletSession().getRoles());
        }
    }

    void readBasicAuthentication() {
        String authorizationHeader = (String)this._headers.get("Authorization");
        if (authorizationHeader != null) {
            String userAndPassword = Base64.decode(authorizationHeader.substring(authorizationHeader.indexOf(32) + 1));
            int colonPos = userAndPassword.indexOf(58);
            this.recordAuthenticationInfo(userAndPassword.substring(0, colonPos), this.toArray(userAndPassword.substring(colonPos + 1)));
        }
    }

    private String[] toArray(String roleList) {
        StringTokenizer st = new StringTokenizer(roleList, ",");
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }

    void setOriginalURL(URL originalURL) {
        this.getServletSession().setOriginalURL(originalURL);
    }

    URL getOriginalURL() {
        return this.getServletSession().getOriginalURL();
    }

    void recordAuthenticationInfo(String userName, String[] roles) {
        this._userName = userName;
        this._roles = roles;
    }

    String[] getRoles() {
        return this._roles == null ? NO_ROLES : this._roles;
    }

    private void loadParameters(String queryString) {
        if (queryString.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(queryString, "&=", true);
        int state = 0;
        String name = null;
        String value = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("&")) {
                state = 0;
                if (name != null && value != null) {
                    this.addParameter(name, value);
                }
                value = null;
                name = null;
                continue;
            }
            if (token.equals("=")) {
                if (state == 1) {
                    state = 2;
                    continue;
                }
                if (state != 3) continue;
                state = 0;
                continue;
            }
            if (state == 0) {
                name = HttpUnitUtils.decode(token);
                value = "";
                state = 1;
                continue;
            }
            value = HttpUnitUtils.decode(token);
            state = 3;
        }
        if (name != null && value != null) {
            this.addParameter(name, value);
        }
    }

    private void addParameter(String name, String encodedValue) {
        String[] values = (String[])this._parameters.get(name);
        if (values == null) {
            this._parameters.put(name, new String[]{encodedValue});
        } else {
            this._parameters.put(name, this.extendedArray(values, encodedValue));
        }
    }

    private String[] extendedArray(String[] baseArray, String newValue) {
        String[] result = new String[baseArray.length + 1];
        System.arraycopy(baseArray, 0, result, 0, baseArray.length);
        result[baseArray.length] = newValue;
        return result;
    }

    private void throwNotImplementedYet() {
        throw new RuntimeException("Not implemented yet");
    }

    static {
        LOOPBACK_ADDRESS = LOOPBACK_ADDRESS;
        NO_ROLES = new String[0];
        STATE_INITIAL = 0;
        STATE_HAVE_NAME = 1;
        STATE_HAVE_EQUALS = 2;
        STATE_HAVE_VALUE = 3;
    }
}

