/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public class ConstantPool
implements Cloneable,
Node,
Serializable {
    private int constant_pool_count;
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constant_pool) {
        this.setConstantPool(constant_pool);
    }

    ConstantPool(DataInputStream file) throws IOException, ClassFormatException {
        this.constant_pool_count = file.readUnsignedShort();
        this.constant_pool = new Constant[this.constant_pool_count];
        for (int i = 1; i < this.constant_pool_count; ++i) {
            this.constant_pool[i] = Constant.readConstant(file);
            byte tag = this.constant_pool[i].getTag();
            if (tag != 6 && tag != 5) continue;
            ++i;
        }
    }

    public void accept(Visitor v) {
        v.visitConstantPool(this);
    }

    /*
     * WARNING - void declaration
     */
    public String constantToString(Constant c) throws ClassFormatException {
        void var2_5;
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                String str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.getConstant(i, (byte)1);
                String str = "\"" + ConstantPool.escape(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            case 1: {
                String str = ((ConstantUtf8)c).getBytes();
                break;
            }
            case 6: {
                String str = "" + ((ConstantDouble)c).getBytes();
                break;
            }
            case 4: {
                String str = "" + ((ConstantFloat)c).getBytes();
                break;
            }
            case 5: {
                String str = "" + ((ConstantLong)c).getBytes();
                break;
            }
            case 3: {
                String str = "" + ((ConstantInteger)c).getBytes();
                break;
            }
            case 12: {
                String str = this.constantToString(((ConstantNameAndType)c).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)c).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                String str = this.constantToString(((ConstantCP)c).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)c).getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + tag);
            }
        }
        return var2_5;
    }

    private static final String escape(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len + 5);
        char[] ch = str.toCharArray();
        block7: for (int i = 0; i < len; ++i) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
        }
        return buf.toString();
    }

    public String constantToString(int index, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index, tag);
        return this.constantToString(c);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.constant_pool_count);
        for (int i = 1; i < this.constant_pool_count; ++i) {
            if (this.constant_pool[i] == null) continue;
            this.constant_pool[i].dump(file);
        }
    }

    public Constant getConstant(int index) {
        if (index >= this.constant_pool.length || index < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[index];
    }

    public Constant getConstant(int index, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index);
        if (c == null) {
            throw new ClassFormatException("Constant pool at index " + index + " is null.");
        }
        if (c.getTag() == tag) {
            return c;
        }
        throw new ClassFormatException("Expected class `" + Constants.CONSTANT_NAMES[tag] + "' at index " + index + " and got " + c);
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    /*
     * WARNING - void declaration
     */
    public String getConstantString(int index, byte tag) throws ClassFormatException {
        void var4_4;
        Constant c = this.getConstant(index, tag);
        switch (tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + tag);
            }
        }
        c = this.getConstant((int)var4_4, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public int getLength() {
        return this.constant_pool_count;
    }

    public void setConstant(int index, Constant constant) {
        this.constant_pool[index] = constant;
    }

    public void setConstantPool(Constant[] constant_pool) {
        this.constant_pool = constant_pool;
        this.constant_pool_count = constant_pool == null ? 0 : constant_pool.length;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i < this.constant_pool_count; ++i) {
            buf.append(i + ")" + this.constant_pool[i] + "\n");
        }
        return buf.toString();
    }

    public ConstantPool copy() {
        ConstantPool c = null;
        try {
            c = (ConstantPool)this.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        c.constant_pool = new Constant[this.constant_pool_count];
        for (int i = 1; i < this.constant_pool_count; ++i) {
            if (this.constant_pool[i] == null) continue;
            c.constant_pool[i] = this.constant_pool[i].copy();
        }
        return c;
    }
}

