/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFShading;

public class PDFPattern
extends PDFPathPaint {
    protected PDFResources resources = null;
    protected int patternType = 2;
    protected String patternName = null;
    protected int paintType = 2;
    protected int tilingType = 1;
    protected List bBox = null;
    protected double xStep = -1.0;
    protected double yStep = -1.0;
    protected PDFShading shading = null;
    protected List xUID = null;
    protected StringBuffer extGState = null;
    protected List matrix = null;
    protected StringBuffer patternDataStream = null;

    public PDFPattern(int theNumber, String thePatternName, PDFResources theResources, int thePatternType, int thePaintType, int theTilingType, List theBBox, double theXStep, double theYStep, List theMatrix, List theXUID, StringBuffer thePatternDataStream) {
        super(theNumber);
        this.patternName = thePatternName;
        this.resources = theResources;
        this.patternType = 1;
        this.paintType = thePaintType;
        this.tilingType = theTilingType;
        this.bBox = theBBox;
        this.xStep = theXStep;
        this.yStep = theYStep;
        this.matrix = theMatrix;
        this.xUID = theXUID;
        this.patternDataStream = thePatternDataStream;
    }

    public PDFPattern(int theNumber, String thePatternName, int thePatternType, PDFShading theShading, List theXUID, StringBuffer theExtGState, List theMatrix) {
        super(theNumber);
        this.patternName = thePatternName;
        this.patternType = 2;
        this.shading = theShading;
        this.xUID = theXUID;
        this.extGState = theExtGState;
        this.matrix = theMatrix;
    }

    public String getName() {
        return this.patternName;
    }

    public String getColorSpaceOut(boolean fillNotStroke) {
        if (fillNotStroke) {
            return "/Pattern cs /" + this.getName() + " scn \n";
        }
        return "/Pattern CS /" + this.getName() + " SCN \n";
    }

    public byte[] toPDF() {
        int vectorSize = 0;
        int tempInt = 0;
        StringBuffer p = new StringBuffer();
        p.append(this.number + " " + this.generation + " obj\n<< \n/Type /Pattern \n");
        if (this.resources != null) {
            p.append("/Resources " + this.resources.referencePDF() + " \n");
        }
        p.append("/PatternType " + this.patternType + " \n");
        if (this.patternType == 1) {
            p.append("/PaintType " + this.paintType + " \n");
            p.append("/TilingType " + this.tilingType + " \n");
            if (this.bBox != null) {
                vectorSize = this.bBox.size();
                p.append("/BBox [ ");
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append(PDFNumber.doubleOut((Double)this.bBox.get(tempInt)));
                    p.append(" ");
                }
                p.append("] \n");
            }
            p.append("/XStep " + PDFNumber.doubleOut(new Double(this.xStep)) + " \n");
            p.append("/YStep " + PDFNumber.doubleOut(new Double(this.yStep)) + " \n");
            if (this.matrix != null) {
                vectorSize = this.matrix.size();
                p.append("/Matrix [ ");
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append(PDFNumber.doubleOut((Double)this.matrix.get(tempInt)));
                    p.append(" ");
                }
                p.append("] \n");
            }
            if (this.xUID != null) {
                vectorSize = this.xUID.size();
                p.append("/XUID [ ");
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append((Integer)this.xUID.get(tempInt) + " ");
                }
                p.append("] \n");
            }
            if (this.patternDataStream != null) {
                p.append("/Length " + (this.patternDataStream.length() + 1) + " \n");
            }
        } else {
            if (this.shading != null) {
                p.append("/Shading " + this.shading.referencePDF() + " \n");
            }
            if (this.xUID != null) {
                vectorSize = this.xUID.size();
                p.append("/XUID [ ");
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append((Integer)this.xUID.get(tempInt) + " ");
                }
                p.append("] \n");
            }
            if (this.extGState != null) {
                p.append("/ExtGState " + this.extGState + " \n");
            }
            if (this.matrix != null) {
                vectorSize = this.matrix.size();
                p.append("/Matrix [ ");
                for (tempInt = 0; tempInt < vectorSize; ++tempInt) {
                    p.append(PDFNumber.doubleOut((Double)this.matrix.get(tempInt)));
                    p.append(" ");
                }
                p.append("] \n");
            }
        }
        p.append(">> \n");
        if (this.patternDataStream != null) {
            p.append("stream\n" + this.patternDataStream + "\nendstream\n");
        }
        p.append("endobj\n");
        try {
            return p.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return p.toString().getBytes();
        }
    }
}

