/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkedRectangle;
import org.apache.fop.layout.inline.InlineArea;

public class LinkSet {
    private String destination;
    private List rects = new ArrayList();
    private int xoffset = 0;
    private int yoffset = 0;
    private int maxY = 0;
    protected int startIndent;
    protected int endIndent;
    private int linkType;
    private Area area;
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    private int contentRectangleWidth = 0;

    public LinkSet(String destination, Area area, int linkType) {
        this.destination = destination;
        this.area = area;
        this.linkType = linkType;
    }

    public void addRect(Rectangle r, LineArea lineArea, InlineArea inlineArea) {
        LinkedRectangle linkedRectangle = new LinkedRectangle(r, lineArea, inlineArea);
        linkedRectangle.setY(this.yoffset);
        if (this.yoffset > this.maxY) {
            this.maxY = this.yoffset;
        }
        this.rects.add(linkedRectangle);
    }

    public void setYOffset(int y) {
        this.yoffset = y;
    }

    public void setXOffset(int x) {
        this.xoffset = x;
    }

    public void setContentRectangleWidth(int contentRectangleWidth) {
        this.contentRectangleWidth = contentRectangleWidth;
    }

    public void applyAreaContainerOffsets(AreaContainer ac, Area area) {
        int height = area.getAbsoluteHeight();
        BlockArea ba = (BlockArea)area;
        for (int i = 0; i < this.rects.size(); ++i) {
            LinkedRectangle r = (LinkedRectangle)this.rects.get(i);
            r.setX(r.getX() + ac.getXPosition() + area.getTableCellXOffset());
            r.setY(ac.getYPosition() - height + (this.maxY - r.getY()) - ba.getHalfLeading());
        }
    }

    public void mergeLinks() {
        int numRects = this.rects.size();
        if (numRects <= 1) {
            return;
        }
        LinkedRectangle curRect = new LinkedRectangle((LinkedRectangle)this.rects.get(0));
        ArrayList<LinkedRectangle> nv = new ArrayList<LinkedRectangle>();
        for (int ri = 1; ri < numRects; ++ri) {
            LinkedRectangle r = (LinkedRectangle)this.rects.get(ri);
            if (r.getLineArea() == curRect.getLineArea()) {
                curRect.setWidth(r.getX() + r.getWidth() - curRect.getX());
            } else {
                nv.add(curRect);
                curRect = new LinkedRectangle(r);
            }
            if (ri != numRects - 1) continue;
            nv.add(curRect);
        }
        this.rects = nv;
    }

    public void align() {
        for (int i = 0; i < this.rects.size(); ++i) {
            LinkedRectangle r = (LinkedRectangle)this.rects.get(i);
            r.setX(r.getX() + r.getLineArea().getStartIndent() + r.getInlineArea().getXOffset());
        }
    }

    public String getDest() {
        return this.destination;
    }

    public List getRects() {
        return this.rects;
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public Area getArea() {
        return this.area;
    }

    public int getLinkType() {
        return this.linkType;
    }
}

