/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.LocalId;
import org.jboss.tm.TransactionPropagationContextImporter;
import org.jboss.tm.TransactionPropagationContextUtil;

public class TMUtil {
    private static final Logger log = Logger.getLogger(TMUtil.class);
    private static TransactionManager tm;

    private TMUtil() {
    }

    public static Transaction getTransaction(LocalId localId) {
        TransactionPropagationContextImporter tpcImporter = TransactionPropagationContextUtil.getTPCImporter();
        return tpcImporter.importTransactionPropagationContext(localId);
    }

    public static TransactionManager getTransactionManager() {
        if (tm == null) {
            try {
                InitialContext ctx = new InitialContext();
                tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
            }
            catch (NamingException ex) {
                log.error("java:/TransactionManager lookup failed", ex);
            }
        }
        return tm;
    }

    public static int divideAndRoundUp(long m, long n) {
        long retval = m / n;
        if (m % n != 0L) {
            ++retval;
        }
        return (int)retval;
    }
}

