/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.BaseConnectionManager2;
import org.jboss.resource.connectionmanager.ConnectionFactoryBindingServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.naming.NonSerializableFactory;

public class ConnectionFactoryBindingService
extends ServiceMBeanSupport
implements ConnectionFactoryBindingServiceMBean {
    private static final Logger log = Logger.getLogger(ConnectionFactoryBindingService.class);
    protected ObjectName cm;
    protected String jndiName;
    protected String bindName;
    protected boolean useJavaContext = true;
    protected Object cf;

    protected void startService() throws Exception {
        this.determineBindName();
        this.createConnectionFactory();
        this.bindConnectionFactory();
    }

    protected void stopService() throws Exception {
        this.unbindConnectionFactory();
    }

    public ObjectName getConnectionManager() {
        return this.cm;
    }

    public void setConnectionManager(ObjectName cm) {
        this.cm = cm;
    }

    public String getBindName() {
        return this.bindName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public boolean isUseJavaContext() {
        return this.useJavaContext;
    }

    public void setUseJavaContext(boolean useJavaContext) {
        this.useJavaContext = useJavaContext;
    }

    protected void determineBindName() throws Exception {
        this.bindName = this.jndiName;
        if (this.useJavaContext && !this.jndiName.startsWith("java:")) {
            this.bindName = "java:" + this.jndiName;
        }
    }

    protected void createConnectionFactory() throws Exception {
        try {
            BaseConnectionManager2 bcm = (BaseConnectionManager2)this.server.getAttribute(this.cm, "Instance");
            BaseConnectionManager2.ConnectionManagerProxy cmProxy = new BaseConnectionManager2.ConnectionManagerProxy(bcm, this.cm);
            this.cf = bcm.getPoolingStrategy().getManagedConnectionFactory().createConnectionFactory(cmProxy);
        }
        catch (ResourceException re) {
            throw new DeploymentException("Could not create ConnectionFactory for adapter: " + this.cm);
        }
    }

    protected void bindConnectionFactory() throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            log.debug("Binding object '" + this.cf + "' into JNDI at '" + this.bindName + "'");
            Name name = ctx.getNameParser("").parse(this.bindName);
            NonSerializableFactory.rebind(name, this.cf, true);
            log.info("Bound ConnectionManager '" + this.serviceName + "' to JNDI name '" + this.bindName + "'");
        }
        catch (NamingException ne) {
            throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + this.bindName, ne);
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindConnectionFactory() throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            ctx.unbind(this.bindName);
            NonSerializableFactory.unbind(this.bindName);
            log.info("Unbound ConnectionManager '" + this.serviceName + "' from JNDI name '" + this.bindName + "'");
        }
        catch (NamingException ne) {
            log.error("Could not unbind managedConnectionFactory from jndi: " + this.bindName, ne);
        }
        finally {
            ctx.close();
        }
    }
}

