/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.repository.plugins;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.repository.spi.CommonNames;
import org.jboss.repository.spi.KernelRepository;
import org.jboss.repository.spi.Key;
import org.jboss.repository.spi.MetaData;
import org.jboss.repository.spi.MetaDataCombiner;
import org.jboss.repository.spi.MetaDataLoader;

public class AbstractKernelRepository
implements KernelRepository {
    private Map repository = new HashMap(103);
    private Map domainMap = new HashMap(103);
    private Map clusterMap = new HashMap(103);
    private Map serverMap = new HashMap(103);
    private Map appMap = new HashMap(103);
    private Map deployMap = new HashMap(103);
    private Map sessionMap = new HashMap(103);
    private Map[] maps = new Map[]{this.domainMap, this.clusterMap, this.serverMap, this.appMap, this.deployMap, this.sessionMap};
    private MetaDataCombiner combiner;

    public AbstractKernelRepository(MetaDataCombiner combiner) throws Exception {
        this.combiner = combiner;
    }

    public Object getMetaData(Key key) {
        return this.getMetaData(key, this.combiner);
    }

    public Object getMetaData(Key key, MetaDataCombiner combiner) {
        Map attributes = key.getAttributes();
        HashMap<String, String> tmp = new HashMap<String, String>();
        MetaData[] levelData = new MetaData[8];
        int level = key.getLevel();
        for (int n = 0; n <= level; ++n) {
            String levelKey = CommonNames.LEVELS[n];
            String value = (String)attributes.get(levelKey);
            tmp.put(levelKey, value);
            Key tmpKey = new Key(key.getName(), tmp);
            levelData[n] = (MetaData)this.maps[n].get(tmpKey);
        }
        Object value = combiner.combine(key, levelData);
        return value;
    }

    public Map getAllMetaData(Key key) {
        HashMap<Key, MetaData> levelData = new HashMap<Key, MetaData>();
        Map attributes = key.getAttributes();
        HashMap<String, String> tmp = new HashMap<String, String>();
        int level = key.getLevel();
        for (int n = 0; n <= level; ++n) {
            String levelKey = CommonNames.LEVELS[n];
            String value = (String)attributes.get(levelKey);
            tmp.put(levelKey, value);
            Key tmpKey = new Key(key.getName(), tmp);
            MetaData data = (MetaData)this.maps[n].get(tmpKey);
            if (data == null) continue;
            levelData.put(tmpKey, data);
        }
        return levelData;
    }

    public synchronized MetaData addMetaData(Key key, MetaData data) {
        MetaData prev = this.repository.put(key, data);
        int level = key.getLevel();
        this.maps[level].put(key, data);
        return prev;
    }

    public MetaData removeMetaData(Key key) {
        int level = key.getLevel();
        MetaData prev = (MetaData)this.maps[level].remove(key);
        this.repository.remove(key);
        return prev;
    }

    public void loadMetaData(MetaDataLoader loader) {
        Iterator keys = loader.getKeys();
        while (keys.hasNext()) {
            Key key = (Key)keys.next();
            MetaData data = loader.load(key);
            int level = key.getLevel();
            this.maps[level].put(key, data);
        }
    }

    public Iterator getKeyNames() {
        return this.repository.keySet().iterator();
    }

    public Iterator findKeys(String nameRE, Map attributes) {
        return null;
    }
}

