/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SecurityRoleMetaData;

public class AssemblyDescriptorMetaData
extends MetaData {
    private HashMap securityRoles = new HashMap();
    private HashMap messageDestinations = new HashMap();

    public void addSecurityRoleMetaData(SecurityRoleMetaData srMetaData) {
        this.securityRoles.put(srMetaData.getRoleName(), srMetaData);
    }

    public Map getSecurityRoles() {
        return new HashMap(this.securityRoles);
    }

    public void mergeSecurityRoles(Map applRoles) {
        for (Map.Entry entry : applRoles.entrySet()) {
            String roleName = (String)entry.getKey();
            SecurityRoleMetaData appRole = (SecurityRoleMetaData)entry.getValue();
            SecurityRoleMetaData srMetaData = (SecurityRoleMetaData)this.securityRoles.get(roleName);
            if (srMetaData != null) {
                Set principalNames = appRole.getPrincipals();
                srMetaData.addPrincipalNames(principalNames);
                continue;
            }
            this.securityRoles.put(roleName, entry.getValue());
        }
    }

    public SecurityRoleMetaData getSecurityRoleByName(String roleName) {
        return (SecurityRoleMetaData)this.securityRoles.get(roleName);
    }

    public Set getSecurityRoleNamesByPrincipal(String userName) {
        HashSet<String> roleNames = new HashSet<String>();
        for (SecurityRoleMetaData srMetaData : this.securityRoles.values()) {
            if (!srMetaData.getPrincipals().contains(userName)) continue;
            roleNames.add(srMetaData.getRoleName());
        }
        return roleNames;
    }

    public void addMessageDestinationMetaData(MessageDestinationMetaData metaData) {
        this.messageDestinations.put(metaData.getName(), metaData);
    }

    public MessageDestinationMetaData getMessageDestinationMetaData(String name) {
        return (MessageDestinationMetaData)this.messageDestinations.get(name);
    }
}

