/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.PojoInjector;
import org.jboss.logging.Logger;

public class EntityManagerFactoryMethodInjector
implements Injector,
PojoInjector {
    private static final Logger log = Logger.getLogger(EntityManagerFactoryMethodInjector.class);
    private Method setMethod;
    private Container container;
    private Object factory;

    public EntityManagerFactoryMethodInjector(Method setMethod, Container container, Object factory) {
        this.setMethod = setMethod;
        this.container = container;
        this.factory = factory;
    }

    public void inject(BeanContext ctx) {
        this.inject(ctx, ctx.getInstance());
    }

    public void inject(BeanContext ctx, Object instance) {
        try {
            Object[] args = new Object[]{this.factory};
            this.setMethod.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed in setting EntityManager on setter method: " + this.setMethod.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public Class getInjectionClass() {
        return this.setMethod.getParameterTypes()[0];
    }
}

