/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.local;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactoryContainer;
import org.jboss.ejb.LocalProxyFactory;
import org.jboss.ejb.plugins.local.EntityProxy;
import org.jboss.ejb.plugins.local.LocalHomeProxy;
import org.jboss.ejb.plugins.local.StatefulSessionProxy;
import org.jboss.ejb.plugins.local.StatelessSessionProxy;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.LocalEJBInvocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.metadata.BeanMetaData;
import org.jboss.naming.Util;
import org.jboss.security.SecurityAssociation;
import org.jboss.tm.TransactionLocal;
import org.jboss.util.NestedRuntimeException;

public class BaseLocalProxyFactory
implements LocalProxyFactory {
    protected static Logger log = Logger.getLogger(BaseLocalProxyFactory.class);
    protected static Map invokerMap = Collections.synchronizedMap(new HashMap());
    protected Container container;
    protected String localJndiName;
    protected TransactionManager transactionManager;
    protected EJBLocalHome home;
    protected EJBLocalObject statelessObject;
    protected Map beanMethodInvokerMap;
    protected Map homeMethodInvokerMap;
    protected Class localHomeClass;
    protected Class localClass;
    protected Constructor proxyClassConstructor;
    private final TransactionLocal cache = new TransactionLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    public void setContainer(Container con) {
        this.container = con;
    }

    public void create() throws Exception {
        BeanMetaData metaData = this.container.getBeanMetaData();
        this.localJndiName = metaData.getLocalJndiName();
    }

    public void start() throws Exception {
        long hash;
        int i;
        BeanMetaData metaData = this.container.getBeanMetaData();
        EJBProxyFactoryContainer invokerContainer = (EJBProxyFactoryContainer)((Object)this.container);
        this.localHomeClass = invokerContainer.getLocalHomeClass();
        this.localClass = invokerContainer.getLocalClass();
        if (this.localHomeClass == null || this.localClass == null) {
            log.debug(metaData.getEjbName() + " cannot be Bound, doesn't " + "have local and local home interfaces");
            return;
        }
        Class[] intfs = new Class[]{this.localClass};
        Class<?> proxyClass = Proxy.getProxyClass(ClassLoaderAction.UTIL.get(this.localClass), intfs);
        Class[] constructorParams = new Class[]{InvocationHandler.class};
        this.proxyClassConstructor = proxyClass.getConstructor(constructorParams);
        InitialContext iniCtx = new InitialContext();
        String beanName = metaData.getEjbName();
        this.transactionManager = (TransactionManager)iniCtx.lookup("java:/TransactionManager");
        Method[] methods = this.localClass.getMethods();
        this.beanMethodInvokerMap = new HashMap();
        for (i = 0; i < methods.length; ++i) {
            hash = MarshalledInvocation.calculateHash(methods[i]);
            this.beanMethodInvokerMap.put(new Long(hash), methods[i]);
        }
        methods = this.localHomeClass.getMethods();
        this.homeMethodInvokerMap = new HashMap();
        for (i = 0; i < methods.length; ++i) {
            hash = MarshalledInvocation.calculateHash(methods[i]);
            this.homeMethodInvokerMap.put(new Long(hash), methods[i]);
        }
        Util.rebind((Context)iniCtx, this.localJndiName, (Object)this.getEJBLocalHome());
        invokerMap.put(this.localJndiName, this);
        log.info("Bound EJB LocalHome '" + beanName + "' to jndi '" + this.localJndiName + "'");
    }

    public void stop() {
        try {
            if (invokerMap.remove(this.localJndiName) == this) {
                log.info("Unbind EJB LocalHome '" + this.container.getBeanMetaData().getEjbName() + "' from jndi '" + this.localJndiName + "'");
                InitialContext ctx = new InitialContext();
                ctx.unbind(this.localJndiName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        if (this.beanMethodInvokerMap != null) {
            this.beanMethodInvokerMap.clear();
        }
        if (this.homeMethodInvokerMap != null) {
            this.homeMethodInvokerMap.clear();
        }
        MarshalledInvocation.removeHashes(this.localHomeClass);
        MarshalledInvocation.removeHashes(this.localClass);
        this.container = null;
    }

    public Constructor getProxyClassConstructor() {
        if (this.proxyClassConstructor == null) {
            // empty if block
        }
        return this.proxyClassConstructor;
    }

    public EJBLocalHome getEJBLocalHome() {
        if (this.home == null) {
            EJBProxyFactoryContainer cic = (EJBProxyFactoryContainer)((Object)this.container);
            LocalHomeProxy handler = new LocalHomeProxy(this.localJndiName, this);
            ClassLoader loader = ClassLoaderAction.UTIL.get(cic.getLocalHomeClass());
            Class[] interfaces = new Class[]{cic.getLocalHomeClass()};
            this.home = (EJBLocalHome)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
        }
        return this.home;
    }

    public EJBLocalObject getStatelessSessionEJBLocalObject() {
        if (this.statelessObject == null) {
            EJBProxyFactoryContainer cic = (EJBProxyFactoryContainer)((Object)this.container);
            StatelessSessionProxy handler = new StatelessSessionProxy(this.localJndiName, this);
            ClassLoader loader = ClassLoaderAction.UTIL.get(cic.getLocalClass());
            Class[] interfaces = new Class[]{cic.getLocalClass()};
            this.statelessObject = (EJBLocalObject)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
        }
        return this.statelessObject;
    }

    public EJBLocalObject getStatefulSessionEJBLocalObject(Object id) {
        StatefulSessionProxy handler = new StatefulSessionProxy(this.localJndiName, id, this);
        try {
            return (EJBLocalObject)this.proxyClassConstructor.newInstance(handler);
        }
        catch (Exception ex) {
            throw new NestedRuntimeException(ex);
        }
    }

    public Object getEntityEJBObject(Object id) {
        return this.getEntityEJBLocalObject(id);
    }

    public EJBLocalObject getEntityEJBLocalObject(Object id, boolean create) {
        EJBLocalObject result = null;
        if (id != null) {
            Transaction tx = this.cache.getTransaction();
            if (tx == null) {
                result = this.createEJBLocalObject(id);
            } else {
                Map map = (Map)this.cache.get(tx);
                if (create) {
                    result = this.createEJBLocalObject(id);
                    map.put(id, result);
                } else {
                    result = (EJBLocalObject)map.get(id);
                    if (result == null) {
                        result = this.createEJBLocalObject(id);
                        map.put(id, result);
                    }
                }
            }
        }
        return result;
    }

    public EJBLocalObject getEntityEJBLocalObject(Object id) {
        return this.getEntityEJBLocalObject(id, false);
    }

    public Collection getEntityLocalCollection(Collection ids) {
        ArrayList<EJBLocalObject> list = new ArrayList<EJBLocalObject>(ids.size());
        for (Object nextId : ids) {
            list.add(this.getEntityEJBLocalObject(nextId));
        }
        return list;
    }

    public Object invokeHome(Method m, Object[] args) throws Exception {
        boolean setCl;
        ClassLoader oldCl = TCLAction.UTIL.getContextClassLoader();
        boolean bl = setCl = !oldCl.equals(this.container.getClassLoader());
        if (setCl) {
            TCLAction.UTIL.setContextClassLoader(this.container.getClassLoader());
        }
        SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
        try {
            LocalEJBInvocation invocation = new LocalEJBInvocation(null, m, args, this.getTransaction(), sa.getPrincipal(), sa.getCredential());
            invocation.setType(InvocationType.LOCALHOME);
            Object object = this.container.invoke(invocation);
            return object;
        }
        catch (AccessException ae) {
            throw new AccessLocalException(ae.getMessage(), ae);
        }
        catch (NoSuchObjectException nsoe) {
            throw new NoSuchObjectLocalException(nsoe.getMessage(), nsoe);
        }
        catch (TransactionRequiredException tre) {
            throw new TransactionRequiredLocalException(tre.getMessage());
        }
        catch (TransactionRolledbackException trbe) {
            throw new TransactionRolledbackLocalException(trbe.getMessage(), trbe);
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(oldCl);
            }
        }
    }

    public String getJndiName() {
        return this.localJndiName;
    }

    Transaction getTransaction() throws SystemException {
        if (this.transactionManager == null) {
            return null;
        }
        return this.transactionManager.getTransaction();
    }

    public Object invoke(Object id, Method m, Object[] args) throws Exception {
        boolean setCl;
        ClassLoader oldCl = TCLAction.UTIL.getContextClassLoader();
        boolean bl = setCl = !oldCl.equals(this.container.getClassLoader());
        if (setCl) {
            TCLAction.UTIL.setContextClassLoader(this.container.getClassLoader());
        }
        SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
        try {
            LocalEJBInvocation invocation = new LocalEJBInvocation(id, m, args, this.getTransaction(), sa.getPrincipal(), sa.getCredential());
            invocation.setType(InvocationType.LOCAL);
            Object object = this.container.invoke(invocation);
            return object;
        }
        catch (AccessException ae) {
            throw new AccessLocalException(ae.getMessage(), ae);
        }
        catch (NoSuchObjectException nsoe) {
            throw new NoSuchObjectLocalException(nsoe.getMessage(), nsoe);
        }
        catch (TransactionRequiredException tre) {
            throw new TransactionRequiredLocalException(tre.getMessage());
        }
        catch (TransactionRolledbackException trbe) {
            throw new TransactionRolledbackLocalException(trbe.getMessage(), trbe);
        }
        finally {
            if (setCl) {
                TCLAction.UTIL.setContextClassLoader(oldCl);
            }
        }
    }

    private EJBLocalObject createEJBLocalObject(Object id) {
        EntityProxy handler = new EntityProxy(this.localJndiName, id, this);
        try {
            return (EJBLocalObject)this.proxyClassConstructor.newInstance(handler);
        }
        catch (Exception ex) {
            throw new NestedRuntimeException(ex);
        }
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    static interface SecurityActions {
        public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

            public Principal getPrincipal() {
                return SecurityAssociation.getPrincipal();
            }

            public Object getCredential() {
                return SecurityAssociation.getCredential();
            }
        };
        public static final SecurityActions PRIVILEGED = new SecurityActions(){
            private final PrivilegedAction getPrincipalAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getPrincipal();
                }
            };
            private final PrivilegedAction getCredentialAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getCredential();
                }
            };

            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
            }

            public Object getCredential() {
                return AccessController.doPrivileged(this.getCredentialAction);
            }
        };

        public Principal getPrincipal();

        public Object getCredential();

        public static class UTIL {
            static SecurityActions getSecurityActions() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }
        }
    }

    static interface ClassLoaderAction {
        public static final ClassLoaderAction PRIVILEGED = new ClassLoaderAction(){

            public ClassLoader get(final Class clazz) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };
        public static final ClassLoaderAction NON_PRIVILEGED = new ClassLoaderAction(){

            public ClassLoader get(Class clazz) {
                return clazz.getClassLoader();
            }
        };

        public ClassLoader get(Class var1);

        public static class UTIL {
            static ClassLoaderAction getClassLoaderAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader get(Class clazz) {
                return UTIL.getClassLoaderAction().get(clazz);
            }
        }
    }
}

