/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.EntityPersistenceStore;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.metadata.EntityMetaData;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.file.FilenameSuffixFilter;

public class CMPFilePersistenceManager
extends ServiceMBeanSupport
implements EntityPersistenceStore {
    public static final String DEFAULT_STORE_DIRECTORY_NAME = "entities";
    private EntityContainer con;
    private String storeDirName = "entities";
    private File storeDir;
    private Field idField;
    private Method isModified;

    public void setContainer(Container c) {
        this.con = (EntityContainer)c;
    }

    public void setStoreDirectoryName(String dirName) {
        this.storeDirName = dirName;
    }

    public String getStoreDirectoryName() {
        return this.storeDirName;
    }

    public File getStoreDirectory() {
        return this.storeDir;
    }

    protected void createService() throws Exception {
        String ejbName = this.con.getBeanMetaData().getEjbName();
        File dir = ServerConfigLocator.locate().getServerDataDir();
        dir = new File(dir, this.storeDirName);
        this.storeDir = dir = new File(dir, ejbName);
        this.log.debug("Storing entity state for '" + ejbName + "' in: " + this.storeDir);
        if (!this.storeDir.exists() && !this.storeDir.mkdirs()) {
            throw new IOException("Failed to create directory: " + this.storeDir);
        }
        if (!this.storeDir.isDirectory()) {
            throw new IOException("File exists where directory expected: " + this.storeDir);
        }
        if (!this.storeDir.canWrite() || !this.storeDir.canRead()) {
            throw new IOException("Directory must be readable and writable: " + this.storeDir);
        }
        this.idField = this.con.getBeanClass().getField("id");
        this.log.debug("Using id field: " + this.idField);
        try {
            this.isModified = this.con.getBeanClass().getMethod("isModified", new Class[0]);
            if (!this.isModified.getReturnType().equals(Boolean.TYPE)) {
                this.isModified = null;
                this.log.warn("Found isModified method, but return type is not boolean; ignoring");
            } else {
                this.log.debug("Using isModified method: " + this.isModified);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected void destroyService() throws Exception {
        this.storeDir.delete();
    }

    public Object createBeanClassInstance() throws Exception {
        return this.con.getBeanClass().newInstance();
    }

    public void initEntity(EntityEnterpriseContext ctx) {
        Object instance = ctx.getInstance();
        Class<?> ejbClass = instance.getClass();
        EntityMetaData metaData = (EntityMetaData)this.con.getBeanMetaData();
        Iterator i = metaData.getCMPFields();
        while (i.hasNext()) {
            try {
                Field cmpField = ejbClass.getField((String)i.next());
                Class<?> cmpFieldType = cmpField.getType();
                if (cmpFieldType.equals(Boolean.TYPE)) {
                    cmpField.setBoolean(instance, false);
                    continue;
                }
                if (cmpFieldType.equals(Byte.TYPE)) {
                    cmpField.setByte(instance, (byte)0);
                    continue;
                }
                if (cmpFieldType.equals(Integer.TYPE)) {
                    cmpField.setInt(instance, 0);
                    continue;
                }
                if (cmpFieldType.equals(Long.TYPE)) {
                    cmpField.setLong(instance, 0L);
                    continue;
                }
                if (cmpFieldType.equals(Short.TYPE)) {
                    cmpField.setShort(instance, (short)0);
                    continue;
                }
                if (cmpFieldType.equals(Character.TYPE)) {
                    cmpField.setChar(instance, '\u0000');
                    continue;
                }
                if (cmpFieldType.equals(Double.TYPE)) {
                    cmpField.setDouble(instance, 0.0);
                    continue;
                }
                if (cmpFieldType.equals(Float.TYPE)) {
                    cmpField.setFloat(instance, 0.0f);
                    continue;
                }
                cmpField.set(instance, null);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
    }

    public Object createEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        try {
            Object id = this.idField.get(ctx.getInstance());
            if (this.getFile(id).exists()) {
                throw new DuplicateKeyException("Already exists: " + id);
            }
            this.storeEntity(id, ctx.getInstance());
            return id;
        }
        catch (IllegalAccessException e) {
            throw new CreateException("Could not create entity: " + e);
        }
    }

    public Object postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        return null;
    }

    public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws FinderException {
        if (finderMethod.getName().equals("findByPrimaryKey")) {
            if (!this.getFile(args[0]).exists()) {
                throw new FinderException(args[0] + " does not exist");
            }
            return factory.getEntityEJBObject(args[0]);
        }
        return null;
    }

    public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) {
        if (finderMethod.getName().equals("findAll")) {
            String[] files = this.storeDir.list(new FilenameSuffixFilter(".ser"));
            ArrayList<Object> result = new ArrayList<Object>(files.length);
            for (int i = 0; i < files.length; ++i) {
                String key = files[i].substring(0, files[i].length() - 4);
                result.add(factory.getEntityEJBObject(key));
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void activateEntity(EntityEnterpriseContext ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEntity(EntityEnterpriseContext ctx) {
        try {
            Object obj = ctx.getInstance();
            CMPObjectInputStream in = new CMPObjectInputStream(new BufferedInputStream(new FileInputStream(this.getFile(ctx.getId()))));
            try {
                Field[] f = obj.getClass().getFields();
                for (int i = 0; i < f.length; ++i) {
                    f[i].set(obj, in.readObject());
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            throw new EJBException("Load failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEntity(Object id, Object obj) {
        try {
            CMPObjectOutputStream out = new CMPObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getFile(id))));
            try {
                Field[] f = obj.getClass().getFields();
                for (int i = 0; i < f.length; ++i) {
                    out.writeObject(f[i].get(obj));
                }
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new EJBException("Store failed", e);
        }
    }

    public boolean isStoreRequired(EntityEnterpriseContext ctx) throws Exception {
        if (this.isModified == null) {
            return true;
        }
        Boolean modified = (Boolean)this.isModified.invoke(ctx.getInstance(), new Object[0]);
        return modified;
    }

    public boolean isModified(EntityEnterpriseContext ctx) throws Exception {
        return this.isStoreRequired(ctx);
    }

    public void storeEntity(EntityEnterpriseContext ctx) {
        this.storeEntity(ctx.getId(), ctx.getInstance());
    }

    public void passivateEntity(EntityEnterpriseContext ctx) {
    }

    public void removeEntity(EntityEnterpriseContext ctx) throws RemoveException {
        File file = this.getFile(ctx.getId());
        if (!file.delete()) {
            throw new RemoveException("Could not remove file: " + file);
        }
    }

    protected File getFile(Object id) {
        return new File(this.storeDir, String.valueOf(id) + ".ser");
    }

    static class CMPObjectInputStream
    extends ObjectInputStream {
        public CMPObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof Handle) {
                return ((Handle)obj).getEJBObject();
            }
            return obj;
        }
    }

    static class CMPObjectOutputStream
    extends ObjectOutputStream {
        public CMPObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof EJBObject) {
                return ((EJBObject)obj).getHandle();
            }
            return obj;
        }
    }
}

