/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.config.plugins;

import org.jboss.beans.info.plugins.AbstractBeanInfoFactory;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.classadapter.plugins.BasicClassAdapterFactory;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.classadapter.spi.ClassAdapterFactory;
import org.jboss.config.spi.Configuration;
import org.jboss.joinpoint.plugins.BasicJoinpointFactoryBuilder;
import org.jboss.joinpoint.spi.JoinpointFactoryBuilder;
import org.jboss.logging.Logger;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.repository.plugins.basic.BasicMetaDataContextFactory;
import org.jboss.repository.spi.MetaDataContextFactory;
import org.jboss.util.NestedRuntimeException;

public abstract class AbstractConfiguration
implements Configuration {
    private static final Logger log = Logger.getLogger(AbstractConfiguration.class);
    private BeanInfoFactory beanInfoFactory;
    private ClassAdapterFactory classAdapterFactory;
    private TypeInfoFactory typeInfoFactory;
    private JoinpointFactoryBuilder joinpointFactoryBuilder;
    private MetaDataContextFactory metaDataContextFactory;

    public BeanInfo getBeanInfo(String className, ClassLoader cl) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(className, cl);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    public BeanInfo getBeanInfo(Class clazz) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(clazz);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    public BeanInfo getBeanInfo(TypeInfo typeInfo) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(typeInfo);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    public ClassInfo getClassInfo(String className, ClassLoader cl) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(className, cl);
        return classAdapter.getClassInfo();
    }

    public ClassInfo getClassInfo(Class clazz) throws Throwable {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(clazz);
        return classAdapter.getClassInfo();
    }

    public TypeInfoFactory getTypeInfoFactory() {
        if (this.typeInfoFactory == null) {
            try {
                this.typeInfoFactory = this.createDefaultTypeInfoFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create TypeInfoFactory", t);
            }
        }
        return this.typeInfoFactory;
    }

    public JoinpointFactoryBuilder getJoinpointFactoryBuilder() {
        if (this.joinpointFactoryBuilder == null) {
            try {
                this.joinpointFactoryBuilder = this.createDefaultJoinpointFactoryBuilder();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create JoinpointFactoryBuilder", t);
            }
        }
        return this.joinpointFactoryBuilder;
    }

    public MetaDataContextFactory getMetaDataContextFactory() {
        if (this.metaDataContextFactory == null) {
            try {
                this.metaDataContextFactory = this.createDefaultMetaDataContextFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create MetaDataContextFactory", t);
            }
        }
        return this.metaDataContextFactory;
    }

    protected BeanInfoFactory getBeanInfoFactory() throws Throwable {
        if (this.beanInfoFactory == null) {
            this.beanInfoFactory = this.createDefaultBeanInfoFactory();
        }
        return this.beanInfoFactory;
    }

    protected ClassAdapterFactory getClassAdapterFactory() throws Throwable {
        if (this.classAdapterFactory == null) {
            this.classAdapterFactory = this.createDefaultClassAdapterFactory();
        }
        return this.classAdapterFactory;
    }

    protected BeanInfoFactory createDefaultBeanInfoFactory() throws Throwable {
        return new AbstractBeanInfoFactory();
    }

    protected ClassAdapterFactory createDefaultClassAdapterFactory() throws Throwable {
        ClassAdapterFactory result = new BasicClassAdapterFactory();
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("org.jboss.aop.microcontainer.prototype.AOPClassAdapterFactory");
            result = (ClassAdapterFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException ignored) {
            log.trace("No AOP in classpath " + ignored.getMessage());
        }
        result.setConfiguration(this);
        return result;
    }

    protected TypeInfoFactory createDefaultTypeInfoFactory() throws Throwable {
        return new IntrospectionTypeInfoFactory();
    }

    protected JoinpointFactoryBuilder createDefaultJoinpointFactoryBuilder() throws Throwable {
        JoinpointFactoryBuilder result = new BasicJoinpointFactoryBuilder();
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("org.jboss.aop.microcontainer.prototype.AOPJoinpointFactoryBuilder");
            result = (JoinpointFactoryBuilder)clazz.newInstance();
        }
        catch (ClassNotFoundException ignored) {
            log.trace("No AOP in classpath " + ignored.getMessage());
        }
        return result;
    }

    protected MetaDataContextFactory createDefaultMetaDataContextFactory() throws Throwable {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("org.jboss.aop.microcontainer.prototype.AOPMetaDataContextFactory");
            return (MetaDataContextFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException ignored) {
            log.trace("No AOP in classpath " + ignored.getMessage());
            return new BasicMetaDataContextFactory();
        }
    }
}

