/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc.condition;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javassist.Modifier;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aspects.dbc.DesignByContractAspect;
import org.jboss.aspects.dbc.PostCond;
import org.jboss.aspects.dbc.PreCond;
import org.jboss.aspects.dbc.condition.ConditionManager;
import org.jboss.aspects.dbc.condition.ExecutableCondition;
import org.jboss.aspects.dbc.condition.InvariantCondition;
import org.jboss.aspects.dbc.condition.MethodCondition;

public class MethodConditionManager
extends ConditionManager {
    public static synchronized ExecutableCondition[] getPreConditions(Method method) {
        ExecutableCondition[] pre = (ExecutableCondition[])preConditions.get(method);
        if (pre != null) {
            return pre;
        }
        MethodConditionManager.initialise(method);
        return (ExecutableCondition[])preConditions.get(method);
    }

    public static synchronized ExecutableCondition[] getPostConditions(Method method) {
        ExecutableCondition[] post = (ExecutableCondition[])postConditions.get(method);
        if (post != null) {
            return post;
        }
        MethodConditionManager.initialise(method);
        return (ExecutableCondition[])postConditions.get(method);
    }

    public static synchronized InvariantCondition[] getInvariants(Method method) {
        return MethodConditionManager.getInvariants(method.getDeclaringClass());
    }

    private static void initialise(Method method) {
        Class<?> clazz;
        if (DesignByContractAspect.verbose) {
            System.out.println("[dbc] ===== Intitalising method: " + method);
        }
        ArrayList preConds = new ArrayList();
        ArrayList postConds = new ArrayList();
        boolean first = true;
        Method superMethod = method;
        for (Class<?> curClazz = clazz = method.getDeclaringClass(); curClazz != null; curClazz = curClazz.getSuperclass()) {
            if (first) {
                first = false;
            } else {
                superMethod = MethodConditionManager.findMethodInClass(curClazz, method);
            }
            if (superMethod != null) {
                MethodConditionManager.addMethodConditions(method, superMethod, preConds, postConds);
            }
            MethodConditionManager.addMethodConditionsForInterfaces(preConds, postConds, curClazz, method);
        }
        ExecutableCondition[] pre = preConds.toArray(new ExecutableCondition[preConds.size()]);
        preConditions.put(method, pre);
        ExecutableCondition[] post = postConds.toArray(new ExecutableCondition[postConds.size()]);
        postConditions.put(method, post);
    }

    private static void addMethodConditionsForInterfaces(ArrayList preConds, ArrayList postConds, Class clazz, Method method) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method foundMethod = MethodConditionManager.findMethodInClass(interfaces[i], method);
            if (foundMethod == null) continue;
            MethodConditionManager.addMethodConditions(method, foundMethod, preConds, postConds);
        }
    }

    private static void addMethodConditions(Method realMethod, Method currentMethod, ArrayList preConds, ArrayList postConds) {
        PostCond post;
        PreCond pre = (PreCond)AnnotationElement.getAnyAnnotation(currentMethod, PreCond.class);
        if (pre != null) {
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Found preconditions in method: " + currentMethod);
            }
            MethodConditionManager.addMethodConditions(realMethod, preConds, pre.value());
        }
        if ((post = (PostCond)AnnotationElement.getAnyAnnotation(currentMethod, PostCond.class)) != null) {
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Found postconditions in method: " + currentMethod);
            }
            MethodConditionManager.addMethodConditions(realMethod, postConds, post.value());
        }
    }

    private static ArrayList addMethodConditions(Method realMethod, ArrayList conditions, String[] exprs) {
        if (exprs == null) {
            return conditions;
        }
        boolean staticCall = Modifier.isStatic((int)realMethod.getModifiers());
        for (int i = 0; i < exprs.length; ++i) {
            conditions.add(new MethodCondition(realMethod, exprs[i], staticCall));
        }
        return conditions;
    }

    private static Method findMethodInClass(Class clazz, Method method) {
        String name = method.getName();
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] foundParams;
            Class<?>[] soughtParams;
            if (!methods[i].getName().equals(name) || (soughtParams = method.getParameterTypes()).length != (foundParams = methods[i].getParameterTypes()).length) continue;
            for (int j = 0; j < soughtParams.length && soughtParams[j] == foundParams[j]; ++j) {
            }
            return methods[i];
        }
        return null;
    }
}

