/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.FileOutputStream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.mx.loading.UnifiedClassLoader;

public class JBossClassPool32
extends AOPClassPool {
    protected File tempdir = null;
    protected final Object tmplock = new Object();

    protected JBossClassPool32(ClassLoader cl, ClassPool src, AspectManager manager, File tmp) {
        super(cl, src, manager);
        this.tempdir = tmp;
    }

    protected JBossClassPool32(ClassPool src, AspectManager manager) {
        super(src, manager);
    }

    public boolean isUnloadedClassLoader() {
        if (this.getClassLoader() instanceof UnifiedClassLoader) {
            UnifiedClassLoader rcl = (UnifiedClassLoader)this.getClassLoader();
            return rcl.getLoaderRepository() == null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class toClass(CtClass cc, ClassLoader loader) throws CannotCompileException {
        this.lockInCache(cc);
        if (this.getClassLoader() == null || this.tempdir == null) {
            return super.toClass(cc);
        }
        Class<?> dynClass = null;
        try {
            File classFile = null;
            String classFileName = cc.getName().replace('.', '/') + ".class";
            Object object = this.tmplock;
            synchronized (object) {
                classFile = new File(this.tempdir, classFileName);
                File pkgDirs = classFile.getParentFile();
                pkgDirs.mkdirs();
                FileOutputStream stream = new FileOutputStream(classFile);
                stream.write(cc.toBytecode());
                stream.flush();
                stream.close();
                classFile.deleteOnExit();
            }
            UnifiedClassLoader rcl = (UnifiedClassLoader)this.getClassLoader();
            rcl.clearBlacklists();
            dynClass = this.getClassLoader().loadClass(cc.getName());
        }
        catch (Exception ex) {
            ClassFormatError cfe = new ClassFormatError("Failed to load dyn class: " + cc.getName());
            cfe.initCause(ex);
            throw cfe;
        }
        return dynClass;
    }
}

