/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.output;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;
import org.junitee.output.AbstractOutput;
import org.junitee.runner.TestInfo;
import org.junitee.runner.TestRunnerResults;
import org.junitee.runner.TestSuiteInfo;
import org.junitee.util.StringUtils;

public class HTMLOutput
extends AbstractOutput {
    protected static final String ERROR = "Error";
    protected static final String FAILURE = "Failure";
    protected static final String PASSED = "Passed";
    protected static final String UNKNOWN = "Unknown";
    protected static final String RESOURCE_RED_BULLET = "bullets_red_x.png";
    protected static final String RESOURCE_YELLOW_BULLET = "bullets_orange_x.png";
    protected static final String RESOURCE_GREEN_BULLET = "bullets_green_hook.png";
    protected static final String RESOURCE_INFO = "info.png";
    private String servletPath;
    private NumberFormat numberFormat;
    protected PrintWriter pw;
    private HttpServletResponse response;

    public HTMLOutput(TestRunnerResults results, HttpServletResponse response, String servletPath, boolean filterTrace) throws IOException {
        super(results, filterTrace);
        this.pw = response.getWriter();
        this.response = response;
        this.servletPath = servletPath;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(3);
        this.numberFormat.setMinimumFractionDigits(3);
    }

    public void render() {
        this.response.setContentType("text/html");
        this.printHeader();
        if (this.isFinished()) {
            this.printRunErrors();
            if (!this.isSingleTest()) {
                this.printSummary(true);
            }
            this.printMethodList();
            if (this.isFailure()) {
                this.printErrorsAndFailures();
            }
        } else {
            this.printUnderProgress();
            if (!this.isSingleTest()) {
                this.printSummary(false);
            }
        }
        this.printFooter();
    }

    protected void printHeader() {
        String result;
        String bgColor;
        if (this.isFailure() || this.getErrorMessages().size() > 0) {
            bgColor = "#980000";
            result = "Failed";
        } else {
            bgColor = "#03A35D";
            result = "Success";
        }
        this.pw.println("<html>");
        this.pw.println("<head>");
        this.pw.println("<title>JUnit Tests - " + result + "</title>");
        if (!this.isFinished()) {
            this.pw.println("<META HTTP-EQUIV=Refresh CONTENT=\"2; URL=" + this.response.encodeURL(this.servletPath) + "\">");
        }
        this.pw.println("</head>");
        this.pw.println("<style type=\"text/css\">");
        this.pw.println("\t<!--");
        this.pw.println("\t\tbody\t\t{ font-family: lucida, verdana, sans-serif; font-size: 10pt;");
        this.pw.println("\t\t\t\t\t\tbackground-color: #FFFFFF }");
        this.pw.println("\t\ta:link\t\t{ color: black; }");
        this.pw.println("\t\ta:active\t{ color: black; }");
        this.pw.println("\t\ta:visited\t{ color: black; }");
        this.pw.println("\t\ta:hover\t\t{ color: blue; }");
        this.pw.println("\t\t.pageTitle\t{ font-size: 1em; font-weight: bold;");
        this.pw.println("\t\t\t\t\t\tletter-spacing: 0.125em; text-align: center;");
        this.pw.print("\t\t\t\t\t\tcolor: #FFFFFF;");
        this.pw.println("background-color: " + bgColor + " }");
        this.pw.println("\t\t.sectionTitle\t{ font-weight: bold; ");
        this.pw.println("\t\t\t\t\t\t\tbackground-color: #F4E5E5;");
        this.pw.println("\t\t\t\t\t\t\tborder-top-width: 1px; border-bottom-width: 0;");
        this.pw.println("\t\t\t\t\t\t\tborder-left-width: 0; border-right-width: 0;");
        this.pw.println("\t\t\t\t\t\t\tborder-style: solid; border-color: #980000 }");
        this.pw.println("\t\t.cell       \t{ color: black; background-color: #CCCCFF }");
        this.pw.println("\t\t.passedcell       \t{ color: black; background-color: #CCCCFF }");
        this.pw.println("\t\t.failedcell       \t{ color: black; background-color: #CCCCFF }");
        this.pw.println("\t-->");
        this.pw.println("</style>");
        this.pw.println("<body>");
        this.pw.println("<table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">");
        this.pw.println("\t<tr> <td class=\"pageTitle\"> <h1> JUnit Test Results </h1> </td> </tr>");
        this.pw.println("</table>");
        this.pw.println("<br><br>");
    }

    protected void printFooter() {
        this.pw.println("</body>");
        this.pw.println("</html>");
    }

    protected void printUnderProgress() {
        this.pw.println("<form action=\"" + this.response.encodeURL(this.servletPath) + "\" method=\"get\">");
        this.pw.println("<p>");
        this.pw.println("<table border=\"0\" cellspacing=\"2\" cellpadding=\"3\" width=\"100%\">");
        this.pw.println("<tbody>");
        this.pw.println("<tr><td class=\"sectionTitle\">Execution of tests in progress ...</td></tr>");
        TestInfo currentTest = this.getCurrentInfo();
        if (currentTest != null) {
            this.pw.println("<tr><td class=\"failedcell\">Current test: " + currentTest.getTest() + "</td></tr>");
        }
        if (this.isStopped() && !this.isFinished()) {
            this.pw.println("<tr><td class=\"failedcell\">Execution will be stopped ...</td></tr>");
        } else {
            this.pw.println("<tr><td class=\"failedcell\"><input type=\"submit\" name=\"stop\" value=\"Stop execution\"></td></tr>");
        }
        this.pw.println("<tr><td>&nbsp;</td></tr>");
        this.pw.println("</tbody>");
        this.pw.println("</table>");
        this.pw.println("</p>");
        this.pw.println("</form>");
    }

    protected void printRunErrors() {
        if (this.getErrorMessages().isEmpty()) {
            return;
        }
        this.pw.println("<h2>Errors while running tests</h2>");
        this.pw.println("<p> <table border=\"0\" cellspacing=\"2\" cellpadding=\"3\" width=\"100%\">");
        Iterator errors = this.getErrorMessages().iterator();
        this.pw.println("<tr><td colspan=\"3\" class=\"sectionTitle\">&nbsp;</td></tr>");
        while (errors.hasNext()) {
            String message = (String)errors.next();
            this.pw.println("<tr><td class=\"failedcell\">" + this.image(RESOURCE_RED_BULLET, ERROR) + "</td>");
            this.pw.print("<td class=\"cell\">&nbsp;</td>");
            this.pw.println("<td width=\"100%\" class=\"cell\">" + message + "</td></tr>");
        }
        this.pw.println("<tr><td colspan=\"3\">&nbsp;</td></tr>");
        this.pw.println("</table></p>");
    }

    protected void printSummary(boolean createInfoAndLinks) {
        if (this.getSuiteInfo().isEmpty()) {
            this.pw.println("<h2>No tests executed</h2>");
            return;
        }
        this.pw.println("<h2> Summary of test results </h2>");
        this.pw.println("<p> <table border=\"0\" cellspacing=\"2\" cellpadding=\"3\" width=\"100%\">");
        Iterator suites = this.getSuiteInfo().iterator();
        this.pw.println("<tr><td colspan=\"4\" class=\"sectionTitle\">&nbsp;</td></tr>");
        while (suites.hasNext()) {
            TestSuiteInfo suite = (TestSuiteInfo)suites.next();
            if (createInfoAndLinks) {
                if (suite.successful()) {
                    this.pw.println("<tr><td class=\"passedcell\">" + this.suiteTestLink(suite, this.image(RESOURCE_GREEN_BULLET, "Run test suite")) + "</td>");
                } else if (suite.hasError()) {
                    this.pw.println("<tr><td class=\"failedcell\">" + this.suiteTestLink(suite, this.image(RESOURCE_RED_BULLET, "Run test suite")) + "</td>");
                } else {
                    this.pw.println("<tr><td class=\"failedcell\">" + this.suiteTestLink(suite, this.image(RESOURCE_YELLOW_BULLET, "Run test suite")) + "</td>");
                }
            } else if (suite.successful()) {
                this.pw.println("<tr><td class=\"passedcell\">" + this.image(RESOURCE_GREEN_BULLET, "Run test suite") + "</td>");
            } else if (suite.hasError()) {
                this.pw.println("<tr><td class=\"failedcell\">" + this.image(RESOURCE_RED_BULLET, "Run test suite") + "</td>");
            } else {
                this.pw.println("<tr><td class=\"failedcell\">" + this.image(RESOURCE_YELLOW_BULLET, "Run test suite") + "</td>");
            }
            this.pw.print("<td class=\"cell\">");
            if (createInfoAndLinks) {
                this.pw.print("<a href=\"#" + suite.getTestClassName() + "\">");
                this.pw.print(this.image(RESOURCE_INFO, "Show details"));
                this.pw.print("</a>");
            } else {
                this.pw.print("&nbsp;");
            }
            this.pw.println("</td><td width=\"100%\" class=\"cell\">" + suite.getTestClassName() + "</td><td class=\"cell\" align=\"right\">");
            this.pw.println(this.elapsedTimeAsString(suite.getElapsedTime()) + "&nbsp;sec</td></tr>");
        }
        this.pw.println("<tr><td colspan=\"4\">&nbsp;</td></tr>");
        this.pw.println("</table></p>");
    }

    private String elapsedTimeAsString(long value) {
        return this.numberFormat.format((double)value / 1000.0);
    }

    protected void printMethodList() {
        if (this.getSuiteInfo().isEmpty()) {
            if (this.isSingleTest()) {
                this.pw.println("<h2>No tests executed</h2>");
            }
            return;
        }
        this.pw.println("<h2> List of executed tests</h2>");
        this.pw.println("<p> <table border=\"0\" cellspacing=\"2\" cellpadding=\"3\" width=\"100%\">");
        Iterator suites = this.getSuiteInfo().iterator();
        while (suites.hasNext()) {
            TestSuiteInfo suite = (TestSuiteInfo)suites.next();
            this.pw.print("<tr><td colspan=\"4\" class=\"sectionTitle\">");
            this.pw.print("<a name=\"" + suite.getTestClassName() + "\"></a>");
            this.pw.println(suite.getTestClassName() + "</td></tr>");
            Iterator tests = suite.getTests().iterator();
            while (tests.hasNext()) {
                TestInfo test = (TestInfo)tests.next();
                if (test.successful()) {
                    this.pw.println("<tr><td class=\"passedcell\">" + this.singleTestLink(test, this.image(RESOURCE_GREEN_BULLET, "Run test")) + "</td>");
                } else if (test.hasError()) {
                    this.pw.println("<tr><td class=\"failedcell\">" + this.singleTestLink(test, this.image(RESOURCE_RED_BULLET, "Run test")) + "</td>");
                } else {
                    this.pw.println("<tr><td class=\"failedcell\">" + this.singleTestLink(test, this.image(RESOURCE_YELLOW_BULLET, "Run test")) + "</td>");
                }
                this.pw.print("<td class=\"cell\">");
                if (test.successful()) {
                    this.pw.print("&nbsp;");
                } else {
                    this.pw.print("<a href=\"#" + test + "\">");
                    this.pw.print(this.image(RESOURCE_INFO, "Show details"));
                    this.pw.print("</a>");
                }
                this.pw.println("</td>");
                this.pw.println("<td width=\"100%\" class=\"cell\">" + test + "</td><td class=\"cell\" align=\"right\">");
                this.pw.println(this.elapsedTimeAsString(test.getElapsedTime()) + "&nbsp;sec</td></tr>");
            }
            this.pw.println("<tr><td colspan=\"4\">&nbsp;</td></tr>");
        }
        this.pw.println("</table></p>");
    }

    private String image(String resource, String alt) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer url = new StringBuffer();
        url.append(this.servletPath).append("/").append(resource);
        buffer.append("<img src=\"").append(this.response.encodeURL(url.toString())).append("\" border=\"0\" height=\"14\" widht=\"14\" alt=\"");
        buffer.append(alt).append("\">");
        return buffer.toString();
    }

    private String singleTestLink(TestInfo test, String text) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer url = new StringBuffer();
        url.append(this.servletPath).append("?suite=").append(test.getTestClassName());
        url.append("&test=").append(test.getTestName());
        buffer.append("<a href=\"").append(this.response.encodeURL(url.toString())).append("\">").append(text).append("</a>");
        return buffer.toString();
    }

    private String suiteTestLink(TestSuiteInfo suite, String text) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer url = new StringBuffer();
        url.append(this.servletPath).append("?suite=").append(suite.getTestClassName());
        buffer.append("<a href=\"").append(this.response.encodeURL(url.toString()));
        buffer.append("\">").append(text).append("</a>");
        return buffer.toString();
    }

    protected void printErrorsAndFailures() {
        this.pw.println("<h2> List of errors and failures</h2>");
        this.pw.println("<p> <table border=\"0\" cellspacing=\"2\" cellpadding=\"3\" width=\"100%\">");
        Iterator suites = this.getSuiteInfo().iterator();
        while (suites.hasNext()) {
            TestSuiteInfo suite = (TestSuiteInfo)suites.next();
            Iterator tests = suite.getTests().iterator();
            while (tests.hasNext()) {
                String stackTrace;
                TestInfo test = (TestInfo)tests.next();
                if (test.successful()) continue;
                this.pw.print("<tr><td class=\"sectionTitle\">");
                this.pw.print("<a name=\"" + test + "\"></a>");
                this.pw.println(test + "</td></tr>");
                Throwable t = test.getError();
                if (t != null) {
                    stackTrace = this.exceptionToString(t);
                    if (this.isFilterTrace()) {
                        stackTrace = StringUtils.filterStack(stackTrace);
                    }
                    this.pw.println("<tr><td class=\"cell\">");
                    this.pw.println(StringUtils.htmlText(t.getMessage()));
                    this.pw.println("&nbsp;</td></tr>");
                    this.pw.println("<tr><td class=\"cell\">");
                    this.pw.println(StringUtils.htmlText(stackTrace));
                    this.pw.println(StringUtils.htmlText(this.getEJBExceptionDetail(t)));
                    this.pw.println("</td></tr>");
                }
                if ((t = test.getFailure()) != null) {
                    stackTrace = this.exceptionToString(t);
                    if (this.isFilterTrace()) {
                        stackTrace = StringUtils.filterStack(stackTrace);
                    }
                    this.pw.println("<tr><td class=\"cell\">");
                    this.pw.println(StringUtils.htmlText(t.getMessage()));
                    this.pw.println("&nbsp;</td>");
                    this.pw.println("<tr><td class=\"cell\">");
                    this.pw.println(StringUtils.htmlText(stackTrace));
                    this.pw.println(StringUtils.htmlText(this.getEJBExceptionDetail(t)));
                    this.pw.println("</td></tr>");
                }
                this.pw.println("<tr><td>&nbsp;</td></tr>");
            }
        }
        this.pw.println("</table>");
    }
}

