/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class KernelPermission
extends BasicPermission {
    private static final long serialVersionUID = 5661980843569388590L;
    private transient boolean allNames;

    public KernelPermission(String string) {
        this(string, null);
    }

    public KernelPermission(String string, String string2) {
        super(string, string2);
        this.init(string, string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getClass().getName()).append(":");
        stringBuffer.append(" name=").append(this.getName());
        stringBuffer.append(" actions=").append(this.getActions());
        return stringBuffer.toString();
    }

    public boolean implies(Permission permission) {
        String string;
        String string2;
        boolean bl;
        if (!(permission instanceof KernelPermission)) {
            return false;
        }
        boolean bl2 = bl = this.allNames;
        if (!bl && !(bl = (string2 = this.getName()).equals(string = permission.getName()))) {
            bl = string2.equals("configure") && string.equals("access");
        }
        return bl;
    }

    public PermissionCollection newPermissionCollection() {
        return new KernelPermissionCollection();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), this.getActions());
    }

    private void init(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (string2 != null && string2.length() > 0) {
            throw new IllegalArgumentException("actions must be null or empty");
        }
        if (!(string.equals("*") || string.equals("access") || string.equals("configure"))) {
            throw new IllegalArgumentException("Unknown name: " + string);
        }
        this.allNames = string.equals("*");
    }

    class KernelPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 3256442516797665329L;
        private HashSet permissions = new HashSet();
        private boolean hasAll;

        KernelPermissionCollection() {
        }

        public void add(Permission permission) {
            if (this.isReadOnly()) {
                throw new SecurityException("Collection is read-only");
            }
            if (permission instanceof KernelPermission) {
                this.permissions.add(permission);
            }
            if (permission.getName().equals("configure")) {
                this.permissions.add(new KernelPermission("access"));
            } else if (permission.getName().equals("*")) {
                this.hasAll = true;
            }
        }

        public boolean implies(Permission permission) {
            boolean bl = false;
            if (permission instanceof KernelPermission && !(bl = this.hasAll)) {
                bl = this.permissions.contains(permission);
            }
            return bl;
        }

        public Enumeration elements() {
            final Iterator iterator = this.permissions.iterator();
            Enumeration enumeration = new Enumeration(){

                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                public Object nextElement() {
                    return iterator.next();
                }
            };
            return enumeration;
        }
    }
}

