/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.transxn;

import com.pointbase.api.apiConnection;
import com.pointbase.buffer.bufferRange;
import com.pointbase.cache.cacheIPageFactory;
import com.pointbase.cache.cacheManager;
import com.pointbase.ckpoint.ckpointManager;
import com.pointbase.collxn.collxnHashtable;
import com.pointbase.collxn.collxnIEnumerator;
import com.pointbase.collxn.collxnVector;
import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.dbga.dbgaProperties;
import com.pointbase.dpage.dpageDataPage;
import com.pointbase.dpage.dpageDataPageFactory;
import com.pointbase.jdbc.jdbcConnection;
import com.pointbase.lock.lockManager;
import com.pointbase.session.session;
import com.pointbase.session.sessionManager;
import com.pointbase.sprel.sprelManager;
import com.pointbase.table.tableITempTable;
import com.pointbase.table.tableLogSwitch;
import com.pointbase.transxn.transxnBase;
import com.pointbase.transxn.transxnLog;
import com.pointbase.transxn.transxnXAManager;

public class transxnManager {
    private static transxnManager currentCache;
    private long m_lastCheckPt = System.currentTimeMillis();
    private collxnHashtable m_RecoveryTxnTable;
    private transxnBase m_CurrentRecoveryUndoTxn = null;
    private static int m_cpInterval;
    private int m_TxnIdSeq = 0;
    private transxnXAManager m_XAManager;

    public static transxnManager getTxnManager() {
        if (currentCache == null) {
            currentCache = new transxnManager();
        }
        return currentCache;
    }

    public transxnBase getCurrentTransaction() {
        return this.m_CurrentRecoveryUndoTxn != null ? this.m_CurrentRecoveryUndoTxn : (this.getSessionManager().getCurrentSession() != null ? this.getSessionManager().getCurrentSession().getCurrentTransaction() : null);
    }

    public transxnBase getTransaction(int n) {
        this.m_CurrentRecoveryUndoTxn = (transxnBase)this.m_RecoveryTxnTable.get(new Integer(n));
        if (this.m_CurrentRecoveryUndoTxn == null) {
            this.setCurrentTransaction(new transxnBase(n));
            this.condSetTxnIdSeq(n);
        }
        return this.m_CurrentRecoveryUndoTxn;
    }

    public collxnVector getTxnList() throws dbexcpException {
        collxnVector collxnVector2 = this.getSessionManager().getTxnList();
        collxnIEnumerator collxnIEnumerator2 = transxnManager.getTxnManager().getXAManager().getTxnList();
        if (collxnIEnumerator2 != null) {
            while (collxnIEnumerator2.hasMoreElements()) {
                collxnVector2.addElement(collxnIEnumerator2.nextElement());
            }
        }
        return collxnVector2;
    }

    public transxnXAManager getXAManager() {
        if (this.m_XAManager == null) {
            this.m_XAManager = new transxnXAManager();
        }
        return this.m_XAManager;
    }

    public void setTopAction() {
        this.getCurrentTransaction().setTopAction();
    }

    public void endTopAction() throws dbexcpException {
        this.getCurrentTransaction().endTopAction();
    }

    public void condFlushPages(transxnBase transxnBase2) throws dbexcpException {
        this.condFlushPages(transxnBase2, false);
    }

    public void flushPages(transxnBase transxnBase2) throws dbexcpException {
        collxnVector collxnVector2 = transxnBase2.getFlushPageVec();
        if (collxnVector2 != null) {
            collxnVector collxnVector3 = cacheManager.getCacheManager().flushDirtyBuffers(collxnVector2);
            transxnBase2.setFlushPageVec(collxnVector3);
        }
    }

    public transxnBase condStartTransaction() throws dbexcpException {
        transxnBase transxnBase2 = this.getCurrentTransaction();
        if (transxnBase2 == null) {
            transxnBase2 = this.startTransaction();
        }
        return transxnBase2;
    }

    public transxnBase startTransaction(int n) throws dbexcpException {
        return new transxnBase(n);
    }

    public transxnBase startTransaction() throws dbexcpException {
        session session2 = this.getSessionManager().getCurrentSession();
        transxnBase transxnBase2 = new transxnBase(this.getNextTxnIdSeq(), (Integer)session2.getProperty(4), (Integer)session2.getProperty(3), 1);
        session2.setCurrentTransaction(transxnBase2);
        collxnHashtable collxnHashtable2 = (collxnHashtable)this.getSessionManager().getCurrentSession().getProperty(2);
        if (collxnHashtable2 != null) {
            collxnIEnumerator collxnIEnumerator2 = collxnHashtable2.elements();
            while (collxnIEnumerator2.hasMoreElements()) {
                transxnBase2.addToLogOffTables(new tableLogSwitch(((Integer)collxnIEnumerator2.nextElement()).intValue()));
            }
        }
        transxnBase2.setTransactionName((bufferRange)session2.getProperty(8));
        return transxnBase2;
    }

    public void createRecTxnTable() {
        this.m_RecoveryTxnTable = new collxnHashtable();
    }

    public void removeRecTxnTable() {
        this.m_RecoveryTxnTable = null;
        this.m_CurrentRecoveryUndoTxn = null;
    }

    public collxnIEnumerator recoveryTxns() {
        return this.m_RecoveryTxnTable.elements();
    }

    public void setCurrentTransaction(transxnBase transxnBase2) {
        this.m_CurrentRecoveryUndoTxn = transxnBase2;
        this.m_RecoveryTxnTable.put(new Integer(transxnBase2.getTransactionId()), transxnBase2);
    }

    public int getTxnIdSeq() {
        return this.m_TxnIdSeq;
    }

    public void setTxnIdSeq(int n) {
        this.m_TxnIdSeq = n;
    }

    public void endRollback(transxnBase transxnBase2) throws dbexcpException {
        boolean bl = this.freeDeferPageChain(transxnBase2);
        if (transxnBase2 != null && !transxnBase2.isEmpty()) {
            new transxnLog().writeEndLog((byte)8, null);
        }
        this.condFlushPages(transxnBase2, bl);
        this.endTransaction(transxnBase2);
    }

    public void endTransaction(int n) throws dbexcpException {
        this.m_RecoveryTxnTable.remove(new Integer(n));
    }

    public void endTransaction() throws dbexcpException {
        if (this.m_CurrentRecoveryUndoTxn != null) {
            this.endTransaction(this.m_CurrentRecoveryUndoTxn.getTransactionId());
        }
        this.endTransaction(this.getCurrentTransaction());
    }

    public boolean prepareToCommit() throws dbexcpException {
        transxnBase transxnBase2 = this.getCurrentTransaction();
        if (transxnBase2 == null || transxnBase2.getFirstLSN() == null) {
            return false;
        }
        this.dropTempTables(transxnBase2);
        boolean bl = this.freeDeferPageChain(transxnBase2);
        this.flushPages(transxnBase2);
        this.condFlushPages(transxnBase2, bl);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void dropTempTables(transxnBase var1_1) throws dbexcpException {
        var2_2 = var1_1.tempTableElements();
        if (var2_2 != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = (tableITempTable)var2_2.nextElement();
            var3_3.dropTable();
lbl6:
            // 2 sources

            ** while (var2_2.hasMoreElements())
        }
lbl7:
        // 1 sources

    }

    private boolean freeDeferPageChain(transxnBase transxnBase2) throws dbexcpException {
        boolean bl = false;
        collxnIEnumerator collxnIEnumerator2 = transxnBase2.deferPageElements();
        while (collxnIEnumerator2.hasMoreElements()) {
            int n = (Integer)collxnIEnumerator2.nextElement();
            dpageDataPage dpageDataPage2 = this.getdPage(n);
            dpageDataPage2.freePageChain();
            dpageDataPage2.releasePage();
            transxnBase2.removeDeferPageId(n);
            bl = true;
        }
        return bl;
    }

    public void requestCheckpoint() {
        try {
            long l = System.currentTimeMillis();
            if (m_cpInterval > 0 && l - this.m_lastCheckPt > (long)(1000 * m_cpInterval)) {
                this.m_lastCheckPt = l;
                ckpointManager.getCheckPointManager().checkPoint(false);
                if (this.getSessionManager().getCurrentSession() != null) {
                    sprelManager.getSprelManager().releaseSpace();
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            System.out.println("Error occured in check point " + dbexcpException2);
        }
    }

    synchronized int getNextTxnIdSeq() throws dbexcpException {
        ++this.m_TxnIdSeq;
        return this.m_TxnIdSeq;
    }

    private void condFlushPages(transxnBase transxnBase2, boolean bl) throws dbexcpException {
        if (transxnBase2.getFlushPages() || bl) {
            cacheManager.getCacheManager().writeAllBuffers();
        }
    }

    private void condSetTxnIdSeq(int n) {
        if (n > this.m_TxnIdSeq) {
            this.m_TxnIdSeq = n;
        }
    }

    private void endTransaction(transxnBase transxnBase2) throws dbexcpException {
        if (transxnBase2 != null) {
            jdbcConnection jdbcConnection2;
            session session2 = this.getSessionManager().getCurrentSession();
            if (session2 != null && (jdbcConnection2 = session2.getJDBCConnection()) != null) {
                apiConnection apiConnection2 = jdbcConnection2.getApiConnection();
                apiConnection2.condStmtsClose(false, null);
            }
            lockManager.getLockManager().releaseTxnLocks(transxnBase2);
            if (session2 != null) {
                session2.setCurrentTransaction(null);
            }
            if (transxnBase2.isXA()) {
                transxnManager.getTxnManager().getXAManager().removeTransaction(transxnBase2.getXABase().getXid());
            }
        }
        this.requestCheckpoint();
    }

    private dpageDataPage getdPage(int n) throws dbexcpException {
        return (dpageDataPage)cacheManager.getCacheManager().getPage(n, (cacheIPageFactory)new dpageDataPageFactory());
    }

    private sessionManager getSessionManager() {
        return sessionManager.getSessionManager();
    }

    private cacheManager getCacheManager() {
        return cacheManager.getCacheManager();
    }

    static {
        m_cpInterval = dbgaProperties.getPropertiesCacheCheckPointInterval();
    }
}

