/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.net;

import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.dbga.dbgaProperties;
import com.pointbase.net.BindEntry;
import com.pointbase.net.netJDBCConnection;
import com.pointbase.net.netJDBCNewRowSet;
import com.pointbase.net.netJDBCResultSet;
import com.pointbase.net.netJDBCResultSetMetaData;
import com.pointbase.net.netJDBCStatement;
import com.pointbase.net.netLengthedInputStream;
import com.pointbase.net.netLengthedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public class netJDBCPreparedStatement
extends netJDBCStatement
implements PreparedStatement {
    private static final int MAX_STRING_LENGTH_CHARACTERS = 20000;
    private String m_Resource = "com.pointbase.resource.resourceNetJDBCPreparedStatement";
    private int m_responseCount = 0;
    private static int m_bulkBlockSize = dbgaProperties.getPropertyBulkModeSize();
    private boolean m_bulkMode = false;
    private int m_bulkMarkersPerRow = -1;
    private boolean m_bulkForceIt;
    private Vector m_bindBlock = new Vector();
    private netJDBCResultSetMetaData m_rsmd;

    public netJDBCPreparedStatement(netJDBCConnection netJDBCConnection2, DataOutputStream dataOutputStream, DataInputStream dataInputStream, int n) throws SQLException {
        super(netJDBCConnection2, dataOutputStream, dataInputStream, n);
    }

    public netJDBCPreparedStatement(netJDBCConnection netJDBCConnection2, DataOutputStream dataOutputStream, DataInputStream dataInputStream, int n, String string) throws SQLException {
        super(netJDBCConnection2, dataOutputStream, dataInputStream, n);
        this.m_sql = string;
    }

    public ResultSet executeQuery() throws SQLException {
        this.validate();
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.validate();
            try {
                if (this.m_bulkMarkersPerRow <= 0) {
                    this.m_bulkMarkersPerRow = this.m_responseCount;
                }
                if (this.getBulk()) {
                    int n = this.m_responseCount / this.m_bulkMarkersPerRow;
                    if (!this.m_bulkForceIt && n > 0) {
                        this.sendMethodRequest(this.m_cnx, this.m_dos, "executeQuery()", null);
                    }
                    if (this.m_bulkForceIt || n >= m_bulkBlockSize) {
                        int n2 = 0;
                        while (n2 < n) {
                            int n3 = 0;
                            while (n3 < this.m_bulkMarkersPerRow) {
                                this.handlePrimitiveResponse(this.m_dis);
                                --this.m_responseCount;
                                ++n3;
                            }
                            int n4 = this.handleJDBCObjectResponse(this.m_dis);
                            ++n2;
                        }
                    }
                } else {
                    this.flushBindVariables();
                    this.sendMethodRequest(this.m_cnx, this.m_dos, "executeQuery()", null);
                    int n = this.handleJDBCObjectResponse(this.m_dis);
                    if (n != -10) {
                        this.m_result = this.isUnisyncNewCommand() ? new netJDBCNewRowSet(this.m_cnx, this, this.m_dos, this.m_dis, n) : new netJDBCResultSet(this.m_cnx, this, this.m_dos, this.m_dis, n);
                        ResultSet resultSet = this.m_result;
                        Object var7_8 = null;
                        return resultSet;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                throw throwable;
            }
            Object var7_9 = null;
        }
        return null;
    }

    private boolean isUnisyncNewCommand() {
        if (this.m_sql.startsWith("UNISYNC NEWUPDATE")) {
            return true;
        }
        return this.m_sql.startsWith("UNISYNC NEWSNAPSHOT");
    }

    public int executeUpdate() throws SQLException {
        this.validate();
        int n = 0;
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            int n2;
            try {
                this.validate();
                if (this.m_bulkMarkersPerRow <= 0) {
                    this.m_bulkMarkersPerRow = this.m_responseCount;
                }
                if (this.getBulk()) {
                    int n3;
                    int n4 = this.m_responseCount / this.m_bulkMarkersPerRow;
                    if (!this.m_bulkForceIt && n4 > 0) {
                        this.sendMethodRequest(this.m_cnx, this.m_dos, "executeUpdate()", null);
                    }
                    if (this.m_bulkForceIt || n4 >= m_bulkBlockSize) {
                        n3 = 0;
                        while (n3 < n4) {
                            int n5 = 0;
                            while (n5 < this.m_bulkMarkersPerRow) {
                                this.handlePrimitiveResponse(this.m_dis);
                                --this.m_responseCount;
                                ++n5;
                            }
                            n += ((Integer)this.handlePrimitiveResponse(this.m_dis)).intValue();
                            ++n3;
                        }
                    } else {
                        n = 1;
                    }
                    n3 = n;
                    Object var7_7 = null;
                    this.m_cnx.condCommit();
                    return n3;
                }
                this.flushBindVariables();
                this.sendMethodRequest(this.m_cnx, this.m_dos, "executeUpdate()", null);
                n2 = (Integer)this.handlePrimitiveResponse(this.m_dis);
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.m_cnx.condCommit();
                throw throwable;
            }
            Object var7_8 = null;
            this.m_cnx.condCommit();
            return n2;
        }
    }

    public int[] executeBatch() throws SQLException, BatchUpdateException {
        int[] nArray = null;
        this.validate();
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.validate();
            try {
                this.sendMethodRequest(this.m_cnx, this.m_dos, "executeBatch()", null);
                nArray = (int[])this.handlePrimitiveResponse(this.m_dis);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        return nArray;
    }

    public boolean execute() throws SQLException {
        return this.executeQuery() != null;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        this.m_bindBlock.addElement(new BindEntry("setNull( $int, $int )", objectArray));
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), new Boolean(bl)};
        this.m_bindBlock.addElement(new BindEntry("setBoolean( $int, $boolean )", objectArray));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), new Byte(by)};
        this.m_bindBlock.addElement(new BindEntry("setByte( $int, $byte )", objectArray));
    }

    public void setShort(int n, short s) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), new Short(s)};
        this.m_bindBlock.addElement(new BindEntry("setShort( $int, $short )", objectArray));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        this.m_bindBlock.addElement(new BindEntry("setInt( $int, $int )", objectArray));
    }

    public void setLong(int n, long l) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), new Long(l)};
        this.m_bindBlock.addElement(new BindEntry("setLong( $int, $long )", objectArray));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), new Float(f)};
        this.m_bindBlock.addElement(new BindEntry("setFloat( $int, $float )", objectArray));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), new Double(d)};
        this.m_bindBlock.addElement(new BindEntry("setDouble( $int, $double )", objectArray));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), bigDecimal};
        this.m_bindBlock.addElement(new BindEntry("setBigDecimal( $int, java.math.BigDecimal )", objectArray));
    }

    public void setString(int n, String string) throws SQLException {
        this.validate();
        if (string != null && string.length() > 20000) {
            this.setCharacterStream(n, (Reader)new StringReader(string), string.length());
            return;
        }
        Object[] objectArray = new Object[]{new Integer(n), string};
        this.m_bindBlock.addElement(new BindEntry("setString( $int, java.lang.String )", objectArray));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), byArray};
        this.m_bindBlock.addElement(new BindEntry("setBytes( $int, $byte[] )", objectArray));
    }

    public void setDate(int n, Date date) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), date};
        this.m_bindBlock.addElement(new BindEntry("setDate( $int, java.sql.Date )", objectArray));
    }

    public void setTime(int n, Time time) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), time};
        this.m_bindBlock.addElement(new BindEntry("setTime( $int, java.sql.Time )", objectArray));
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), timestamp};
        this.m_bindBlock.addElement(new BindEntry("setTimestamp( $int, java.sql.Timestamp )", objectArray));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validate();
        if (inputStream == null) {
            this.setNull(n, 12);
        } else {
            Object[] objectArray = new Object[]{new Integer(n), new netLengthedInputStream(inputStream, n2), new Integer(n2)};
            this.m_bindBlock.addElement(new BindEntry("setAsciiStream( $int, java.io.InputStream, $int )", objectArray));
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validate();
        if (inputStream == null) {
            this.setNull(n, 12);
        } else {
            Object[] objectArray = new Object[]{new Integer(n), new netLengthedInputStream(inputStream, n2), new Integer(n2)};
            this.m_bindBlock.addElement(new BindEntry("setUnicodeStream( $int, java.io.InputStream, $int )", objectArray));
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validate();
        if (inputStream == null) {
            this.setNull(n, -3);
        } else {
            Object[] objectArray = new Object[]{new Integer(n), new netLengthedInputStream(inputStream, n2), new Integer(n2)};
            this.m_bindBlock.addElement(new BindEntry("setBinaryStream( $int, java.io.InputStream, $int )", objectArray));
        }
    }

    public void clearParameters() throws SQLException {
        this.validate();
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.flushBindVariables();
            this.sendMethodRequest(this.m_cnx, this.m_dos, "clearParameters( )", null);
            this.handlePrimitiveResponse(this.m_dis);
            this.m_bindBlock.removeAllElements();
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), object, new Integer(n2), new Integer(n3)};
        this.m_bindBlock.addElement(new BindEntry("setObject( $int, java.lang.Object, $int, $int )", objectArray));
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), object, new Integer(n2)};
        this.m_bindBlock.addElement(new BindEntry("setObject( $int, java.lang.Object, $int )", objectArray));
    }

    public void setObject(int n, Object object) throws SQLException {
        this.validate();
        Object[] objectArray = new Object[]{new Integer(n), object};
        this.m_bindBlock.addElement(new BindEntry("setObject( $int, java.lang.Object )", objectArray));
    }

    public void close() throws SQLException {
        if (this.getBulk()) {
            this.setBulk(false);
        }
        super.close();
    }

    private void flushBindVariables() throws SQLException {
        this.m_responseCount = 0;
        try {
            try {
                Enumeration enumeration = this.m_bindBlock.elements();
                while (enumeration.hasMoreElements()) {
                    BindEntry bindEntry = (BindEntry)enumeration.nextElement();
                    this.flushBindVariable(bindEntry);
                }
                this.m_bindBlock.removeAllElements();
                this.flushOutput(this.m_dos);
                int n = 0;
                while (n < this.m_responseCount) {
                    this.handlePrimitiveResponse(this.m_dis);
                    ++n;
                }
            }
            catch (IOException iOException) {
                Object var4_6 = null;
                this.m_responseCount = 0;
            }
            Object var4_5 = null;
            this.m_responseCount = 0;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.m_responseCount = 0;
            throw throwable;
        }
    }

    public void flushBindVariable(BindEntry bindEntry) throws IOException, SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequestNoFlush(this.m_cnx, this.m_dos, bindEntry.getMethod(), bindEntry.getArgs());
            ++this.m_responseCount;
        }
    }

    public synchronized void setBulk(boolean bl) throws SQLException {
        if (bl) {
            this.m_bulkForceIt = false;
            this.m_bulkMode = true;
        } else {
            this.m_bulkForceIt = true;
            this.executeQuery();
            this.m_bulkMode = false;
        }
    }

    public boolean getBulk() {
        return this.m_bulkMode;
    }

    public synchronized int getUpdateCount() throws SQLException {
        if (!this.m_bulkMode) {
            return super.getUpdateCount();
        }
        return 1;
    }

    public void setArray(int n, Array array) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(n), blob};
        this.m_bindBlock.addElement(new BindEntry("setBlob( $int, java.sql.Blob )", objectArray));
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.validate();
        if (reader == null) {
            this.setNull(n, 12);
        } else {
            Object[] objectArray = new Object[]{new Integer(n), new netLengthedReader(reader, n2), new Integer(n2)};
            this.m_bindBlock.addElement(new BindEntry("setCharacterStream( $int, java.io.Reader, $int )", objectArray));
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(n), clob};
        this.m_bindBlock.addElement(new BindEntry("setClob( $int, java.sql.Clob )", objectArray));
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(n), date, calendar};
        this.m_bindBlock.addElement(new BindEntry("setDate( $int, java.sql.Date, java.util.Calendar )", objectArray));
    }

    public void setRef(int n, Ref ref) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(n), time, calendar};
        this.m_bindBlock.addElement(new BindEntry("setTime( $int, java.sql.Time, java.util.Calendar )", objectArray));
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(n), timestamp, calendar};
        this.m_bindBlock.addElement(new BindEntry("setTimestamp( $int, java.sql.Timestamp, java.util.Calendar )", objectArray));
    }

    public void addBatch() throws SQLException {
        this.flushBindVariables();
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "addBatch()", null);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public void clearBatch() throws SQLException {
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.sendMethodRequest(this.m_cnx, this.m_dos, "clearBatch()", null);
            this.handlePrimitiveResponse(this.m_dis);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.validate();
        Object object = this.m_cnx.getMonitor();
        synchronized (object) {
            this.validate();
            this.sendMethodRequest(this.m_cnx, this.m_dos, "getMetaData()", null);
            int n = this.handleJDBCObjectResponse(this.m_dis);
            if (n != -10) {
                this.m_rsmd = new netJDBCResultSetMetaData(this.m_cnx, this.m_dos, this.m_dis, n);
            }
            netJDBCResultSetMetaData netJDBCResultSetMetaData2 = this.m_rsmd;
            return netJDBCResultSetMetaData2;
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Object[] copyContents(Vector vector) {
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.functionUnsupported("setURL");
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

