/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.jdbc.jdbcInfoDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;

public class jdbcUniversalDriver
implements Driver,
jdbcInfoDriver {
    public boolean m_bServerStarted = false;
    private Properties m_info;
    private String m_url;
    private boolean m_FirstTime = true;
    private static Driver m_jdbcMicroDriver = null;
    private static Driver m_jdbcDriver = null;
    private static Driver m_netJDBCDriver = null;
    private static Driver m_jdbcEmbeddedDriver = null;
    private static Driver m_Driver;

    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        this.m_url = string;
        this.m_info = properties;
        if (!this.acceptsURL(string)) {
            return null;
        }
        return this.getConnection(string, properties.getProperty("user"), properties.getProperty("password"), this);
    }

    public synchronized boolean acceptsURL(String string) throws SQLException {
        try {
            if (this.m_FirstTime) {
                this.loadDrivers();
            }
            if (m_jdbcEmbeddedDriver != null && m_jdbcEmbeddedDriver.acceptsURL(string)) {
                m_Driver = m_jdbcEmbeddedDriver;
                return true;
            }
            if (m_jdbcDriver != null && m_jdbcDriver.acceptsURL(string)) {
                m_Driver = m_jdbcDriver;
                return true;
            }
            if (m_netJDBCDriver != null && m_netJDBCDriver.acceptsURL(string)) {
                m_Driver = m_netJDBCDriver;
                return true;
            }
            if (m_jdbcMicroDriver != null && m_jdbcMicroDriver.acceptsURL(string)) {
                m_Driver = m_jdbcMicroDriver;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public synchronized DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public synchronized int getMajorVersion() {
        return 4;
    }

    public int getMinorVersion() {
        return 2;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private synchronized Connection getConnection(String string, String string2, String string3, Driver driver) throws SQLException {
        Properties properties = new Properties();
        if (string2 != null) {
            ((Hashtable)properties).put("user", string2);
        }
        if (string3 != null) {
            ((Hashtable)properties).put("password", string3);
        }
        return m_Driver.connect(string, properties);
    }

    public String getURL() {
        return this.m_url;
    }

    public Properties getProperties() {
        return this.m_info;
    }

    private void loadDrivers() {
        if (!this.m_FirstTime) {
            return;
        }
        try {
            if (m_jdbcDriver == null) {
                m_jdbcDriver = (Driver)Class.forName("com.pointbase.jdbc.jdbcDriver").newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (m_netJDBCDriver == null) {
                m_netJDBCDriver = (Driver)Class.forName("com.pointbase.net.netJDBCDriver").newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (m_jdbcEmbeddedDriver == null) {
                m_jdbcEmbeddedDriver = (Driver)Class.forName("com.pointbase.jdbc.jdbcEmbeddedDriver").newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (m_jdbcMicroDriver == null) {
                m_jdbcMicroDriver = (Driver)Class.forName("com.pointbase.me.jdbc.jdbcDriver").newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_FirstTime = false;
    }

    static {
        try {
            DriverManager.registerDriver(new jdbcUniversalDriver());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

