/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.api.apiResultHeader;
import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.jdbc.jdbcDatabaseMetaData;
import com.pointbase.jdbc.jdbcObject;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

public class jdbcResultSetMetaData
extends jdbcObject
implements ResultSetMetaData {
    private apiResultHeader m_header;
    private static Hashtable m_ColumnClassNameMapping = new Hashtable();

    public jdbcResultSetMetaData(apiResultHeader apiResultHeader2) {
        this.m_header = apiResultHeader2;
    }

    public int getColumnCount() throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultSetMetaDataColumnCount();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getColumnAutoIncrement();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        try {
            this.validate();
            return true;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isSearchable(int n) throws SQLException {
        try {
            this.validate();
            return true;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isCurrency(int n) throws SQLException {
        try {
            this.validate();
            return false;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int isNullable(int n) throws SQLException {
        try {
            this.validate();
            int n2 = this.m_header.getResultMetaData(n - 1).getColumnNullable();
            if (n2 == 1) {
                return 1;
            }
            return 0;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isSigned(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getColumnSigned();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getColumnDisplaySize();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public String getColumnLabel(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getColumnLabel();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public String getColumnName(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getColumnName();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public String getSchemaName(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getSchemaName();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getPrecision(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getColumnPrecision();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getScale(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getColumnScale();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public String getTableName(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getTableName();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        try {
            this.validate();
            int n2 = this.m_header.getResultMetaData(n - 1).getColumnType();
            return jdbcDatabaseMetaData.getSQLType(n2);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public String getColumnTypeName(int n) throws SQLException {
        try {
            this.validate();
            return this.m_header.getResultMetaData(n - 1).getColumnTypeName();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isReadOnly(int n) throws SQLException {
        try {
            this.validate();
            return false;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isWritable(int n) throws SQLException {
        try {
            this.validate();
            return true;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this.isWritable(n);
    }

    public String getColumnClassName(int n) throws SQLException {
        try {
            this.validate();
            int n2 = this.m_header.getResultMetaData(n - 1).getColumnType();
            return (String)m_ColumnClassNameMapping.get(new Integer(n2));
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    int columnNumber(String string) throws dbexcpException {
        this.validate();
        return this.m_header.getResultMetaData(string);
    }

    apiResultHeader getHeader() throws dbexcpException {
        this.validate();
        return this.m_header;
    }

    void releaseResources() {
        this.m_header = null;
    }

    private void validate() throws dbexcpException {
        if (this.m_header == null) {
            throw new dbexcpException(86018);
        }
    }

    static {
        m_ColumnClassNameMapping.put(new Integer(1), "java.lang.Character");
        m_ColumnClassNameMapping.put(new Integer(2), "java.lang.Long");
        m_ColumnClassNameMapping.put(new Integer(3), "java.lang.Double");
        m_ColumnClassNameMapping.put(new Integer(4), "java.lang.Integer");
        m_ColumnClassNameMapping.put(new Integer(9), "java.lang.Long");
        m_ColumnClassNameMapping.put(new Integer(5), "java.lang.Short");
        m_ColumnClassNameMapping.put(new Integer(6), "java.lang.Float");
        m_ColumnClassNameMapping.put(new Integer(7), "java.lang.Double");
        m_ColumnClassNameMapping.put(new Integer(8), "java.lang.Double");
        m_ColumnClassNameMapping.put(new Integer(91), "java.sql.Date");
        m_ColumnClassNameMapping.put(new Integer(92), "java.sql.Time");
        m_ColumnClassNameMapping.put(new Integer(93), "java.sql.Timestamp");
        m_ColumnClassNameMapping.put(new Integer(12), "java.lang.Character");
        m_ColumnClassNameMapping.put(new Integer(16), "java.lang.Boolean");
        m_ColumnClassNameMapping.put(new Integer(30), "java.lang.Byte");
        m_ColumnClassNameMapping.put(new Integer(40), "java.lang.Byte");
        m_ColumnClassNameMapping.put(new Integer(121), "java.lang.Byte");
    }
}

