/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.api.apiResultHeader;
import com.pointbase.collxn.collxnVector;
import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.jdbc.jdbcILogReader;
import com.pointbase.jdbc.jdbcILogResultSet;
import com.pointbase.jdbc.jdbcINewRowSet;
import com.pointbase.jdbc.jdbcLogResultSet;
import com.pointbase.jdbc.jdbcResultSet;
import com.pointbase.jdbc.jdbcResultSetMetaData;
import com.pointbase.jdbc.jdbcStatement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class jdbcNewRowSet
extends jdbcResultSet
implements jdbcINewRowSet,
jdbcILogReader {
    private jdbcResultSetMetaData[] m_rsmdArray;
    private collxnVector m_Rows;
    private collxnVector m_UpdatedRows;
    private jdbcStatement m_Stmt;
    private int m_MetaDataCount = 0;
    private int m_RowCount = 0;
    private int m_TotalRows = 0;
    private int m_FetchSize = 200;

    public jdbcNewRowSet() {
    }

    public jdbcNewRowSet(apiResultHeader apiResultHeader2, jdbcStatement jdbcStatement2, int n) throws dbexcpException {
        super(apiResultHeader2, jdbcStatement2, n);
        this.m_Stmt = jdbcStatement2;
        apiResultHeader[] apiResultHeaderArray = this.m_Stmt.fetchMetaDataArray();
        this.m_MetaDataCount = apiResultHeaderArray.length;
        this.m_rsmdArray = new jdbcResultSetMetaData[this.m_MetaDataCount];
        int n2 = 0;
        while (n2 < this.m_MetaDataCount) {
            this.m_rsmdArray[n2] = new jdbcResultSetMetaData(apiResultHeaderArray[n2]);
            ++n2;
        }
    }

    public jdbcILogResultSet getLogResultSet() {
        return new jdbcLogResultSet(this);
    }

    public boolean nextBlock() throws SQLException {
        try {
            this.m_Rows = new collxnVector(this.m_FetchSize);
            this.m_UpdatedRows = new collxnVector(this.m_FetchSize);
            boolean bl = this.m_Stmt.fetchBlock(this.m_Rows, this.m_UpdatedRows);
            this.m_TotalRows = this.m_Rows.size();
            return bl;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getMetaDataCount() {
        return this.m_MetaDataCount;
    }

    public ResultSetMetaData[] getMetaDataArray() {
        return this.m_rsmdArray;
    }

    public int getFetchSize() {
        return this.m_FetchSize;
    }

    public void setFetchSize(int n) {
        this.m_FetchSize = n;
    }

    public int getTotalRows() {
        return this.m_TotalRows;
    }

    public collxnVector getRows() {
        return this.m_Rows;
    }

    public collxnVector getUpdatedRows() {
        return this.m_UpdatedRows;
    }

    public ResultSetMetaData getMetaDataAt(int n) {
        if (n < 0 || n > this.m_rsmdArray.length) {
            return null;
        }
        return this.m_rsmdArray[n];
    }

    public jdbcINewRowSet readRowSetObject(ObjectInputStream objectInputStream) throws SQLException, IOException, ClassNotFoundException {
        int n;
        this.m_TotalRows = objectInputStream.readInt();
        this.m_Rows = new collxnVector(this.m_TotalRows);
        this.m_UpdatedRows = new collxnVector(this.m_TotalRows);
        int n2 = 0;
        while (n2 < this.m_TotalRows) {
            n = objectInputStream.readInt();
            collxnVector collxnVector2 = new collxnVector(n);
            this.readColumnValues(objectInputStream, collxnVector2);
            this.m_Rows.addElement(collxnVector2);
            ++n2;
        }
        n = 0;
        while (n < this.m_TotalRows) {
            boolean bl = objectInputStream.readBoolean();
            if (bl) {
                this.m_UpdatedRows.addElement(null);
            } else {
                int n3 = objectInputStream.readInt();
                collxnVector collxnVector3 = new collxnVector(n3);
                this.readColumnValues(objectInputStream, collxnVector3);
                this.m_UpdatedRows.addElement(collxnVector3);
            }
            ++n;
        }
        return this;
    }

    private void readColumnValues(ObjectInputStream objectInputStream, collxnVector collxnVector2) throws SQLException, IOException, ClassNotFoundException {
        int n = collxnVector2.capacity();
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectInputStream.readInt();
            switch (n3) {
                case -10: {
                    collxnVector2.addElement(null);
                    break;
                }
                case 1: {
                    collxnVector2.addElement(objectInputStream.readUTF());
                    break;
                }
                case 3: {
                    int n4 = objectInputStream.readInt();
                    collxnVector2.addElement(new Integer(n4));
                    break;
                }
                case 4: {
                    collxnVector2.addElement(new Boolean(objectInputStream.readBoolean()));
                    break;
                }
                case 7: {
                    String string = objectInputStream.readUTF();
                    collxnVector2.addElement(Timestamp.valueOf(string));
                    break;
                }
                case 8: {
                    long l = objectInputStream.readLong();
                    collxnVector2.addElement(new Date(l));
                    break;
                }
                case 9: {
                    long l = objectInputStream.readLong();
                    collxnVector2.addElement(new Time(l));
                    break;
                }
                case 10: {
                    collxnVector2.addElement(new Double(objectInputStream.readDouble()));
                    break;
                }
                case 11: {
                    collxnVector2.addElement(new Float(objectInputStream.readFloat()));
                    break;
                }
                case 12: {
                    collxnVector2.addElement(new BigDecimal(objectInputStream.readUTF()));
                    break;
                }
                case 13: {
                    collxnVector2.addElement(new Long(objectInputStream.readLong()));
                    break;
                }
                case 14: {
                    collxnVector2.addElement(new Short(objectInputStream.readShort()));
                    break;
                }
                case 15: {
                    collxnVector2.addElement(new Byte(objectInputStream.readByte()));
                    break;
                }
                case 5: {
                    int n4 = objectInputStream.readInt();
                    byte[] byArray = new byte[n4];
                    objectInputStream.readFully(byArray);
                    collxnVector2.addElement(byArray);
                    break;
                }
                default: {
                    throw new IOException("jdbcNewRowSet.readObject(), Unrecognized object type: " + n3);
                }
            }
            ++n2;
        }
    }

    public void writeRowSetObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.m_TotalRows);
        int n = 0;
        while (n < this.m_TotalRows) {
            collxnVector collxnVector2 = (collxnVector)this.m_Rows.elementAt(n);
            this.writeColumnValues(objectOutputStream, collxnVector2);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_TotalRows) {
            collxnVector collxnVector3 = (collxnVector)this.m_UpdatedRows.elementAt(n2);
            if (collxnVector3 == null) {
                objectOutputStream.writeBoolean(true);
            } else {
                objectOutputStream.writeBoolean(false);
                this.writeColumnValues(objectOutputStream, collxnVector3);
            }
            ++n2;
        }
    }

    private void writeColumnValues(ObjectOutputStream objectOutputStream, collxnVector collxnVector2) throws IOException {
        int n = collxnVector2.size();
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            Object object = collxnVector2.elementAt(n2);
            if (object == null) {
                objectOutputStream.writeInt(-10);
            } else if (object instanceof String) {
                objectOutputStream.writeInt(1);
                objectOutputStream.writeUTF((String)object);
            } else if (object instanceof Integer) {
                objectOutputStream.writeInt(3);
                objectOutputStream.writeInt((Integer)object);
            } else if (object instanceof Boolean) {
                objectOutputStream.writeInt(4);
                objectOutputStream.writeBoolean((Boolean)object);
            } else if (object instanceof Double) {
                objectOutputStream.writeInt(10);
                objectOutputStream.writeDouble((Double)object);
            } else if (object instanceof Float) {
                objectOutputStream.writeInt(11);
                objectOutputStream.writeFloat(((Float)object).floatValue());
            } else if (object instanceof BigDecimal) {
                objectOutputStream.writeInt(12);
                objectOutputStream.writeUTF(((BigDecimal)object).toString());
            } else if (object instanceof Long) {
                objectOutputStream.writeInt(13);
                objectOutputStream.writeLong((Long)object);
            } else if (object instanceof Short) {
                objectOutputStream.writeInt(14);
                objectOutputStream.writeShort(((Short)object).shortValue());
            } else if (object instanceof Byte) {
                objectOutputStream.writeInt(15);
                objectOutputStream.writeByte(((Byte)object).byteValue());
            } else if (object instanceof Timestamp) {
                objectOutputStream.writeInt(7);
                objectOutputStream.writeUTF(((Timestamp)object).toString());
            } else if (object instanceof Date) {
                objectOutputStream.writeInt(8);
                objectOutputStream.writeLong(((Date)object).getTime());
            } else if (object instanceof Time) {
                objectOutputStream.writeInt(9);
                objectOutputStream.writeLong(((Time)object).getTime());
            } else if (object instanceof byte[]) {
                objectOutputStream.writeInt(5);
                int n3 = ((byte[])object).length;
                objectOutputStream.writeInt(n3);
                objectOutputStream.write((byte[])object);
            } else {
                throw new IOException("jdbcNewRowSet.writeObject(), Unrecognized object type: " + object.getClass().getName());
            }
            ++n2;
        }
        objectOutputStream.flush();
    }
}

