/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.bufferedengine.buffer;

import com.octo.captcha.Captcha;
import com.octo.captcha.engine.bufferedengine.buffer.CaptchaBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.sql.DataSource;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseCaptchaBuffer
implements CaptchaBuffer {
    private static final Log log = LogFactory.getLog((String)DatabaseCaptchaBuffer.class.getName());
    private DataSource datasource;
    private String table = "JCAPTCHA_T";
    private String timeMillisColumn = "timemillis";
    private String hashCodeColumn = "hashCode";
    private String localeColumn = "locale";
    private String captchaColumn = "captcha";
    private static final String DB_ERROR = "SQL Error :";

    public DatabaseCaptchaBuffer(DataSource datasource) {
        log.info((Object)"Initializing Buffer");
        this.datasource = datasource;
        log.info((Object)("Buffer size : " + this.size()));
        log.info((Object)"Buffer initialized");
    }

    public DatabaseCaptchaBuffer(DataSource datasource, String table) {
        log.info((Object)"Initializing Buffer");
        this.datasource = datasource;
        this.table = table;
        log.info((Object)("Buffer size : " + this.size()));
        log.info((Object)"Buffer initialized");
    }

    public DatabaseCaptchaBuffer(DataSource datasource, String table, String timeMillisColumn, String hashCodeColumn, String captchaColumn, String localeColumn) {
        log.info((Object)"Initializing Buffer");
        this.datasource = datasource;
        this.table = table;
        this.timeMillisColumn = timeMillisColumn;
        this.hashCodeColumn = hashCodeColumn;
        this.captchaColumn = captchaColumn;
        this.localeColumn = localeColumn;
        log.info((Object)("Buffer size : " + this.size()));
        log.info((Object)"Buffer initialized");
    }

    public Captcha removeCaptcha() throws NoSuchElementException {
        return this.removeCaptcha(Locale.getDefault());
    }

    public Captcha removeCaptcha(Locale locale) throws NoSuchElementException {
        Collection col = this.removeCaptcha(1, locale);
        if (col != null && col.size() > 0) {
            return (Captcha)col.iterator().next();
        }
        throw new NoSuchElementException("no captcha in this buffer for locale " + locale);
    }

    public Collection removeCaptcha(int number) {
        return this.removeCaptcha(number, Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection removeCaptcha(int number, Locale locale) {
        Connection con = null;
        Statement ps = null;
        PreparedStatement psdel = null;
        ResultSet rs = null;
        UnboundedFifoBuffer collection = new UnboundedFifoBuffer();
        UnboundedFifoBuffer temp = new UnboundedFifoBuffer();
        if (number < 1) {
            return collection;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("try to remove " + number + " captchas"));
            }
            con = this.datasource.getConnection();
            ps = con.prepareStatement("select *  from " + this.table + " where " + this.localeColumn + " = ? order by " + this.timeMillisColumn);
            psdel = con.prepareStatement("delete from " + this.table + " where " + this.timeMillisColumn + "= ? and " + this.hashCodeColumn + "= ? ");
            ps.setString(1, locale.toString());
            ps.setMaxRows(number);
            rs = ps.executeQuery();
            int i = 0;
            while (rs.next() && i < number) {
                try {
                    ++i;
                    InputStream in = rs.getBinaryStream(this.captchaColumn);
                    ObjectInputStream objstr = new ObjectInputStream(in);
                    Object captcha = objstr.readObject();
                    temp.add(captcha);
                    long time = rs.getLong(this.timeMillisColumn);
                    long hash = rs.getLong(this.hashCodeColumn);
                    psdel.setLong(1, time);
                    psdel.setLong(2, hash);
                    psdel.addBatch();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("remove captcha added to batch : " + time + ";" + hash));
                }
                catch (IOException e) {
                    log.error((Object)"error during captcha deserialization, check your class versions. removing row from database", (Throwable)e);
                    psdel.execute();
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Serialized captcha class in database is not in your classpath!", (Throwable)e);
                }
            }
            psdel.executeBatch();
            log.debug((Object)"batch executed");
            rs.close();
            con.commit();
            log.debug((Object)"batch commited");
            collection.addAll(temp);
        }
        catch (SQLException e) {
            log.error((Object)DB_ERROR, (Throwable)e);
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return collection;
    }

    public void putCaptcha(Captcha captcha) {
        this.putCaptcha(captcha, Locale.getDefault());
    }

    public void putCaptcha(Captcha captcha, Locale locale) {
        if (captcha != null) {
            HashSet<Captcha> set = new HashSet<Captcha>();
            set.add(captcha);
            this.putAllCaptcha(set, locale);
        }
    }

    public void putAllCaptcha(Collection captchas) {
        this.putAllCaptcha(captchas, Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAllCaptcha(Collection captchas, Locale locale) {
        Connection con = null;
        Statement ps = null;
        if (captchas != null && captchas.size() > 0) {
            Iterator captIt = captchas.iterator();
            if (log.isDebugEnabled()) {
                log.debug((Object)("try to insert " + captchas.size() + " captchas"));
            }
            try {
                con = this.datasource.getConnection();
                con.setAutoCommit(false);
                ps = con.prepareStatement("insert into " + this.table + "(" + this.timeMillisColumn + "," + this.hashCodeColumn + "," + this.localeColumn + "," + this.captchaColumn + ") values (?,?,?,?)");
                while (captIt.hasNext()) {
                    Captcha captcha = (Captcha)captIt.next();
                    try {
                        long currenttime = System.currentTimeMillis();
                        long hash = captcha.hashCode();
                        ps.setLong(1, currenttime);
                        ps.setLong(2, hash);
                        ps.setString(3, locale.toString());
                        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
                        ObjectOutputStream objstr = new ObjectOutputStream(outstr);
                        objstr.writeObject(captcha);
                        objstr.close();
                        ByteArrayInputStream inpstream = new ByteArrayInputStream(outstr.toByteArray());
                        ps.setBinaryStream(4, inpstream, outstr.size());
                        ps.addBatch();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("insert captcha added to batch : " + currenttime + ";" + hash));
                    }
                    catch (IOException e) {
                        log.warn((Object)"error during captcha serialization, check your class versions. removing row from database", (Throwable)e);
                    }
                }
                ps.executeBatch();
                log.debug((Object)"batch executed");
                con.commit();
                log.debug((Object)"batch commited");
            }
            catch (SQLException e) {
                log.error((Object)DB_ERROR, (Throwable)e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {}
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        int size = 0;
        try {
            con = this.datasource.getConnection();
            ps = con.prepareStatement("select count(*) from " + this.table);
            rs = ps.executeQuery();
            if (rs.next()) {
                size = rs.getInt(1);
            }
            rs.close();
            con.commit();
        }
        catch (SQLException e) {
            log.error((Object)DB_ERROR, (Throwable)e);
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(Locale locale) {
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        int size = 0;
        try {
            con = this.datasource.getConnection();
            ps = con.prepareStatement("select count(*) from " + this.table + " where " + this.localeColumn + "=?");
            ps.setString(1, locale.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                size = rs.getInt(1);
            }
            rs.close();
            con.commit();
        }
        catch (SQLException e) {
            log.error((Object)DB_ERROR, (Throwable)e);
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return size;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            con = this.datasource.getConnection();
            ps = con.prepareStatement("delete from " + this.table);
            ps.execute();
            con.commit();
        }
        catch (SQLException e) {
            log.error((Object)DB_ERROR, (Throwable)e);
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getLocales() {
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        HashSet<String> set = new HashSet<String>();
        try {
            con = this.datasource.getConnection();
            ps = con.prepareStatement("select distinct " + this.localeColumn + " from " + this.table);
            rs = ps.executeQuery();
            while (rs.next()) {
                set.add(rs.getString(1));
            }
            rs.close();
            con.commit();
        }
        catch (SQLException e) {
            log.error((Object)DB_ERROR, (Throwable)e);
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return set;
    }
}

