/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.wordtoimage;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.wordtoimage.WordToImage;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedString;

public abstract class AbstractWordToImage
implements WordToImage {
    public BufferedImage getImage(String word) throws CaptchaException {
        int wordLength = this.checkWordLength(word);
        AttributedString attributedWord = this.getAttributedString(word, wordLength);
        BufferedImage background = this.getBackround();
        return this.pasteText(background, attributedWord);
    }

    AttributedString getAttributedString(String word, int wordLength) {
        AttributedString attributedWord = new AttributedString(word);
        for (int i = 0; i < wordLength; ++i) {
            Font font = this.getFont();
            attributedWord.addAttribute(TextAttribute.FONT, font, i, i + 1);
        }
        return attributedWord;
    }

    int checkWordLength(String word) throws CaptchaException {
        if (word == null) {
            throw new CaptchaException("null word");
        }
        int wordLength = word.length();
        if (wordLength > this.getMaxAcceptedWordLength() || wordLength < this.getMinAcceptedWordLength()) {
            throw new CaptchaException("invalid length word");
        }
        return wordLength;
    }

    abstract Font getFont();

    abstract BufferedImage getBackround();

    abstract BufferedImage pasteText(BufferedImage var1, AttributedString var2) throws CaptchaException;
}

