/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.SecurityHandler;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;

public class WebAppGeneratorDeploymentAspect
extends DeploymentAspect {
    private SecurityHandler securityHandlerEJB21;
    private SecurityHandler securityHandlerEJB3;

    public void setSecurityHandlerEJB21(SecurityHandler handler) {
        this.securityHandlerEJB21 = handler;
    }

    public void setSecurityHandlerEJB3(SecurityHandler handler) {
        this.securityHandlerEJB3 = handler;
    }

    public void create(Deployment dep) {
        String typeStr = dep.getType().toString();
        if (typeStr.endsWith("EJB21")) {
            URL webAppURL = this.generatWebDeployment((ArchiveDeployment)dep, this.securityHandlerEJB21);
            dep.setProperty("org.jboss.ws.webapp.url", (Object)webAppURL);
        } else if (typeStr.endsWith("EJB3")) {
            URL webAppURL = this.generatWebDeployment((ArchiveDeployment)dep, this.securityHandlerEJB3);
            dep.setProperty("org.jboss.ws.webapp.url", (Object)webAppURL);
        } else {
            URL webAppURL = this.generatWebDeployment((ArchiveDeployment)dep, null);
            dep.setProperty("org.jboss.ws.webapp.url", (Object)webAppURL);
        }
    }

    private URL generatWebDeployment(ArchiveDeployment dep, SecurityHandler securityHandler) {
        Document webDoc = this.createWebAppDescriptor((Deployment)dep, securityHandler);
        Document jbossDoc = this.createJBossWebAppDescriptor((Deployment)dep, securityHandler);
        File tmpWar = null;
        try {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            ServerConfig config = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
            File tmpdir = new File(config.getServerTempDir().getCanonicalPath() + "/deploy");
            String deploymentName = dep.getCanonicalName().replace('/', '-');
            tmpWar = File.createTempFile(deploymentName, ".war", tmpdir);
            tmpWar.delete();
            File webInf = new File(tmpWar, "WEB-INF");
            webInf.mkdirs();
            File webXml = new File(webInf, "web.xml");
            FileWriter fw = new FileWriter(webXml);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)fw, format);
            writer.write(webDoc);
            writer.close();
            File jbossWebXml = new File(webInf, "jboss-web.xml");
            fw = new FileWriter(jbossWebXml);
            writer = new XMLWriter((Writer)fw, format);
            writer.write(jbossDoc);
            writer.close();
            return tmpWar.toURL();
        }
        catch (IOException e) {
            throw new WSFDeploymentException("Failed to create webservice.war", (Throwable)e);
        }
    }

    private Document createWebAppDescriptor(Deployment dep, SecurityHandler securityHandler) {
        Document document = DocumentHelper.createDocument();
        Element webApp = document.addElement("web-app");
        for (Endpoint ep : dep.getService().getEndpoints()) {
            Element servlet = webApp.addElement("servlet");
            servlet.addElement("servlet-name").addText(ep.getShortName());
            servlet.addElement("servlet-class").addText(ep.getTargetBeanName());
        }
        ArrayList urlPatters = new ArrayList();
        for (Endpoint ep : dep.getService().getEndpoints()) {
            Element servletMapping = webApp.addElement("servlet-mapping");
            servletMapping.addElement("servlet-name").addText(ep.getShortName());
            servletMapping.addElement("url-pattern").addText(ep.getURLPattern());
        }
        String authMethod = null;
        for (Endpoint ep : dep.getService().getEndpoints()) {
            EJBMetaData bmd;
            EJBSecurityMetaData smd;
            EJBArchiveMetaData appMetaData;
            String ejbName = ep.getShortName();
            Boolean secureWSDLAccess = null;
            String transportGuarantee = null;
            String beanAuthMethod = null;
            WebContext anWebContext = ep.getTargetBeanClass().getAnnotation(WebContext.class);
            if (anWebContext != null) {
                if (anWebContext.authMethod().length() > 0) {
                    beanAuthMethod = anWebContext.authMethod();
                }
                if (anWebContext.transportGuarantee().length() > 0) {
                    transportGuarantee = anWebContext.transportGuarantee();
                }
                if (anWebContext.secureWSDLAccess()) {
                    secureWSDLAccess = anWebContext.secureWSDLAccess();
                }
            }
            if ((appMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class)) != null && appMetaData.getBeanByEjbName(ejbName) != null && (smd = (bmd = appMetaData.getBeanByEjbName(ejbName)).getSecurityMetaData()) != null) {
                beanAuthMethod = smd.getAuthMethod();
                transportGuarantee = smd.getTransportGuarantee();
                secureWSDLAccess = smd.getSecureWSDLAccess();
            }
            if (beanAuthMethod == null && transportGuarantee == null) continue;
            Element securityConstraint = webApp.addElement("security-constraint");
            Element wrc = securityConstraint.addElement("web-resource-collection");
            wrc.addElement("web-resource-name").addText(ejbName);
            wrc.addElement("url-pattern").addText(ep.getURLPattern());
            if (Boolean.TRUE.equals(secureWSDLAccess)) {
                wrc.addElement("http-method").addText("GET");
            }
            wrc.addElement("http-method").addText("POST");
            if (beanAuthMethod != null) {
                if (authMethod == null) {
                    authMethod = beanAuthMethod;
                }
                Element authConstraint = securityConstraint.addElement("auth-constraint").addElement("role-name").addText("*");
            }
            if (transportGuarantee == null) continue;
            Element userData = securityConstraint.addElement("user-data-constraint");
            userData.addElement("transport-guarantee").addText(transportGuarantee);
        }
        if (authMethod != null && securityHandler != null) {
            Element loginConfig = webApp.addElement("login-config");
            loginConfig.addElement("auth-method").addText(authMethod);
            loginConfig.addElement("realm-name").addText("EJBServiceEndpointServlet Realm");
            securityHandler.addSecurityRoles(webApp, dep);
        }
        return document;
    }

    private Document createJBossWebAppDescriptor(Deployment dep, SecurityHandler securityHandler) {
        String contextRoot;
        Document document = DocumentHelper.createDocument();
        Element jbossWeb = document.addElement("jboss-web");
        if (securityHandler != null) {
            securityHandler.addSecurityDomain(jbossWeb, dep);
        }
        if ((contextRoot = dep.getService().getContextRoot()) == null) {
            throw new WSFDeploymentException("Cannot obtain context root");
        }
        jbossWeb.addElement("context-root").addText(contextRoot);
        String[] virtualHosts = dep.getService().getVirtualHosts();
        if (virtualHosts != null) {
            for (String currentVirtualHost : virtualHosts) {
                jbossWeb.addElement("virtual-host").addText(currentVirtualHost);
            }
        }
        return document;
    }
}

