/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.selector;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class SelectorTest
extends PTPTestCase {
    public void testEmptyStringAsSelector() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "");
            this.receiverConnection.start();
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testEmptyStringAsSelector");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertTrue((String)"No message was received", (msg != null ? 1 : 0) != 0);
            SelectorTest.assertEquals((String)"testEmptyStringAsSelector", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testStringLiterals() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "string = 'literal''s'");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setStringProperty("string", "literal");
            dummyMessage.setText("testStringLiterals:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setStringProperty("string", "literal's");
            message.setText("testStringLiterals:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertTrue((String)"No message was received", (msg != null ? 1 : 0) != 0);
            SelectorTest.assertEquals((String)"testStringLiterals:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSDeliveryModeInSelector() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "JMSDeliveryMode = 'PERSISTENT'");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setText("testJMSDeliveryModeInSelector:1");
            this.sender.send((Message)dummyMessage, 1, this.sender.getPriority(), this.sender.getTimeToLive());
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testJMSDeliveryModeInSelector:2");
            this.sender.send((Message)message, 2, this.sender.getPriority(), this.sender.getTimeToLive());
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertTrue((String)"No message was received", (msg != null ? 1 : 0) != 0);
            SelectorTest.assertEquals((int)2, (int)msg.getJMSDeliveryMode());
            SelectorTest.assertEquals((String)"testJMSDeliveryModeInSelector:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testIdentifierConversion() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "NumberOfOrders > 1");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setStringProperty("NumberOfOrders", "2");
            dummyMessage.setText("testIdentifierConversion:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setIntProperty("NumberOfOrders", 2);
            message.setText("testIdentifierConversion:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertEquals((String)"testIdentifierConversion:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testSelectorExampleFromSpecs() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "JMSType = 'car' AND color = 'blue' AND weight > 2500");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setJMSType("car");
            dummyMessage.setStringProperty("color", "red");
            dummyMessage.setLongProperty("weight", 3000L);
            dummyMessage.setText("testSelectorExampleFromSpecs:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setJMSType("car");
            message.setStringProperty("color", "blue");
            message.setLongProperty("weight", 3000L);
            message.setText("testSelectorExampleFromSpecs:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertEquals((String)"testSelectorExampleFromSpecs:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGreaterThan() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "weight > 2500");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setLongProperty("weight", 1000L);
            dummyMessage.setText("testGreaterThan:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setLongProperty("weight", 3000L);
            message.setText("testGreaterThan:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertEquals((String)"testGreaterThan:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testEquals() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "weight = 2500");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setLongProperty("weight", 1000L);
            dummyMessage.setText("testEquals:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setLongProperty("weight", 2500L);
            message.setText("testEquals:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertEquals((String)"testEquals:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testNotEquals() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "weight <> 2500");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setLongProperty("weight", 2500L);
            dummyMessage.setText("testEquals:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setLongProperty("weight", 1000L);
            message.setText("testEquals:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertEquals((String)"testEquals:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBetween() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "age BETWEEN 15 and 19");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setIntProperty("age", 20);
            dummyMessage.setText("testBetween:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setIntProperty("age", 17);
            message.setText("testBetween:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
            SelectorTest.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testBetween"));
            SelectorTest.assertEquals((String)"testBetween:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testIn() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "Country IN ('UK', 'US', 'France')");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setStringProperty("Country", "Peru");
            dummyMessage.setText("testIn:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setStringProperty("Country", "UK");
            message.setText("testIn:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
            SelectorTest.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testIn"));
            SelectorTest.assertEquals((String)"testIn:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLikeEscape() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "underscored LIKE '\\_%' ESCAPE '\\'");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setStringProperty("underscored", "bar");
            dummyMessage.setText("testLikeEscape:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setStringProperty("underscored", "_foo");
            message.setText("testLikeEscape:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
            SelectorTest.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testLikeEscape"));
            SelectorTest.assertEquals((String)"testLikeEscape:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLike_2() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "word LIKE 'l_se'");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setStringProperty("word", "loose");
            dummyMessage.setText("testLike_2:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setStringProperty("word", "lose");
            message.setText("testLike_2:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
            SelectorTest.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testLike_2"));
            SelectorTest.assertEquals((String)"testLike_2:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLike_1() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "phone LIKE '12%3'");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setStringProperty("phone", "1234");
            dummyMessage.setText("testLike_1:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setStringProperty("phone", "12993");
            message.setText("testLike_1:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
            SelectorTest.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testLike_1"));
            SelectorTest.assertEquals((String)"testLike_1:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testNull() {
        try {
            this.receiverConnection.stop();
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "prop_name IS NULL");
            this.receiverConnection.start();
            TextMessage dummyMessage = this.senderSession.createTextMessage();
            dummyMessage.setStringProperty("prop_name", "not null");
            dummyMessage.setText("testNull:1");
            this.sender.send((Message)dummyMessage);
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testNull:2");
            this.sender.send((Message)message);
            TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SelectorTest.assertTrue((msg != null ? 1 : 0) != 0);
            SelectorTest.assertEquals((String)"testNull:2", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(SelectorTest.class);
    }

    public SelectorTest(String name) {
        super(name);
    }
}

