/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.StreamCorruptedException;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import org.jboss.mx.util.Serialization;

public class ModelMBeanAttributeInfo
extends MBeanAttributeInfo
implements DescriptorAccess,
Cloneable {
    private Descriptor descriptor = null;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;

    public ModelMBeanAttributeInfo(String name, String description, Method getter, Method setter) throws IntrospectionException {
        super(name, description, getter, setter);
        this.setDescriptor(this.createDefaultDescriptor());
    }

    public ModelMBeanAttributeInfo(String name, String description, Method getter, Method setter, Descriptor descriptor) throws IntrospectionException {
        super(name, description, getter, setter);
        this.setDescriptor(descriptor);
    }

    public ModelMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, type, description, isReadable, isWritable, isIs);
        this.setDescriptor(this.createDefaultDescriptor());
    }

    public ModelMBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs, Descriptor descriptor) {
        super(name, type, description, isReadable, isWritable, isIs);
        this.setDescriptor(descriptor);
    }

    public ModelMBeanAttributeInfo(ModelMBeanAttributeInfo info) {
        this(info.getName(), info.getType(), info.getDescription(), info.isReadable(), info.isWritable(), info.isIs(), info.getDescriptor());
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor.clone();
    }

    public void setDescriptor(Descriptor inDescriptor) {
        if (inDescriptor == null) {
            inDescriptor = this.createDefaultDescriptor();
        }
        if (inDescriptor.isValid() && this.isAttributeDescriptorValid(inDescriptor)) {
            this.descriptor = inDescriptor;
        }
    }

    private boolean isAttributeDescriptorValid(Descriptor inDescriptor) {
        String name = (String)inDescriptor.getFieldValue("name");
        if (!name.equals(this.getName())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid name, expected '" + this.getName() + "' but got: " + name));
        }
        String descriptorType = (String)inDescriptor.getFieldValue("descriptorType");
        if (!"attribute".equalsIgnoreCase(descriptorType)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptorType, for attribute '" + name + "' expected 'attribute' but got: " + descriptorType));
        }
        return true;
    }

    public synchronized Object clone() {
        ModelMBeanAttributeInfo clone = (ModelMBeanAttributeInfo)super.clone();
        clone.descriptor = (Descriptor)this.descriptor.clone();
        return clone;
    }

    public String toString() {
        return "ModelMBeanAttributeInfo[Name=" + this.getName() + ",Type=" + this.getType() + ",Access=" + (this.isReadable() && this.isWritable() ? "RW" : (this.isReadable() ? "RO" : "WO")) + ",Descriptor(" + this.getDescriptor() + ")]";
    }

    private Descriptor createDefaultDescriptor() {
        DescriptorSupport descr = new DescriptorSupport();
        descr.setField("name", super.getName());
        descr.setField("descriptorType", "attribute");
        descr.setField("displayName", super.getName());
        return descr;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        this.descriptor = (Descriptor)getField.get("attrDescriptor", null);
        if (this.descriptor == null) {
            throw new StreamCorruptedException("Null descriptor?");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        putField.put("attrDescriptor", this.descriptor);
        oos.writeFields();
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = 7098036920755973145L;
                break;
            }
            default: {
                serialVersionUID = 6181543027787327345L;
            }
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("attrDescriptor", Descriptor.class)};
    }
}

