/*
 * Decompiled with CFR 0.152.
 */
package webwork.action;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import webwork.action.ActionContext;
import webwork.action.CoreActionContext;
import webwork.action.SingleValueMap;
import webwork.action.factory.ApplicationMap;
import webwork.action.factory.ParameterMap;
import webwork.action.factory.SessionMap;
import webwork.multipart.MultiPartRequestWrapper;
import webwork.util.ServletValueStack;

public class ServletActionContext {
    public static final String REQUEST = "webwork.action.ServletContext.request";
    public static final String RESPONSE = "webwork.action.ServletContext.response";
    public static final String SERVLET_CONTEXT = "webwork.action.ServletContext.servletContext";

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)ActionContext.getContext().get(REQUEST);
    }

    public static MultiPartRequestWrapper getMultiPartRequest() {
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get(REQUEST);
        if (request instanceof MultiPartRequestWrapper) {
            return (MultiPartRequestWrapper)request;
        }
        return null;
    }

    public static void setRequest(HttpServletRequest request) {
        ActionContext.getContext().put(REQUEST, request);
    }

    public static HttpServletResponse getResponse() {
        return (HttpServletResponse)ActionContext.getContext().get(RESPONSE);
    }

    public static void setResponse(HttpServletResponse response) {
        ActionContext.getContext().put(RESPONSE, response);
    }

    public static ServletContext getServletContext() {
        return (ServletContext)ActionContext.getContext().get(SERVLET_CONTEXT);
    }

    public static void setServletContext(ServletContext context) {
        ActionContext.getContext().put(SERVLET_CONTEXT, context);
    }

    public static void setContext(HttpServletRequest request, HttpServletResponse response, ServletContext context, String actionName) {
        ActionContext.setName(actionName);
        ActionContext.setLocale(request.getLocale());
        ActionContext.setSession(new SessionMap(request.getSession()));
        ActionContext.setApplication(new ApplicationMap(context));
        ParameterMap parameters = new ParameterMap((ServletRequest)request);
        ActionContext.setParameters(parameters);
        ActionContext.setSingleValueParameters(new SingleValueMap(parameters));
        ActionContext.setPrincipal(request.getUserPrincipal());
        ServletActionContext.setRequest(request);
        ServletActionContext.setResponse(response);
        ServletActionContext.setServletContext(context);
        CoreActionContext.setValueStack(ServletValueStack.getStack((ServletRequest)request));
    }
}

