/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jboss.remoting.samples.chat.client.ChatInfo;
import org.jboss.remoting.samples.chat.client.ChatMember;
import org.jboss.remoting.samples.chat.client.Closeable;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.client.DummyInfoConnectionStrategy;
import org.jboss.remoting.samples.chat.client.InfoConnectionStrategy;
import org.jboss.remoting.samples.chat.client.InfoFrame_closeButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.InfoFrame_joinButton_actionAdapter;
import org.jboss.remoting.samples.chat.exceptions.ConnectionException;
import org.jboss.remoting.samples.chat.exceptions.InfoConnectionException;

public class InfoFrame
extends CloseableFrame
implements Closeable {
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JTextField jTextField1 = new JTextField();
    JTextField jTextField2 = new JTextField();
    JTextField numberOfMessages = new JTextField();
    JButton joinButton = new JButton();
    JButton closeButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    InfoConnectionStrategy ics;
    ChatInfo chatInfo;

    public InfoFrame(InfoConnectionStrategy ics, ChatInfo chatInfo, Closeable parent) {
        super(parent);
        this.ics = ics;
        this.chatInfo = chatInfo;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jLabel1.setFont(new Font("SansSerif", 1, 12));
        this.jLabel1.setText("Description:");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.jLabel2.setFont(new Font("SansSerif", 1, 12));
        this.jLabel2.setText("Current members:");
        this.jLabel3.setFont(new Font("SansSerif", 1, 12));
        this.jLabel3.setAlignmentX(0.0f);
        this.jLabel3.setText("Number of messages:");
        this.jTextField1.setEditable(false);
        this.jTextField1.setText(this.chatInfo.get_description());
        this.jTextField2.setEditable(false);
        this.jTextField2.setText(Integer.toString(this.chatInfo.get_currentMembers()));
        this.numberOfMessages.setEditable(false);
        this.numberOfMessages.setText(Integer.toString(this.chatInfo.get_size()));
        this.joinButton.setFont(new Font("SansSerif", 1, 12));
        this.joinButton.setText("Join");
        this.joinButton.addActionListener(new InfoFrame_joinButton_actionAdapter(this));
        this.closeButton.setFont(new Font("SansSerif", 1, 12));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new InfoFrame_closeButton_actionAdapter(this));
        this.getContentPane().setBackground(SystemColor.control);
        this.setLocale(Locale.getDefault());
        this.setTitle("Chat room information");
        this.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 43, 0, 0), 11, 2));
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(44, 43, 10, 40), 7, 2));
        this.getContentPane().add((Component)this.jLabel3, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(21, 43, 0, 0), 15, 2));
        this.getContentPane().add((Component)this.jTextField1, new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(44, 0, 0, 38), 304, 7));
        this.getContentPane().add((Component)this.jTextField2, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(9, 0, 0, 0), 51, 0));
        this.getContentPane().add((Component)this.numberOfMessages, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(18, 0, 0, 0), 50, 0));
        this.getContentPane().add((Component)this.closeButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 17, 50, 201), 6, 0));
        this.getContentPane().add((Component)this.joinButton, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 12, 0, new Insets(42, 0, 93, 8), 14, 0));
        this.pack();
        this.center();
    }

    public static void main(String[] args) {
        try {
            Date gc = new Date();
            ChatMember chatMember = new ChatMember();
            chatMember.set_name("jj");
            ChatInfo chatInfo = new ChatInfo();
            chatInfo.set_currentMembers(3);
            chatInfo.set_description("Black holes");
            chatInfo.set_origin(gc);
            InfoFrame infoFrame = new InfoFrame(new DummyInfoConnectionStrategy(), chatInfo, null);
            infoFrame.setDefaultCloseOperation(3);
            infoFrame.show();
        }
        catch (InfoConnectionException ce) {
            System.out.println("unable to create chat frame");
        }
    }

    void joinButton_actionPerformed(ActionEvent e) {
        try {
            this.ics.getId(this.chatInfo);
            this.notifyOnClose(this);
        }
        catch (ConnectionException ce) {
            System.out.println("Join button catches exception:");
            System.out.println(ce);
        }
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.notifyOnClose(this);
    }
}

