/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.XalanExecutor;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.w3c.dom.Document;

public class AggregateTransformer {
    public static final String FRAMES = "frames";
    public static final String NOFRAMES = "noframes";
    protected Task task;
    protected Document document;
    protected File styleDir;
    protected File toDir;
    protected String format;
    private static DocumentBuilderFactory privateDBFactory;
    protected static DocumentBuilderFactory dbfactory;

    public AggregateTransformer(Task task) {
        this.task = task;
    }

    protected static DocumentBuilderFactory getDocumentBuilderFactory() {
        return privateDBFactory;
    }

    public void setFormat(Format format) {
        this.format = format.getValue();
    }

    public void setXmlDocument(Document doc) {
        this.document = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setXmlfile(File xmlfile) throws BuildException {
        try {
            DocumentBuilder builder = privateDBFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(xmlfile);
            try {
                Document doc = builder.parse(in);
                this.setXmlDocument(doc);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            {
            }
        }
        catch (Exception e) {
            throw new BuildException("Error while parsing document: " + xmlfile, (Throwable)e);
        }
    }

    public void setStyledir(File styledir) {
        this.styleDir = styledir;
    }

    public void setTodir(File todir) {
        this.toDir = todir;
    }

    public void setExtension(String ext) {
        this.task.log("extension is not used anymore", 1);
    }

    public void transform() throws BuildException {
        this.checkOptions();
        long t0 = System.currentTimeMillis();
        try {
            XalanExecutor executor = XalanExecutor.newInstance(this);
            executor.execute();
        }
        catch (Exception e) {
            throw new BuildException("Errors while applying transformations", (Throwable)e);
        }
        long dt = System.currentTimeMillis() - t0;
        this.task.log("Transform time: " + dt + "ms");
    }

    protected void checkOptions() throws BuildException {
        if (this.toDir == null) {
            this.toDir = this.task.getProject().resolveFile(".");
        } else if (!this.toDir.isAbsolute()) {
            this.toDir = this.task.getProject().resolveFile(this.toDir.getPath());
        }
    }

    protected String getStylesheetSystemId() throws IOException {
        String xslname = "junit-frames.xsl";
        if (NOFRAMES.equals(this.format)) {
            xslname = "junit-noframes.xsl";
        }
        URL url = null;
        if (this.styleDir == null) {
            url = this.getClass().getResource("xsl/" + xslname);
            if (url == null) {
                throw new FileNotFoundException("Could not find jar resource " + xslname);
            }
        } else {
            File file = new File(this.styleDir, xslname);
            if (!file.exists()) {
                throw new FileNotFoundException("Could not find file '" + file + "'");
            }
            url = new URL("file", "", file.getAbsolutePath());
        }
        return url.toExternalForm();
    }

    static {
        FRAMES = FRAMES;
        NOFRAMES = NOFRAMES;
        dbfactory = privateDBFactory = DocumentBuilderFactory.newInstance();
    }

    public static class Format
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{AggregateTransformer.FRAMES, AggregateTransformer.NOFRAMES};
        }
    }
}

