/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.InterfaceInfoImpl;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.WeakClassCache;

public class IntrospectionTypeInfoFactoryImpl
extends WeakClassCache
implements TypeInfoFactory {
    public void generateTypeInfo(Class clazz, ClassInfoImpl classInfoImpl) {
    }

    public ClassInfo getSuperClass(Class clazz) {
        Class clazz2;
        ClassInfoImpl classInfoImpl = null;
        if (!clazz.isInterface() && (clazz2 = clazz.getSuperclass()) != null) {
            classInfoImpl = (ClassInfoImpl)this.getTypeInfo(clazz2);
        }
        return classInfoImpl;
    }

    public AnnotationValue[] getAnnotations(Object object) {
        return new AnnotationValue[0];
    }

    public ConstructorInfoImpl[] getConstructors(Class clazz, ClassInfo classInfo) {
        Constructor[] constructorArray;
        ConstructorInfoImpl[] constructorInfoImplArray = null;
        if (!clazz.isInterface() && (constructorArray = this.getDeclaredConstructors(clazz)) != null && constructorArray.length > 0) {
            constructorInfoImplArray = new ConstructorInfoImpl[constructorArray.length];
            for (int i = 0; i < constructorArray.length; ++i) {
                AnnotationValue[] annotationValueArray = this.getAnnotations(constructorArray[i]);
                constructorInfoImplArray[i] = new ConstructorInfoImpl(annotationValueArray, this.getTypeInfos(constructorArray[i].getParameterTypes()), this.getClassInfos(constructorArray[i].getExceptionTypes()), constructorArray[i].getModifiers(), (ClassInfo)this.getTypeInfo(constructorArray[i].getDeclaringClass()));
                constructorInfoImplArray[i].setConstructor(constructorArray[i]);
            }
        }
        return constructorInfoImplArray;
    }

    public FieldInfoImpl[] getFields(Class clazz, ClassInfo classInfo) {
        Field[] fieldArray = this.getDeclaredFields(clazz);
        if (fieldArray == null || fieldArray.length == 0) {
            return null;
        }
        FieldInfoImpl[] fieldInfoImplArray = new FieldInfoImpl[fieldArray.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            AnnotationValue[] annotationValueArray = this.getAnnotations(fieldArray[i]);
            fieldInfoImplArray[i] = new FieldInfoImpl(annotationValueArray, fieldArray[i].getName(), this.getTypeInfo(fieldArray[i].getType()), fieldArray[i].getModifiers(), (ClassInfo)this.getTypeInfo(fieldArray[i].getDeclaringClass()));
            fieldInfoImplArray[i].setField(fieldArray[i]);
        }
        return fieldInfoImplArray;
    }

    public MethodInfoImpl[] getMethods(Class clazz, ClassInfo classInfo) {
        Method[] methodArray = this.getDeclaredMethods(clazz);
        if (methodArray == null || methodArray.length == 0) {
            return null;
        }
        MethodInfoImpl[] methodInfoImplArray = new MethodInfoImpl[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            AnnotationValue[] annotationValueArray = this.getAnnotations(methodArray[i]);
            methodInfoImplArray[i] = new MethodInfoImpl(annotationValueArray, methodArray[i].getName(), this.getTypeInfo(methodArray[i].getReturnType()), this.getTypeInfos(methodArray[i].getParameterTypes()), this.getClassInfos(methodArray[i].getExceptionTypes()), methodArray[i].getModifiers(), (ClassInfo)this.getTypeInfo(methodArray[i].getDeclaringClass()));
            methodInfoImplArray[i].setMethod(methodArray[i]);
        }
        return methodInfoImplArray;
    }

    public InterfaceInfo[] getInterfaces(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray == null || classArray.length == 0) {
            return null;
        }
        InterfaceInfo[] interfaceInfoArray = new InterfaceInfo[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            interfaceInfoArray[i] = (InterfaceInfo)this.getTypeInfo(classArray[i]);
        }
        return interfaceInfoArray;
    }

    public TypeInfo[] getTypeInfos(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return null;
        }
        TypeInfo[] typeInfoArray = new TypeInfo[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            typeInfoArray[i] = this.getTypeInfo(classArray[i]);
        }
        return typeInfoArray;
    }

    public ClassInfo[] getClassInfos(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return null;
        }
        ClassInfo[] classInfoArray = new ClassInfo[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classInfoArray[i] = (ClassInfo)this.getTypeInfo(classArray[i]);
        }
        return classInfoArray;
    }

    public TypeInfo getTypeInfo(Class clazz) {
        PrimitiveInfo primitiveInfo = PrimitiveInfo.valueOf(clazz.getName());
        if (primitiveInfo != null) {
            return primitiveInfo;
        }
        return (TypeInfo)this.get(clazz);
    }

    public TypeInfo getTypeInfo(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(string);
        return this.getTypeInfo(clazz);
    }

    protected Object instantiate(Class clazz) {
        ClassInfoImpl classInfoImpl = clazz.isInterface() ? new InterfaceInfoImpl(clazz.getName()) : new ClassInfoImpl(clazz.getName());
        classInfoImpl.setType(clazz);
        classInfoImpl.setTypeInfoFactory(this);
        return classInfoImpl;
    }

    protected void generate(Class clazz, Object object) {
        this.generateTypeInfo(clazz, (ClassInfoImpl)object);
    }

    protected Constructor[] getDeclaredConstructors(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredConstructors();
        }
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredConstructors();
            }
        };
        return (Constructor[])AccessController.doPrivileged(privilegedAction);
    }

    protected Field[] getDeclaredFields(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredFields();
        }
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        };
        return (Field[])AccessController.doPrivileged(privilegedAction);
    }

    protected Method[] getDeclaredMethods(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethods();
        }
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredMethods();
            }
        };
        return (Method[])AccessController.doPrivileged(privilegedAction);
    }
}

