/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import java.util.Iterator;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import org.jbpm.bpel.graph.basic.Invoke;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.integration.def.Correlation;
import org.jbpm.bpel.integration.def.CorrelationSetDefinition;
import org.jbpm.bpel.integration.def.Correlations;
import org.jbpm.bpel.integration.def.InvokeAction;
import org.jbpm.bpel.integration.def.PartnerLinkDefinition;
import org.jbpm.bpel.variable.def.VariableDefinition;
import org.jbpm.bpel.wsdl.PartnerLinkType;
import org.jbpm.bpel.xml.ActivityReader;
import org.jbpm.bpel.xml.ParseProblem;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;

public class InvokeReader
extends ActivityReader {
    public Activity read(Element activityElem, CompositeActivity parent) {
        Element faultHandlersElem = XmlUtil.getElement(activityElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "faultHandlers");
        Element compensationHandlerElem = XmlUtil.getElement(activityElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "compensationHandler");
        if (compensationHandlerElem == null && faultHandlersElem == null) {
            Invoke invoke = new Invoke();
            this.readStandardProperties(activityElem, invoke, parent);
            this.readInvoke(activityElem, invoke);
            return invoke;
        }
        Scope scope = new Scope();
        scope.installFaultExceptionHandler();
        scope.setImplicit(true);
        this.readStandardProperties(activityElem, scope, parent);
        if (compensationHandlerElem != null) {
            this.bpelReader.readCompensationHandler(compensationHandlerElem, scope);
        }
        if (faultHandlersElem != null) {
            this.bpelReader.readFaultHandlers(faultHandlersElem, scope);
        }
        Invoke invoke = new Invoke();
        scope.setActivity(invoke);
        this.readInvoke(activityElem, invoke);
        return scope;
    }

    public void readInvoke(Element invokeElem, Invoke invoke) {
        this.validateNonInitial(invokeElem, invoke);
        invoke.setAction(this.readInvokeAction(invokeElem, invoke.getCompositeActivity()));
    }

    public InvokeAction readInvokeAction(Element invokeElem, CompositeActivity parent) {
        Element correlationsElem;
        InvokeAction invokeAction = new InvokeAction();
        String partnerLinkName = invokeElem.getAttribute("partnerLink");
        PartnerLinkDefinition partnerLink = parent.findPartnerLink(partnerLinkName);
        if (partnerLink == null) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("partner link not found", invokeElem));
            return invokeAction;
        }
        invokeAction.setPartnerLink(partnerLink);
        PartnerLinkType.Role partnerRole = partnerLink.getPartnerRole();
        if (partnerRole == null) {
            this.bpelReader.getProblemHandler().add(new ParseProblem("partner link does not indicate partner role", invokeElem));
            return invokeAction;
        }
        PortType portType = this.bpelReader.getMessageActivityPortType(invokeElem, partnerRole);
        Operation operation = this.bpelReader.getMessageActivityOperation(invokeElem, portType);
        invokeAction.setOperation(operation);
        VariableDefinition input = this.bpelReader.getMessageActivityVariable(invokeElem, "inputVariable", parent, operation.getInput().getMessage());
        invokeAction.setInputVariable(input);
        VariableDefinition output = null;
        if (operation.getStyle() == OperationType.REQUEST_RESPONSE) {
            output = this.bpelReader.getMessageActivityVariable(invokeElem, "outputVariable", parent, operation.getOutput().getMessage());
            invokeAction.setOutputVariable(output);
        }
        if ((correlationsElem = XmlUtil.getElement(invokeElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "correlations")) != null) {
            Correlations inCorrelations = new Correlations();
            Correlations outCorrelations = new Correlations();
            Iterator correlationElemIt = XmlUtil.getElements(correlationsElem, "http://schemas.xmlsoap.org/ws/2004/03/business-process/", "correlation");
            while (correlationElemIt.hasNext()) {
                Element correlationElem = (Element)correlationElemIt.next();
                Correlation correlation = this.bpelReader.readCorrelation(correlationElem, parent);
                CorrelationSetDefinition set = correlation.getSet();
                Correlation.Pattern pattern = Correlation.Pattern.valueOf(correlationElem.getAttribute("pattern"));
                if (pattern == null) {
                    this.bpelReader.getProblemHandler().add(new ParseProblem("invalid pattern", correlationElem));
                    continue;
                }
                if (pattern != Correlation.Pattern.RESPONSE) {
                    this.bpelReader.checkVariableProperties(input, set, correlationElem);
                    outCorrelations.addCorrelation(correlation);
                }
                if (pattern == Correlation.Pattern.REQUEST) continue;
                if (output != null) {
                    this.bpelReader.checkVariableProperties(output, set, correlationElem);
                } else {
                    this.bpelReader.getProblemHandler().add(new ParseProblem("correlation cannot apply to inbound message in one-way operation", correlationElem));
                }
                inCorrelations.addCorrelation(correlation);
            }
            if (inCorrelations.getCorrelations() != null) {
                invokeAction.setInCorrelations(inCorrelations);
            }
            if (outCorrelations.getCorrelations() != null) {
                invokeAction.setOutCorrelations(outCorrelations);
            }
        }
        return invokeAction;
    }
}

