/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.type;

import cirrus.hibernate.AssertionFailure;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.persister.ClassPersister;
import cirrus.hibernate.type.AbstractType;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class EntityType
extends AbstractType {
    private final Class persistentClass;
    private final boolean niceEquals;

    public final boolean isEntityType() {
        return true;
    }

    public final Class getPersistentClass() {
        return this.persistentClass;
    }

    public final boolean equals(Object x, Object y) {
        return x == y;
    }

    protected EntityType(Class persistentClass) {
        this.persistentClass = persistentClass;
        this.niceEquals = !ReflectHelper.overridesEquals(persistentClass);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public final Class returnedClass() {
        return this.persistentClass;
    }

    protected Serializable getID(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Serializable id = session.getID(value);
        if (id == null) {
            try {
                id = session.getFactory().getPersister(this.persistentClass).getIdentifier(value);
            }
            catch (HibernateException he) {
                throw new HibernateException("object references a transient instance - save the transient instance first");
            }
        }
        return id;
    }

    public String toXML(Object value, SessionFactoryImplementor factory) throws HibernateException {
        ClassPersister persister = factory.getPersister(this.persistentClass);
        return value == null ? null : persister.getIdentifierType().toXML(persister.getIdentifier(value), factory);
    }

    public String getName() {
        return this.persistentClass.getName();
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public abstract boolean isOneToOne();

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Serializable id = session.getID(value);
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id");
        }
        return id;
    }

    public Object assemble(Serializable oid, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolveIdentifier(oid, session);
    }

    public boolean hasNiceEquals() {
        return this.niceEquals;
    }

    public boolean isAssociationType() {
        return true;
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolveIdentifier(this.hydrate(rs, names, session, owner), session);
    }

    public abstract Object hydrate(ResultSet var1, String[] var2, SessionImplementor var3, Object var4) throws HibernateException, SQLException;
}

