/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.test;

import cirrus.hibernate.LockMode;
import cirrus.hibernate.Session;
import cirrus.hibernate.Transaction;
import cirrus.hibernate.test.LessSimple;
import cirrus.hibernate.test.Multi;
import cirrus.hibernate.test.Po;
import cirrus.hibernate.test.Simple;
import cirrus.hibernate.test.SubMulti;
import cirrus.hibernate.test.TestCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public class MultiTableTest
extends TestCase {
    static /* synthetic */ Class class$cirrus$hibernate$test$Multi;
    static /* synthetic */ Class class$cirrus$hibernate$test$SubMulti;
    static /* synthetic */ Class class$cirrus$hibernate$test$Simple;
    static /* synthetic */ Class class$cirrus$hibernate$test$LessSimple;
    static /* synthetic */ Class class$cirrus$hibernate$test$Po;
    static /* synthetic */ Class class$cirrus$hibernate$test$MultiTableTest;

    public MultiTableTest(String arg0) {
        super(arg0);
    }

    public void testConstraints() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        SubMulti sm = new SubMulti();
        sm.setAmount(66.5f);
        s.save(sm, new Long(2L));
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.delete("from sm in class SubMulti");
        t = s.beginTransaction();
        t.commit();
        s.close();
    }

    public void testMultiTable() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Multi multi = new Multi();
        multi.setExtraProp("extra");
        multi.setName("name");
        Simple simp = new Simple();
        simp.setDate(new Date());
        simp.setName("simp");
        s.save(multi, new Long(123L));
        s.save(simp, new Long(1234L));
        SubMulti sm = new SubMulti();
        sm.setAmount(66.5f);
        s.save(sm, new Long(2L));
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        multi.setExtraProp(multi.getExtraProp() + "2");
        multi.setName("new name");
        s.update(multi, new Long(123L));
        simp.setName("new name");
        s.update(simp, new Long(1234L));
        sm.setAmount(456.7f);
        s.update(sm, new Long(2L));
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        multi = (Multi)s.load(class$cirrus$hibernate$test$Multi == null ? (class$cirrus$hibernate$test$Multi = MultiTableTest.class$("cirrus.hibernate.test.Multi")) : class$cirrus$hibernate$test$Multi, (Serializable)new Long(123L));
        Assert.assertTrue((boolean)multi.getExtraProp().equals("extra2"));
        multi.setExtraProp(multi.getExtraProp() + "3");
        Assert.assertTrue((boolean)multi.getName().equals("new name"));
        multi.setName("newer name");
        sm = (SubMulti)s.load(class$cirrus$hibernate$test$SubMulti == null ? (class$cirrus$hibernate$test$SubMulti = MultiTableTest.class$("cirrus.hibernate.test.SubMulti")) : class$cirrus$hibernate$test$SubMulti, (Serializable)new Long(2L));
        Assert.assertTrue((sm.getAmount() == 456.7f ? 1 : 0) != 0);
        sm.setAmount(23423.0f);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        multi = (Multi)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = MultiTableTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, (Serializable)new Long(123L));
        simp = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = MultiTableTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, (Serializable)new Long(1234L));
        Assert.assertTrue((!(simp instanceof Multi) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(multi instanceof Multi));
        Assert.assertTrue((boolean)multi.getExtraProp().equals("extra23"));
        Assert.assertTrue((boolean)multi.getName().equals("newer name"));
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        Iterator iter = s.iterate("select\n\ns from s in class Simple where s.count>0");
        boolean foundSimp = false;
        boolean foundMulti = false;
        boolean foundSubMulti = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Simple && !(o instanceof Multi)) {
                foundSimp = true;
            }
            if (o instanceof Multi && !(o instanceof SubMulti)) {
                foundMulti = true;
            }
            if (!(o instanceof SubMulti)) continue;
            foundSubMulti = true;
        }
        Assert.assertTrue((foundSimp && foundMulti && foundSubMulti ? 1 : 0) != 0);
        s.find("from m in class Multi where m.count>0 and m.extraProp is not null");
        s.find("from m in class Simple where m.count>0 and m.name is not null");
        s.find("from m in class LessSimple where m.other is not null");
        s.find("from m in class Multi where m.other.id = 1");
        s.find("from m in class SubMulti where m.amount > 0.0");
        Assert.assertTrue((s.find("from m in class Multi").size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from s in class Simple").size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from ls in class LessSimple").size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from sm in class SubMulti").size() == 1 ? 1 : 0) != 0);
        s.find("from ls in class LessSimple, s in ls.bag.elements where s.id is not null");
        s.find("from sm in class SubMulti where exists sm.children.elements");
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        multi = (Multi)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = MultiTableTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, new Long(123L), LockMode.UPGRADE);
        simp = (Simple)s.load(class$cirrus$hibernate$test$Simple == null ? (class$cirrus$hibernate$test$Simple = MultiTableTest.class$("cirrus.hibernate.test.Simple")) : class$cirrus$hibernate$test$Simple, (Serializable)new Long(1234L));
        s.lock(simp, LockMode.UPGRADE_NOWAIT);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        s.update(multi, new Long(123L));
        s.delete(multi);
        Assert.assertTrue((s.delete("from s in class Simple") == 2 ? 1 : 0) != 0);
        t.commit();
        s.close();
    }

    public void testMultiTableCollections() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Assert.assertTrue((s.find("from s in class Simple").size() == 0 ? 1 : 0) != 0);
        Multi multi = new Multi();
        multi.setExtraProp("extra");
        multi.setName("name");
        Simple simp = new Simple();
        simp.setDate(new Date());
        simp.setName("simp");
        s.save(multi, new Long(123L));
        s.save(simp, new Long(1234L));
        LessSimple ls = new LessSimple();
        ls.setOther(ls);
        ls.setAnother(ls);
        ls.setYetanother(ls);
        ls.setName("Less Simple");
        HashSet<Simple> set = new HashSet<Simple>();
        ls.setSet(set);
        set.add(multi);
        set.add(simp);
        s.save(ls, new Long(2L));
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        ls = (LessSimple)s.load(class$cirrus$hibernate$test$LessSimple == null ? (class$cirrus$hibernate$test$LessSimple = MultiTableTest.class$("cirrus.hibernate.test.LessSimple")) : class$cirrus$hibernate$test$LessSimple, (Serializable)new Long(2L));
        Assert.assertTrue((ls.getOther() == ls && ls.getAnother() == ls && ls.getYetanother() == ls ? 1 : 0) != 0);
        Assert.assertTrue((ls.getSet().size() == 2 ? 1 : 0) != 0);
        Iterator iter = ls.getSet().iterator();
        int foundMulti = 0;
        int foundSimple = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof Simple) {
                ++foundSimple;
            }
            if (!(o instanceof Multi)) continue;
            ++foundMulti;
        }
        Assert.assertTrue((foundSimple == 2 && foundMulti == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.delete("from s in class Simple") == 3 ? 1 : 0) != 0);
        t.commit();
        s.close();
    }

    public void testMultiTableNativeId() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Multi multi = new Multi();
        multi.setExtraProp("extra");
        Long id = (Long)s.save(multi);
        Assert.assertTrue((id != null ? 1 : 0) != 0);
        s.delete(multi);
        t.commit();
        s.close();
    }

    public void testCollection() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Multi multi1 = new Multi();
        multi1.setExtraProp("extra1");
        Multi multi2 = new Multi();
        multi2.setExtraProp("extra2");
        Po po = new Po();
        multi1.setPo(po);
        multi2.setPo(po);
        po.setSet(new HashSet());
        po.getSet().add(multi1);
        po.getSet().add(multi2);
        po.setList(new ArrayList());
        po.getList().add(new SubMulti());
        Serializable id = s.save(po);
        Assert.assertTrue((id != null ? 1 : 0) != 0);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        po = (Po)s.load(class$cirrus$hibernate$test$Po == null ? (class$cirrus$hibernate$test$Po = MultiTableTest.class$("cirrus.hibernate.test.Po")) : class$cirrus$hibernate$test$Po, id);
        Assert.assertTrue((po.getSet().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((po.getList().size() == 1 ? 1 : 0) != 0);
        s.delete(po);
        Assert.assertTrue((s.find("from s in class Simple").size() == 0 ? 1 : 0) != 0);
        t.commit();
        s.close();
    }

    public void testOneToOne() throws Exception {
        Session s = TestCase.sessions.openSession();
        LessSimple ls = new LessSimple();
        Serializable id = s.save(ls);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.load(class$cirrus$hibernate$test$LessSimple == null ? (class$cirrus$hibernate$test$LessSimple = MultiTableTest.class$("cirrus.hibernate.test.LessSimple")) : class$cirrus$hibernate$test$LessSimple, id);
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.delete(s.load(class$cirrus$hibernate$test$LessSimple == null ? (class$cirrus$hibernate$test$LessSimple = MultiTableTest.class$("cirrus.hibernate.test.LessSimple")) : class$cirrus$hibernate$test$LessSimple, id));
        s.flush();
        s.connection().commit();
        s.close();
    }

    public static Test suite() throws Exception {
        try {
            TestCase.exportSchema(new String[]{"Multi.hbm.xml"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new TestSuite(class$cirrus$hibernate$test$MultiTableTest == null ? (class$cirrus$hibernate$test$MultiTableTest = MultiTableTest.class$("cirrus.hibernate.test.MultiTableTest")) : class$cirrus$hibernate$test$MultiTableTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

