/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.impl.ScheduledCollectionAction;
import cirrus.hibernate.impl.SessionImpl;
import java.io.Serializable;
import java.sql.SQLException;

final class ScheduledCollectionUpdate
extends ScheduledCollectionAction
implements SessionImpl.Executable {
    private final PersistentCollection collection;

    public ScheduledCollectionUpdate(PersistentCollection collection, CollectionPersister persister, Serializable id, SessionImplementor session) {
        super(persister, id, session);
        this.collection = collection;
    }

    public void execute() throws SQLException, HibernateException {
        this.persister.softlock(this.id);
        if (this.collection.empty()) {
            this.persister.remove(this.id, this.session);
        } else if (this.collection.needsRecreate(this.persister.getElementType())) {
            this.persister.remove(this.id, this.session);
            this.persister.recreate(this.collection, this.id, this.session);
        } else {
            this.persister.deleteRows(this.collection, this.id, this.session);
            this.persister.updateRows(this.collection, this.id, this.session);
            this.persister.insertRows(this.collection, this.id, this.session);
        }
    }
}

