/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.Hibernate;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.PropertyNotFoundException;
import cirrus.hibernate.Query;
import cirrus.hibernate.ScrollableResults;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.ArrayHelper;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class QueryImpl
implements Query {
    final SessionImplementor session;
    String queryString;
    RowSelection selection;
    ArrayList values = new ArrayList(4);
    ArrayList types = new ArrayList(4);
    Map namedParams = new HashMap(4);
    static final Type[] NO_TYPES = new Type[0];

    public QueryImpl(String queryString, SessionImplementor session) {
        this.session = session;
        this.queryString = queryString;
        this.selection = new RowSelection();
    }

    public Iterator iterate() throws SQLException, HibernateException {
        return this.session.iterate(this.queryString, this.values.toArray(), this.types.toArray(NO_TYPES), this.selection, this.namedParams);
    }

    public ScrollableResults scroll() throws SQLException, HibernateException {
        return this.session.scroll(this.queryString, this.values.toArray(), this.types.toArray(NO_TYPES), this.selection, this.namedParams);
    }

    public List list() throws SQLException, HibernateException {
        return this.session.find(this.queryString, this.values.toArray(), this.types.toArray(NO_TYPES), this.selection, this.namedParams);
    }

    public void setMaxResults(int maxResults) {
        this.selection.maxRows = new Integer(maxResults);
    }

    public void setTimeout(int timeout) {
        this.selection.timeout = new Integer(timeout);
    }

    public void setFirstResult(int firstResult) {
        this.selection.firstRow = new Integer(firstResult);
    }

    public void setParameter(int position, Object val, Type type) {
        int size = this.values.size();
        if (position < size) {
            this.values.set(position, val);
            this.types.set(position, type);
        } else {
            int i = 0;
            while (i < position - size) {
                this.values.add(null);
                this.types.add(null);
                ++i;
            }
            this.values.add(val);
            this.types.add(type);
        }
    }

    public void setString(int position, String val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.STRING);
    }

    public void setCharacter(int position, char val) {
        this.setParameter(position, (Object)new Character(val), (Type)Hibernate.CHARACTER);
    }

    public void setBoolean(int position, boolean val) {
        this.setParameter(position, (Object)new Boolean(val), (Type)Hibernate.BOOLEAN);
    }

    public void setByte(int position, byte val) {
        this.setParameter(position, (Object)new Byte(val), (Type)Hibernate.BYTE);
    }

    public void setShort(int position, short val) {
        this.setParameter(position, (Object)new Short(val), (Type)Hibernate.SHORT);
    }

    public void setInteger(int position, int val) {
        this.setParameter(position, (Object)new Integer(val), (Type)Hibernate.INTEGER);
    }

    public void setLong(int position, long val) {
        this.setParameter(position, (Object)new Long(val), (Type)Hibernate.LONG);
    }

    public void setFloat(int position, float val) {
        this.setParameter(position, (Object)new Float(val), (Type)Hibernate.FLOAT);
    }

    public void setDouble(int position, double val) {
        this.setParameter(position, (Object)new Double(val), (Type)Hibernate.DOUBLE);
    }

    public void setBinary(int position, byte[] val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.BINARY);
    }

    public void setSerializable(int position, Serializable val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.SERIALIZABLE);
    }

    public void setDate(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)Hibernate.DATE);
    }

    public void setTime(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)Hibernate.TIME);
    }

    public void setTimestamp(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)Hibernate.TIMESTAMP);
    }

    public void setEntity(int position, Object val) {
        this.setParameter(position, val, Hibernate.association(val.getClass()));
    }

    public void setEnum(int position, Object val) throws MappingException {
        this.setParameter(position, val, Hibernate.enum(val.getClass()));
    }

    public void setLocale(int position, Locale locale) {
        this.setParameter(position, (Object)locale, (Type)Hibernate.LOCALE);
    }

    public void setCalendar(int position, Calendar calendar) {
        this.setParameter(position, (Object)calendar, (Type)Hibernate.CALENDAR);
    }

    public void setCalendarDate(int position, Calendar calendar) {
        this.setParameter(position, (Object)calendar, (Type)Hibernate.CALENDAR_DATE);
    }

    public void setBinary(String name, byte[] val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.BINARY);
    }

    public void setBoolean(String name, boolean val) {
        this.setParameter(name, (Object)new Boolean(val), (Type)Hibernate.BOOLEAN);
    }

    public void setByte(String name, byte val) {
        this.setParameter(name, (Object)new Byte(val), (Type)Hibernate.BYTE);
    }

    public void setCharacter(String name, char val) {
        this.setParameter(name, (Object)new Character(val), (Type)Hibernate.CHARACTER);
    }

    public void setDate(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)Hibernate.DATE);
    }

    public void setDouble(String name, double val) {
        this.setParameter(name, (Object)new Double(val), (Type)Hibernate.DOUBLE);
    }

    public void setEntity(String name, Object val) {
        this.setParameter(name, val, Hibernate.association(val.getClass()));
    }

    public void setEnum(String name, Object val) throws MappingException {
        this.setParameter(name, val, Hibernate.enum(val.getClass()));
    }

    public void setFloat(String name, float val) {
        this.setParameter(name, (Object)new Float(val), (Type)Hibernate.FLOAT);
    }

    public void setInteger(String name, int val) {
        this.setParameter(name, (Object)new Integer(val), (Type)Hibernate.INTEGER);
    }

    public void setLocale(String name, Locale locale) {
        this.setParameter(name, (Object)locale, (Type)Hibernate.LOCALE);
    }

    public void setCalendar(String name, Calendar calendar) {
        this.setParameter(name, (Object)calendar, (Type)Hibernate.CALENDAR);
    }

    public void setCalendarDate(String name, Calendar calendar) {
        this.setParameter(name, (Object)calendar, (Type)Hibernate.CALENDAR_DATE);
    }

    public void setLong(String name, long val) {
        this.setParameter(name, (Object)new Long(val), (Type)Hibernate.LONG);
    }

    public void setParameter(String name, Object val, Type type) {
        this.namedParams.put(name, new TypedValue(type, val));
    }

    public void setSerializable(String name, Serializable val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.SERIALIZABLE);
    }

    public void setShort(String name, short val) {
        this.setParameter(name, (Object)new Short(val), (Type)Hibernate.SHORT);
    }

    public void setString(String name, String val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.STRING);
    }

    public void setTime(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)Hibernate.TIME);
    }

    public void setTimestamp(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)Hibernate.TIMESTAMP);
    }

    public void setBigDecimal(int position, BigDecimal number) {
        this.setParameter(position, (Object)number, (Type)Hibernate.BIG_DECIMAL);
    }

    public void setBigDecimal(String name, BigDecimal number) {
        this.setParameter(name, (Object)number, (Type)Hibernate.BIG_DECIMAL);
    }

    public void setParameter(int position, Object val) throws HibernateException {
        this.setParameter(position, val, this.guessType(val));
    }

    public void setParameter(String name, Object val) throws HibernateException {
        this.setParameter(name, val, this.guessType(val));
    }

    private Type guessType(Object param) throws HibernateException {
        Class<?> clazz = param.getClass();
        return this.guessType(clazz);
    }

    private Type guessType(Class clazz) throws HibernateException {
        String typename = clazz.getName();
        Type type = TypeFactory.hueristicType(typename);
        if (type == null) {
            try {
                this.session.getFactory().getPersister(clazz);
            }
            catch (MappingException me) {
                throw new HibernateException("Could not determine a type for class: " + typename);
            }
            type = Hibernate.association(clazz);
        }
        return type;
    }

    public Type[] getReturnTypes() throws HibernateException {
        return this.session.getFactory().getReturnTypes(this.queryString);
    }

    public void setParameterList(String name, Collection vals, Type type) throws HibernateException {
        StringBuffer list = new StringBuffer(16);
        Iterator iter = vals.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String alias = name + i++ + '_';
            this.setParameter(alias, iter.next(), type);
            list.append(':' + alias);
            if (!iter.hasNext()) continue;
            list.append(", ");
        }
        this.queryString = StringHelper.replaceOnce(this.queryString, ':' + name, list.toString());
    }

    public void setParameterList(String name, Collection vals) throws HibernateException {
        this.setParameterList(name, vals, this.guessType(vals.iterator().next()));
    }

    public String[] getNamedParameters() throws HibernateException {
        return ArrayHelper.toStringArray(this.session.getFactory().getNamedParameters(this.queryString));
    }

    public void setProperties(Object bean) throws HibernateException {
        Class<?> clazz = bean.getClass();
        Iterator iter = this.session.getFactory().getNamedParameters(this.queryString).iterator();
        while (iter.hasNext()) {
            String namedParam = (String)iter.next();
            try {
                ReflectHelper.Getter getter = ReflectHelper.getGetter(clazz, namedParam);
                this.setParameter(namedParam, getter.get(bean), this.guessType(getter.getReturnType()));
            }
            catch (PropertyNotFoundException pnfe) {
                // empty catch block
            }
        }
    }

    public static final class RowSelection {
        public Integer firstRow;
        public Integer maxRows;
        public Integer timeout;
    }

    public static final class TypedValue {
        public Type type;
        public Object value;

        protected TypedValue(Type t, Object o) {
            this.type = t;
            this.value = o;
        }
    }
}

