/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.helpers;

import cirrus.hibernate.AssertionFailure;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.PropertyAccessException;
import cirrus.hibernate.PropertyNotFoundException;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class ReflectHelper {
    private static final Class[] NO_CLASSES;
    private static final Class[] OBJECT;
    private static final Method OBJECT_EQUALS;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean overridesEquals(Class clazz) {
        Method equals;
        try {
            equals = clazz.getMethod("equals", OBJECT);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static Method getMethod(Class theClass, String methodName) throws PropertyNotFoundException {
        Method result;
        if (theClass == (class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object) || theClass == null) {
            throw new PropertyNotFoundException("Could not find a setter");
        }
        try {
            result = theClass.getDeclaredMethod(methodName, null);
        }
        catch (Exception e) {
            try {
                return ReflectHelper.getMethod(theClass.getSuperclass(), methodName);
            }
            catch (PropertyNotFoundException me) {
                throw new PropertyNotFoundException("Could not find method " + methodName + " in class " + theClass.getName());
            }
        }
        if (!ReflectHelper.isPublic(theClass, result)) {
            result.setAccessible(true);
        }
        return result;
    }

    public static Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        if (theClass == (class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object) || theClass == null) {
            throw new PropertyNotFoundException("Could not find a setter");
        }
        Method result = ReflectHelper.setter(theClass, propertyName);
        if (result == null) {
            try {
                return ReflectHelper.getSetter(theClass.getSuperclass(), propertyName);
            }
            catch (PropertyNotFoundException me) {
                throw new PropertyNotFoundException("Could not find a setter for " + propertyName + " in class " + theClass.getName());
            }
        }
        if (!ReflectHelper.isPublic(theClass, result)) {
            result.setAccessible(true);
        }
        return new Setter(theClass, result, propertyName);
    }

    private static Method setter(Class theClass, String propertyName) throws PropertyNotFoundException {
        Class returnType = ReflectHelper.getGetter(theClass, propertyName).getReturnType();
        Method[] methods = theClass.getDeclaredMethods();
        Method potentialSetter = null;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().length() > 3 && methods[i].getName().startsWith("set")) {
                String testStdMethod = Introspector.decapitalize(methods[i].getName().substring(3));
                String testOldMethod = methods[i].getName().substring(3);
                if ((testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) && methods[i].getParameterTypes().length == 1) {
                    potentialSetter = methods[i];
                    if (methods[i].getParameterTypes()[0].equals(returnType)) {
                        return potentialSetter;
                    }
                }
            }
            ++i;
        }
        return potentialSetter;
    }

    public static Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        if (theClass == (class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object) || theClass == null) {
            throw new PropertyNotFoundException("Could not find a getter");
        }
        Method result = ReflectHelper.getter(theClass, propertyName);
        if (result == null) {
            try {
                return ReflectHelper.getGetter(theClass.getSuperclass(), propertyName);
            }
            catch (PropertyNotFoundException me) {
                throw new PropertyNotFoundException("Could not find a getter for " + propertyName + " in class " + theClass.getName());
            }
        }
        if (!ReflectHelper.isPublic(theClass, result)) {
            result.setAccessible(true);
        }
        return new Getter(theClass, result, propertyName);
    }

    private static Method getter(Class theClass, String propertyName) {
        Method[] methods = theClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getParameterTypes().length == 0) {
                String testOldMethod;
                String testStdMethod;
                if (methods[i].getName().length() > 3 && methods[i].getName().startsWith("get")) {
                    testStdMethod = Introspector.decapitalize(methods[i].getName().substring(3));
                    testOldMethod = methods[i].getName().substring(3);
                    if ((testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) && methods[i].getParameterTypes().length == 0) {
                        return methods[i];
                    }
                }
                if (methods[i].getName().length() > 2 && methods[i].getName().startsWith("is")) {
                    testStdMethod = Introspector.decapitalize(methods[i].getName().substring(2));
                    testOldMethod = methods[i].getName().substring(2);
                    if ((testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) && methods[i].getParameterTypes().length == 0) {
                        return methods[i];
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static Type reflectedPropertyType(Class theClass, String name) throws MappingException {
        return TypeFactory.hueristicType(ReflectHelper.getGetter(theClass, name).getReturnType().getName());
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static boolean isPublic(Class clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Object getConstantValue(String name) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(StringHelper.qualifier(name));
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        try {
            return clazz.getField(StringHelper.unqualify(name)).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getDefaultConstructor(Class clazz) throws PropertyNotFoundException {
        if (ReflectHelper.isAbstractClass(clazz)) {
            return null;
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(NO_CLASSES);
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException nme) {
            throw new PropertyNotFoundException("Object class " + clazz.getName() + " must declare a default (no-argument) constructor");
        }
    }

    public static boolean isAbstractClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method eq;
        NO_CLASSES = new Class[0];
        OBJECT = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object};
        try {
            eq = (class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", OBJECT);
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not find Object.equals()", e);
        }
        OBJECT_EQUALS = eq;
    }

    public static final class Getter {
        private Class clazz;
        private final Method method;
        private final String propertyName;

        private Getter(Class clazz, Method method, String propertyName) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = propertyName;
        }

        public Object get(Object target) throws HibernateException {
            try {
                return this.method.invoke(target, null);
            }
            catch (InvocationTargetException ite) {
                throw new PropertyAccessException(ite, "Exception occurred inside", false, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException iae) {
                throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", false, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException iae) {
                throw new PropertyAccessException(iae, "IllegalArgumentException occurred calling", false, this.clazz, this.propertyName);
            }
        }

        public Class getReturnType() {
            return this.method.getReturnType();
        }

        public Method getMethod() {
            return this.method;
        }
    }

    public static final class Setter {
        private Class clazz;
        private final Method method;
        private final String propertyName;

        private Setter(Class clazz, Method method, String propertyName) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = propertyName;
        }

        public void set(Object target, Object value) throws HibernateException {
            try {
                this.method.invoke(target, value);
            }
            catch (NullPointerException npe) {
                if (value == null && this.method.getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException(npe, "Null values was assigned to a property of primitive type", true, this.clazz, this.propertyName);
                }
                throw new PropertyAccessException(npe, "NullPointerException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (InvocationTargetException ite) {
                throw new PropertyAccessException(ite, "Exception occurred inside", true, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException iae) {
                throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException iae) {
                throw new PropertyAccessException(iae, "IllegalArgumentException occurred while calling", true, this.clazz, this.propertyName);
            }
        }
    }
}

