/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.collections;

import cirrus.hibernate.AssertionFailure;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.collections.ODMGCollection;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.odmg.DBag;

public class Bag
extends ODMGCollection
implements DBag,
List {
    private List bag;

    public Bag(SessionImplementor session) {
        super(session);
    }

    public Bag(SessionImplementor session, Collection coll) {
        super(session);
        if (coll instanceof List) {
            this.bag = (List)coll;
        } else {
            this.bag = new ArrayList();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                this.bag.add(iter.next());
            }
        }
        this.initialized = true;
    }

    public Iterator elements() {
        return this.bag.iterator();
    }

    public boolean empty() {
        return this.bag.isEmpty();
    }

    public void replaceElements(Map replacements) throws HibernateException {
        int i = 0;
        while (i < this.size()) {
            Object r;
            Object val = this.bag.get(i);
            if (val != null && (r = replacements.get(val)) != null) {
                this.bag.set(i, r);
            }
            ++i;
        }
    }

    public Iterator entries() {
        return this.bag.iterator();
    }

    public void readEntries(Iterator entries) {
        while (entries.hasNext()) {
            this.bag.add(entries.next());
        }
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, this.session);
        this.bag.add(element);
        return element;
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.session);
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.bag = new ArrayList();
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() != this.bag.size()) {
            return false;
        }
        Iterator iter = this.bag.iterator();
        while (iter.hasNext()) {
            Object elt = iter.next();
            if (this.countOccurrences(elt, this.bag, elementType) == this.countOccurrences(elt, sn, elementType)) continue;
            return false;
        }
        return true;
    }

    private int countOccurrences(Object element, List list, Type elementType) throws HibernateException {
        Iterator iter = list.iterator();
        int result = 0;
        while (iter.hasNext()) {
            if (!elementType.equals(element, iter.next())) continue;
            ++result;
        }
        return result;
    }

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        ArrayList<Object> clonedList = new ArrayList<Object>(this.bag.size());
        Iterator iter = this.bag.iterator();
        while (iter.hasNext()) {
            clonedList.add(persister.getElementType().deepCopy(iter.next()));
        }
        return clonedList;
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = this.bag.size();
        ArrayList<Serializable> result = new ArrayList<Serializable>(length);
        int i = 0;
        while (i < length) {
            result.add(persister.getElementType().disassemble(this.bag.get(i), this.session));
            ++i;
        }
        return result;
    }

    public void assemble(CollectionPersister persister) throws HibernateException, SQLException {
        int length = this.bag.size();
        List old = this.bag;
        this.beforeInitialize(persister);
        int i = 0;
        while (i < length) {
            this.bag.add(persister.getElementType().assemble((Serializable)old.get(i), this.session, null));
            ++i;
        }
    }

    public boolean needsRecreate(Type elemType) throws HibernateException {
        return true;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        throw new AssertionFailure("Not implemented for Bags");
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        throw new AssertionFailure("Not implemented for Bags");
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        throw new AssertionFailure("Not implemented for Bags");
    }

    public int size() {
        this.read();
        return this.bag.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.bag.isEmpty();
    }

    public boolean contains(Object o) {
        this.read();
        return this.bag.contains(o);
    }

    public Iterator iterator() {
        this.read();
        return new PersistentCollection.IteratorProxy(this, this.bag.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.bag.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.read();
        return this.bag.toArray(a);
    }

    public boolean add(Object o) {
        if (!this.queueAdd(o)) {
            this.write();
            return this.bag.add(o);
        }
        return true;
    }

    public boolean remove(Object o) {
        this.write();
        return this.bag.remove(o);
    }

    public boolean containsAll(Collection c) {
        this.read();
        return this.bag.containsAll(c);
    }

    public boolean addAll(Collection c) {
        if (!this.queueAddAll(c)) {
            this.write();
            return this.bag.addAll(c);
        }
        return c.size() > 0;
    }

    public boolean removeAll(Collection c) {
        this.write();
        return this.bag.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.write();
        return this.bag.retainAll(c);
    }

    public void clear() {
        this.write();
        this.bag.clear();
    }

    public Object getIndex(Object entry, int i) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    public Bag() {
    }

    public DBag difference(DBag arg0) {
        this.read();
        ArrayList list = new ArrayList(this.bag.size());
        list.addAll(this.bag);
        list.removeAll(this.bag);
        return new Bag(this.session, list);
    }

    public DBag intersection(DBag bag) {
        this.read();
        ArrayList list = new ArrayList(this.bag.size());
        list.addAll(this.bag);
        list.retainAll((Collection<?>)bag);
        return new Bag(this.session, list);
    }

    public int occurrences(Object o) {
        this.read();
        Iterator iter = this.bag.iterator();
        int result = 0;
        while (iter.hasNext()) {
            if (!o.equals(iter.next())) continue;
            ++result;
        }
        return result;
    }

    public DBag union(DBag bag) {
        this.read();
        ArrayList list = new ArrayList(this.bag.size() + bag.size());
        list.addAll(bag);
        list.addAll(this.bag);
        return new Bag(this.session, list);
    }

    public void add(int i, Object o) {
        this.write();
        this.bag.add(i, o);
    }

    public boolean addAll(int i, Collection c) {
        this.write();
        return this.bag.addAll(i, c);
    }

    public Object get(int i) {
        this.read();
        return this.bag.get(i);
    }

    public int indexOf(Object o) {
        this.read();
        return this.bag.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        this.read();
        return this.bag.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        this.read();
        return new PersistentCollection.ListIteratorProxy(this, this.bag.listIterator());
    }

    public ListIterator listIterator(int i) {
        this.read();
        return new PersistentCollection.ListIteratorProxy(this, this.bag.listIterator(i));
    }

    public Object remove(int i) {
        this.write();
        return this.bag.remove(i);
    }

    public Object set(int i, Object o) {
        this.write();
        return this.bag.set(i, o);
    }

    public List subList(int start, int end) {
        this.read();
        return new PersistentCollection.ListProxy(this, this.bag.subList(start, end));
    }
}

